/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightDamageTypes;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.tag.FrightsDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WitherBerryBushBlock
extends FrightsDelightBushBlock {
    public static final int GROW_RANGE = 1;
    public static final TagKey<Block> GROW_CONDITION_BLOCK = FrightsDelightTags.WITHER_BERRY_BUSH_GROW_CONDITIION;

    public WitherBerryBushBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
        return (BlockState)state.m_61124_((Property)GROW_CONDITION, (Comparable)Boolean.valueOf(WitherBerryBushBlock.hasGrowthCondition((LevelAccessor)level, pos, 1, GROW_CONDITION_BLOCK)));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.WITHER_BERRY));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        this.updateCondition(state, (LevelAccessor)level, pos);
        if (((Boolean)state.m_61143_((Property)GROW_CONDITION)).booleanValue() && i < 3 && random.m_188503_(5) == 0 && WitherBerryBushBlock.hasGrowBrightness(level.m_45524_(pos.m_7494_(), 0))) {
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, blockState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)GROW_CONDITION)).booleanValue() && WitherBerryBushBlock.hasGrowBrightness(level.m_45524_(pos.m_7494_(), 0))) {
            VoxelShape voxelShape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
            Vec3 vec3 = voxelShape.m_83215_().m_82399_();
            double d = (double)pos.m_123341_() + vec3.f_82479_;
            double e = (double)pos.m_123343_() + vec3.f_82481_;
            for (int i = 0; i < 3; ++i) {
                if (!random.m_188499_()) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.5 - random.m_188500_()), e + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i;
        boolean bl;
        if (!level.m_5776_()) {
            this.updateCondition(state, (LevelAccessor)level, pos);
        }
        boolean bl2 = bl = (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) == 3;
        if (!bl && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.f_46441_.m_188503_(2);
            WitherBerryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.WITHER_BERRY), j + (bl ? 1 : 0)));
            level.m_5594_((Player)null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, blockState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateCondition(state, (LevelAccessor)level, pos);
        super.m_214148_(level, random, pos, state);
    }

    @Override
    public DamageSource getDamageSource(Level level) {
        return FrightsDelightDamageTypes.getSimpleDamageSource(level, FrightsDelightDamageTypes.WITHER_BERRY_BUSH);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!level.m_5776_()) {
            this.updateCondition(state, level, pos);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void updateCondition(BlockState state, LevelAccessor level, BlockPos pos) {
        this.updateGrowthCondition(state, level, pos, 1, GROW_CONDITION_BLOCK, (Boolean)state.m_61143_((Property)GROW_CONDITION));
    }

    public static boolean hasGrowBrightness(int lightLevel) {
        return lightLevel <= 7;
    }
}

