/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class CandyBasketItem
extends class_1747 {
    private CandyBasketType candyBasketType;

    public CandyBasketItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public CandyBasketItem(class_2248 block, class_1792.class_1793 properties, CandyBasketType type) {
        this(block, properties);
        this.candyBasketType = type;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1268 offHand = usedHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 basketStack = player.method_5998(usedHand);
        class_1799 offHandStack = player.method_5998(offHand);
        if (player.method_18276()) {
            return this.shuffleItems(level, player, basketStack);
        }
        if (offHandStack.method_7960()) {
            return this.removeItem(level, player, offHand, basketStack, offHandStack);
        }
        return this.addItem(level, player, basketStack, offHandStack);
    }

    public class_1271<class_1799> shuffleItems(class_1937 level, class_1657 player, class_1799 basketStack) {
        class_9288 items = (class_9288)basketStack.method_57824(class_9334.field_49622);
        ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
        if (items != null) {
            for (class_1799 itemStack : items.method_59714()) {
                itemStackList.add(itemStack);
            }
            if (itemStackList.size() > 1) {
                for (int i = 0; i < itemStackList.size(); ++i) {
                    int randomIndex = (int)(Math.random() * (double)itemStackList.size());
                    class_1799 temp = (class_1799)itemStackList.get(randomIndex);
                    itemStackList.set(randomIndex, (class_1799)itemStackList.get(i));
                    itemStackList.set(i, temp);
                }
                basketStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(itemStackList));
                Supplier<class_3414> shuffleSound = this.candyBasketType.getShuffleSound();
                if (shuffleSound != null) {
                    level.method_55116((class_1297)player, shuffleSound.get(), class_3419.field_15248, Math.min(0.3f + 0.04f * (float)itemStackList.size(), 1.0f), 1.0f);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.get().trigger(serverPlayer);
                }
                return class_1271.method_22427((Object)basketStack);
            }
        }
        return class_1271.method_22430((Object)basketStack);
    }

    public class_1271<class_1799> removeItem(class_1937 level, class_1657 player, class_1268 offHand, class_1799 basketStack, class_1799 offHandStack) {
        class_9288 items = (class_9288)basketStack.method_57824(class_9334.field_49622);
        ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
        if (items != null) {
            for (class_1799 itemStack : items.method_59714()) {
                itemStackList.add(itemStack);
            }
            if (!itemStackList.isEmpty() && offHandStack.method_7960()) {
                class_1799 toRemove = (class_1799)itemStackList.removeLast();
                if (!player.method_31549().field_7477) {
                    player.method_6122(offHand, toRemove);
                }
                basketStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(itemStackList));
                Supplier<class_3414> removeSound = this.candyBasketType.getRemoveSound();
                if (removeSound != null) {
                    level.method_55116((class_1297)player, removeSound.get(), class_3419.field_15248, 0.4f, 1.0f);
                }
                return class_1271.method_22427((Object)basketStack);
            }
        }
        return class_1271.method_22430((Object)basketStack);
    }

    public class_1271<class_1799> addItem(class_1937 level, class_1657 player, class_1799 basketStack, class_1799 offHandStack) {
        if (!offHandStack.method_57826(class_9334.field_50075)) {
            return class_1271.method_22431((Object)offHandStack);
        }
        class_9288 items = (class_9288)basketStack.method_57824(class_9334.field_49622);
        ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
        if (items != null) {
            for (class_1799 itemStack : items.method_59714()) {
                itemStackList.add(itemStack);
            }
            if (itemStackList.size() < 9 && !offHandStack.method_7960()) {
                class_1799 toAdd = player.method_31549().field_7477 ? offHandStack.method_46651(1) : offHandStack.method_7971(1);
                itemStackList.add(toAdd);
                basketStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(itemStackList));
                Supplier<class_3414> addSound = this.candyBasketType.getAddSound();
                if (addSound != null) {
                    level.method_55116((class_1297)player, addSound.get(), class_3419.field_15248, 0.4f, 1.0f);
                }
                return class_1271.method_22427((Object)basketStack);
            }
        }
        return class_1271.method_22430((Object)basketStack);
    }
}

