/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.network;

import java.util.HashMap;
import net.mcreator.salvagefurnace.SalvageFurnaceMod;
import net.mcreator.salvagefurnace.procedures.GiveIronScrapA15Procedure;
import net.mcreator.salvagefurnace.procedures.GiveIronScrapA16Procedure;
import net.mcreator.salvagefurnace.procedures.GiveIronScrapA17Procedure;
import net.mcreator.salvagefurnace.procedures.GiveIronScrapA18Procedure;
import net.mcreator.salvagefurnace.world.inventory.GuiIronSalvageStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GuiIronSalvageStorageSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuiIronSalvageStorageSlotMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("salvage_furnace", "gui_iron_salvage_storage_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GuiIronSalvageStorageSlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new GuiIronSalvageStorageSlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GuiIronSalvageStorageSlotMessage> type() {
        return TYPE;
    }

    public static void handleData(GuiIronSalvageStorageSlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GuiIronSalvageStorageSlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GuiIronSalvageStorageMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 15 && changeType == 1) {
            GiveIronScrapA15Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 16 && changeType == 1) {
            GiveIronScrapA16Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 17 && changeType == 1) {
            GiveIronScrapA17Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 18 && changeType == 1) {
            GiveIronScrapA18Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SalvageFurnaceMod.addNetworkMessage(TYPE, STREAM_CODEC, GuiIronSalvageStorageSlotMessage::handleData);
    }
}

