/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.network;

import java.util.HashMap;
import net.mcreator.salvagefurnace.SalvageFurnaceMod;
import net.mcreator.salvagefurnace.procedures.GiveNetheriteScrapA15Procedure;
import net.mcreator.salvagefurnace.procedures.GiveNetheriteScrapA16Procedure;
import net.mcreator.salvagefurnace.procedures.GiveNetheriteScrapA17Procedure;
import net.mcreator.salvagefurnace.procedures.GiveNetheriteScrapA18Procedure;
import net.mcreator.salvagefurnace.world.inventory.GuiNetheriteSalvageStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GuiNetheriteSalvageStorageSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuiNetheriteSalvageStorageSlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"salvage_furnace", (String)"gui_netherite_salvage_storage_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GuiNetheriteSalvageStorageSlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new GuiNetheriteSalvageStorageSlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GuiNetheriteSalvageStorageSlotMessage> type() {
        return TYPE;
    }

    public static void handleData(GuiNetheriteSalvageStorageSlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GuiNetheriteSalvageStorageSlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GuiNetheriteSalvageStorageMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 15 && changeType == 1) {
            GiveNetheriteScrapA15Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 16 && changeType == 1) {
            GiveNetheriteScrapA16Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 17 && changeType == 1) {
            GiveNetheriteScrapA17Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 18 && changeType == 1) {
            GiveNetheriteScrapA18Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SalvageFurnaceMod.addNetworkMessage(TYPE, STREAM_CODEC, GuiNetheriteSalvageStorageSlotMessage::handleData);
    }
}

