/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.network;

import java.util.HashMap;
import net.mcreator.salvagefurnace.SalvageFurnaceMod;
import net.mcreator.salvagefurnace.procedures.GiveStoneScrapA15Procedure;
import net.mcreator.salvagefurnace.procedures.GiveStoneScrapA16Procedure;
import net.mcreator.salvagefurnace.procedures.GiveStoneScrapA17Procedure;
import net.mcreator.salvagefurnace.procedures.GiveStoneScrapA18Procedure;
import net.mcreator.salvagefurnace.world.inventory.GuiStoneSalvageStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GuiStoneSalvageStorageSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuiStoneSalvageStorageSlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"salvage_furnace", (String)"gui_stone_salvage_storage_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GuiStoneSalvageStorageSlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new GuiStoneSalvageStorageSlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GuiStoneSalvageStorageSlotMessage> type() {
        return TYPE;
    }

    public static void handleData(GuiStoneSalvageStorageSlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GuiStoneSalvageStorageSlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GuiStoneSalvageStorageMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 15 && changeType == 1) {
            GiveStoneScrapA15Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 16 && changeType == 1) {
            GiveStoneScrapA16Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 17 && changeType == 1) {
            GiveStoneScrapA17Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 18 && changeType == 1) {
            GiveStoneScrapA18Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SalvageFurnaceMod.addNetworkMessage(TYPE, STREAM_CODEC, GuiStoneSalvageStorageSlotMessage::handleData);
    }
}

