/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.salvagefurnace.SalvageFurnaceMod;
import net.mcreator.salvagefurnace.procedures.GiveGoldScrapA15Procedure;
import net.mcreator.salvagefurnace.procedures.GiveGoldScrapA16Procedure;
import net.mcreator.salvagefurnace.procedures.GiveGoldScrapA17Procedure;
import net.mcreator.salvagefurnace.procedures.GiveGoldScrapA18Procedure;
import net.mcreator.salvagefurnace.world.inventory.GuiGoldSalvageStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuiGoldSalvageStorageSlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public GuiGoldSalvageStorageSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public GuiGoldSalvageStorageSlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(GuiGoldSalvageStorageSlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(GuiGoldSalvageStorageSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GuiGoldSalvageStorageSlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = GuiGoldSalvageStorageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 15 && changeType == 1) {
            GiveGoldScrapA15Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 16 && changeType == 1) {
            GiveGoldScrapA16Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 17 && changeType == 1) {
            GiveGoldScrapA17Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 18 && changeType == 1) {
            GiveGoldScrapA18Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SalvageFurnaceMod.addNetworkMessage(GuiGoldSalvageStorageSlotMessage.class, GuiGoldSalvageStorageSlotMessage::buffer, GuiGoldSalvageStorageSlotMessage::new, GuiGoldSalvageStorageSlotMessage::handler);
    }
}

