/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.item;

import com.google.common.collect.Iterables;
import net.mcreator.salvagefurnace.init.SalvageFurnaceModItems;
import net.mcreator.salvagefurnace.procedures.PCheckDiamondArmorSetProcedure;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class EnchantedDiamondArmorItem
extends ArmorItem {
    public EnchantedDiamondArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 33;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{3, 6, 8, 3})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 20;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SalvageFurnaceModItems.ITEM_ENCHANTED_DIAMOND.get())});
            }

            public String getName() {
                return "enchanted_diamond_armor";
            }

            public float getToughness() {
                return 2.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends EnchantedDiamondArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "salvage_furnace:textures/models/armor/enchanteddiamond__layer_1.png";
        }
    }

    public static class Leggings
    extends EnchantedDiamondArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "salvage_furnace:textures/models/armor/enchanteddiamond__layer_2.png";
        }
    }

    public static class Chestplate
    extends EnchantedDiamondArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "salvage_furnace:textures/models/armor/enchanteddiamond__layer_1.png";
        }
    }

    public static class Helmet
    extends EnchantedDiamondArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "salvage_furnace:textures/models/armor/enchanteddiamond__layer_1.png";
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                PCheckDiamondArmorSetProcedure.execute(entity);
            }
        }
    }
}

