/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.network;

import java.util.HashMap;
import net.mcreator.salvagefurnace.SalvageFurnaceMod;
import net.mcreator.salvagefurnace.procedures.GiveStoneScrapAdvancementProcedure;
import net.mcreator.salvagefurnace.world.inventory.GuiStoneSalvageFurnaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record GuiStoneSalvageFurnaceSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("salvage_furnace", "gui_stone_salvage_furnace_slots");

    public GuiStoneSalvageFurnaceSlotMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.changeType);
        buffer.writeInt(this.meta);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(GuiStoneSalvageFurnaceSlotMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> {
                Player entity = (Player)context.player().get();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GuiStoneSalvageFurnaceSlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GuiStoneSalvageFurnaceMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 1 && changeType == 1) {
            GiveStoneScrapAdvancementProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SalvageFurnaceMod.addNetworkMessage(ID, GuiStoneSalvageFurnaceSlotMessage::new, GuiStoneSalvageFurnaceSlotMessage::handleData);
    }
}

