/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.salvagefurnace.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.salvagefurnace.init.SalvageFurnaceModItems;
import net.mcreator.salvagefurnace.init.SalvageFurnaceModMenus;
import net.mcreator.salvagefurnace.network.GuiDiamondSalvageFurnaceSlotMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiDiamondSalvageFurnaceMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public GuiDiamondSalvageFurnaceMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)SalvageFurnaceModMenus.GUI_DIAMOND_SALVAGE_FURNACE.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(6);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                IItemHandler cap;
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                if (this.boundBlockEntity != null && (cap = (IItemHandler)this.world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 56, 19){
            private final int slot = 0;
            {
                this.slot = 0;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 116, 36){
            private final int slot = 1;
            {
                this.slot = 1;
            }

            public void onTake(Player entity, ItemStack stack) {
                super.onTake(entity, stack);
                GuiDiamondSalvageFurnaceMenu.this.slotChanged(1, 1, 0);
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 56, 55){
            private final int slot = 2;
            {
                this.slot = 2;
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 8, 19){
            private final int slot = 3;
            {
                this.slot = 3;
            }

            public boolean mayPlace(ItemStack stack) {
                return SalvageFurnaceModItems.ITEM_UPGRADE_FUEL.get() == stack.getItem();
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 8, 37){
            private final int slot = 4;
            {
                this.slot = 4;
            }

            public boolean mayPlace(ItemStack stack) {
                return SalvageFurnaceModItems.ITEM_UPGRADE_SPEED.get() == stack.getItem();
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 8, 55){
            private final int slot = 5;
            {
                this.slot = 5;
            }

            public boolean mayPlace(ItemStack stack) {
                return SalvageFurnaceModItems.ITEM_UPGRADE_STORAGE.get() == stack.getItem();
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 6) {
                if (!this.moveItemStackTo(itemstack1, 6, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 6, false)) {
                if (index < 33 ? !this.moveItemStackTo(itemstack1, 33, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 6, 33, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.setByPlayer(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.setByPlayer(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    private void slotChanged(int slotid, int ctype, int meta) {
        if (this.world != null && this.world.isClientSide()) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GuiDiamondSalvageFurnaceSlotMessage(slotid, this.x, this.y, this.z, ctype, meta)});
            GuiDiamondSalvageFurnaceSlotMessage.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

