/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeSession;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.AssertionFailedException;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.jdbc.DatabaseMetaDataUsingInfoSchema;
import com.mysql.cj.jdbc.IterateBlock;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetFactory;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.a.result.ByteArrayRow;
import com.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import com.mysql.cj.result.DefaultColumnDefinition;
import com.mysql.cj.result.Field;
import com.mysql.cj.result.Row;
import com.mysql.cj.util.SearchMode;
import com.mysql.cj.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final Lock LOCK = new ReentrantLock();
    protected static int maxBufferSize = 65535;
    protected static final int MAX_IDENTIFIER_LENGTH = 64;
    private static final String SUPPORTS_FK = "SUPPORTS_FK";
    protected static final byte[] TABLE_AS_BYTES = "TABLE".getBytes();
    protected static final byte[] SYSTEM_TABLE_AS_BYTES = "SYSTEM TABLE".getBytes();
    protected static final byte[] VIEW_AS_BYTES = "VIEW".getBytes();
    private static final String[] MYSQL_KEYWORDS = new String[]{"ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DENSE_RANK", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "EMPTY", "ENCLOSED", "ESCAPED", "EXCEPT", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FIRST_VALUE", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "FUNCTION", "GENERATED", "GET", "GRANT", "GROUP", "GROUPING", "GROUPS", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS", "IS", "ITERATE", "JOIN", "JSON_TABLE", "KEY", "KEYS", "KILL", "LAG", "LAST_VALUE", "LATERAL", "LEAD", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MANUAL", "MASTER_BIND", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MAXVALUE", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NTH_VALUE", "NTILE", "NULL", "NUMERIC", "OF", "ON", "OPTIMIZE", "OPTIMIZER_COSTS", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "OVER", "PARALLEL", "PARTITION", "PERCENT_RANK", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "QUALIFY", "RANGE", "RANK", "READ", "READS", "READ_WRITE", "REAL", "RECURSIVE", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESIGNAL", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "ROW_NUMBER", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SIGNAL", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STORED", "STRAIGHT_JOIN", "SYSTEM", "TABLE", "TABLESAMPLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "VIRTUAL", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"};
    static final List<String> SQL2003_KEYWORDS = Arrays.asList("ABS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASENSITIVE", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOOLEAN", "BOTH", "BY", "CALL", "CALLED", "CARDINALITY", "CASCADED", "CASE", "CAST", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLECT", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONSTRAINT", "CONVERT", "CORR", "CORRESPONDING", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DENSE_RANK", "DEREF", "DESCRIBE", "DETERMINISTIC", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "END", "END-EXEC", "ESCAPE", "EVERY", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXP", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOAT", "FLOOR", "FOR", "FOREIGN", "FREE", "FROM", "FULL", "FUNCTION", "FUSION", "GET", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLD", "HOUR", "IDENTITY", "IN", "INDICATOR", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "JOIN", "LANGUAGE", "LARGE", "LATERAL", "LEADING", "LEFT", "LIKE", "LN", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOWER", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MOD", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NO", "NONE", "NORMALIZE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUT", "OUTER", "OVER", "OVERLAPS", "OVERLAY", "PARAMETER", "PARTITION", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "POSITION", "POWER", "PRECISION", "PREPARE", "PRIMARY", "PROCEDURE", "RANGE", "RANK", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELEASE", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "ROW_NUMBER", "SAVEPOINT", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SELECT", "SENSITIVE", "SESSION_USER", "SET", "SIMILAR", "SMALLINT", "SOME", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQRT", "START", "STATIC", "STDDEV_POP", "STDDEV_SAMP", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UESCAPE", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VAR_POP", "VAR_SAMP", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "YEAR");
    private static volatile String mysqlKeywords = null;
    protected JdbcConnection conn;
    protected NativeSession session;
    protected String database = null;
    protected final String quotedId;
    protected boolean pedantic;
    protected boolean tinyInt1isBit;
    protected boolean transformedBitIsBoolean;
    protected boolean useHostsInPrivileges;
    protected boolean yearIsDateType;
    protected RuntimeProperty<PropertyDefinitions.DatabaseTerm> databaseTerm;
    protected RuntimeProperty<Boolean> nullDatabaseMeansCurrent;
    protected ResultSetFactory resultSetFactory;
    private String metadataEncoding;
    private int metadataCollationIndex;
    private ExceptionInterceptor exceptionInterceptor;

    protected static DatabaseMetaData getInstance(JdbcConnection connToSet, String databaseToSet, boolean checkForInfoSchema, ResultSetFactory resultSetFactory) throws SQLException {
        if (checkForInfoSchema && connToSet.getPropertySet().getBooleanProperty(PropertyKey.useInformationSchema).getValue().booleanValue()) {
            return new DatabaseMetaDataUsingInfoSchema(connToSet, databaseToSet, resultSetFactory);
        }
        return new DatabaseMetaData(connToSet, databaseToSet, resultSetFactory);
    }

    protected DatabaseMetaData(JdbcConnection connToSet, String databaseToSet, ResultSetFactory resultSetFactory) {
        this.conn = connToSet;
        this.session = (NativeSession)connToSet.getSession();
        this.database = databaseToSet;
        this.resultSetFactory = resultSetFactory;
        this.exceptionInterceptor = this.conn.getExceptionInterceptor();
        this.databaseTerm = this.conn.getPropertySet().getEnumProperty(PropertyKey.databaseTerm);
        this.nullDatabaseMeansCurrent = this.conn.getPropertySet().getBooleanProperty(PropertyKey.nullDatabaseMeansCurrent);
        this.pedantic = this.conn.getPropertySet().getBooleanProperty(PropertyKey.pedantic).getValue();
        this.tinyInt1isBit = this.conn.getPropertySet().getBooleanProperty(PropertyKey.tinyInt1isBit).getValue();
        this.transformedBitIsBoolean = this.conn.getPropertySet().getBooleanProperty(PropertyKey.transformedBitIsBoolean).getValue();
        this.useHostsInPrivileges = this.conn.getPropertySet().getBooleanProperty(PropertyKey.useHostsInPrivileges).getValue();
        this.yearIsDateType = this.conn.getPropertySet().getBooleanProperty(PropertyKey.yearIsDateType).getValue();
        this.quotedId = this.session.getIdentifierQuoteString();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void convertToJdbcFunctionList(ResultSet proceduresRs, List<ComparableWrapper<String, Row>> procedureRows, Field[] fields) throws SQLException {
        while (proceduresRs.next()) {
            String procDb = proceduresRs.getString("db");
            String functionName = proceduresRs.getString("name");
            Object rowData = null;
            if (fields != null && fields.length == 9) {
                rowData = new byte[9][];
                rowData[0] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b("def") : this.s2b(procDb);
                rowData[1] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b(procDb) : null;
                rowData[2] = this.s2b(functionName);
                rowData[3] = null;
                rowData[4] = null;
                rowData[5] = null;
                rowData[6] = this.s2b(proceduresRs.getString("comment"));
                rowData[7] = this.s2b(Integer.toString(2));
                rowData[8] = this.s2b(functionName);
            } else {
                rowData = new byte[6][];
                rowData[0] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b("def") : this.s2b(procDb);
                rowData[1] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b(procDb) : null;
                rowData[2] = this.s2b(functionName);
                rowData[3] = this.s2b(proceduresRs.getString("comment"));
                rowData[4] = this.s2b(Integer.toString(1));
                rowData[5] = this.s2b(functionName);
            }
            procedureRows.add(new ComparableWrapper(this, (Comparable)((Object)StringUtils.getFullyQualifiedName(procDb, functionName, this.quotedId, this.pedantic)), (Object)new ByteArrayRow((byte[][])rowData, this.getExceptionInterceptor())));
        }
    }

    protected void convertToJdbcProcedureList(boolean fromSelect, ResultSet proceduresRs, List<ComparableWrapper<String, Row>> procedureRows) throws SQLException {
        while (proceduresRs.next()) {
            String procDb = proceduresRs.getString("db");
            String procedureName = proceduresRs.getString("name");
            byte[][] rowData = new byte[9][];
            rowData[0] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b("def") : this.s2b(procDb);
            rowData[1] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b(procDb) : null;
            rowData[2] = this.s2b(procedureName);
            rowData[3] = null;
            rowData[4] = null;
            rowData[5] = null;
            rowData[6] = this.s2b(proceduresRs.getString("comment"));
            boolean isFunction = fromSelect ? "FUNCTION".equalsIgnoreCase(proceduresRs.getString("type")) : false;
            rowData[7] = this.s2b(isFunction ? Integer.toString(2) : Integer.toString(1));
            rowData[8] = this.s2b(procedureName);
            procedureRows.add(new ComparableWrapper(this, (Comparable)((Object)StringUtils.getFullyQualifiedName(procDb, procedureName, this.quotedId, this.pedantic)), (Object)new ByteArrayRow(rowData, this.getExceptionInterceptor())));
        }
    }

    private Row convertTypeDescriptorToProcedureRow(byte[] procNameAsBytes, byte[] procCatAsBytes, String paramName, boolean isOutParam, boolean isInParam, boolean isReturnParam, TypeDescriptor typeDesc, boolean forGetFunctionColumns, int ordinal) throws SQLException {
        byte[][] row = forGetFunctionColumns ? new byte[17][] : new byte[20][];
        row[0] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b("def") : procCatAsBytes;
        row[1] = (byte[])(this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? procCatAsBytes : null);
        row[2] = procNameAsBytes;
        row[3] = this.s2b(paramName);
        row[4] = this.s2b(String.valueOf(this.getColumnType(isOutParam, isInParam, isReturnParam, forGetFunctionColumns)));
        row[5] = Short.toString((short)(typeDesc.mysqlType == MysqlType.YEAR && !this.yearIsDateType ? 5 : (short)typeDesc.mysqlType.getJdbcType())).getBytes();
        row[6] = this.s2b(typeDesc.mysqlType.getName());
        row[7] = typeDesc.datetimePrecision == null ? this.s2b(typeDesc.columnSize.toString()) : this.s2b(typeDesc.datetimePrecision.toString());
        row[8] = typeDesc.columnSize == null ? null : this.s2b(typeDesc.columnSize.toString());
        row[9] = typeDesc.decimalDigits == null ? null : this.s2b(typeDesc.decimalDigits.toString());
        row[10] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
        switch (typeDesc.nullability) {
            case 0: {
                row[11] = this.s2b(String.valueOf(0));
                break;
            }
            case 1: {
                row[11] = this.s2b(String.valueOf(1));
                break;
            }
            case 2: {
                row[11] = this.s2b(String.valueOf(2));
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.1"), "S1000", this.getExceptionInterceptor());
            }
        }
        row[12] = null;
        if (forGetFunctionColumns) {
            row[13] = typeDesc.charOctetLength == null ? null : this.s2b(typeDesc.charOctetLength.toString());
            row[14] = this.s2b(String.valueOf(ordinal));
            row[15] = this.s2b(typeDesc.isNullable);
            row[16] = procNameAsBytes;
        } else {
            row[13] = null;
            row[14] = null;
            row[15] = null;
            row[16] = typeDesc.charOctetLength == null ? null : this.s2b(typeDesc.charOctetLength.toString());
            row[17] = this.s2b(String.valueOf(ordinal));
            row[18] = this.s2b(typeDesc.isNullable);
            row[19] = procNameAsBytes;
        }
        return new ByteArrayRow(row, this.getExceptionInterceptor());
    }

    protected int getColumnType(boolean isOutParam, boolean isInParam, boolean isReturnParam, boolean forGetFunctionColumns) {
        return DatabaseMetaData.getProcedureOrFunctionColumnType(isOutParam, isInParam, isReturnParam, forGetFunctionColumns);
    }

    protected static int getProcedureOrFunctionColumnType(boolean isOutParam, boolean isInParam, boolean isReturnParam, boolean forGetFunctionColumns) {
        if (isInParam && isOutParam) {
            return forGetFunctionColumns ? 2 : 2;
        }
        if (isInParam) {
            return forGetFunctionColumns ? 1 : 1;
        }
        if (isOutParam) {
            return forGetFunctionColumns ? 3 : 4;
        }
        if (isReturnParam) {
            return forGetFunctionColumns ? 4 : 5;
        }
        return forGetFunctionColumns ? 0 : 0;
    }

    protected ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private List<Row> extractForeignKeyForTable(ArrayList<Row> rows, ResultSet rs, String dbName) throws SQLException {
        byte[][] row = new byte[3][];
        row[0] = rs.getBytes(1);
        row[1] = this.s2b(SUPPORTS_FK);
        String createTableString = rs.getString(2);
        StringTokenizer lineTokenizer = new StringTokenizer(createTableString, "\n");
        StringBuilder comment = new StringBuilder("Key info; ");
        boolean firstTime = true;
        while (lineTokenizer.hasMoreTokens()) {
            int afterFk;
            int indexOfRef;
            String line = lineTokenizer.nextToken().trim();
            String constraintName = null;
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT")) {
                boolean usingBackTicks = true;
                int beginPos = StringUtils.indexOfQuoteDoubleAware(line, this.quotedId, 0);
                if (beginPos == -1) {
                    beginPos = line.indexOf("\"");
                    usingBackTicks = false;
                }
                if (beginPos != -1) {
                    int endPos = -1;
                    endPos = usingBackTicks ? StringUtils.indexOfQuoteDoubleAware(line, this.quotedId, beginPos + 1) : StringUtils.indexOfQuoteDoubleAware(line, "\"", beginPos + 1);
                    if (endPos != -1) {
                        constraintName = line.substring(beginPos + 1, endPos);
                        line = line.substring(endPos + 1, line.length()).trim();
                    }
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            int indexOfFK = line.indexOf("FOREIGN KEY");
            String localColumnName = null;
            String referencedDbName = StringUtils.quoteIdentifier(dbName, this.quotedId, true);
            String referencedTableName = null;
            String referencedColumnName = null;
            if (indexOfFK != -1 && (indexOfRef = StringUtils.indexOfIgnoreCase(afterFk = indexOfFK + "FOREIGN KEY".length(), line, "REFERENCES", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS)) != -1) {
                int indexOfParenOpen = line.indexOf(40, afterFk);
                int indexOfParenClose = StringUtils.indexOfIgnoreCase(indexOfParenOpen, line, ")", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
                localColumnName = line.substring(indexOfParenOpen + 1, indexOfParenClose);
                int afterRef = indexOfRef + "REFERENCES".length();
                int referencedColumnBegin = StringUtils.indexOfIgnoreCase(afterRef, line, "(", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
                if (referencedColumnBegin != -1) {
                    int indexOfDbSep;
                    referencedTableName = line.substring(afterRef, referencedColumnBegin).trim();
                    int referencedColumnEnd = StringUtils.indexOfIgnoreCase(referencedColumnBegin + 1, line, ")", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
                    if (referencedColumnEnd != -1) {
                        referencedColumnName = line.substring(referencedColumnBegin + 1, referencedColumnEnd);
                    }
                    if ((indexOfDbSep = StringUtils.indexOfIgnoreCase(0, referencedTableName, ".", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS)) != -1) {
                        referencedDbName = referencedTableName.substring(0, indexOfDbSep);
                        referencedTableName = referencedTableName.substring(indexOfDbSep + 1);
                    }
                }
            }
            if (firstTime) {
                firstTime = false;
            } else {
                comment.append("; ");
            }
            if (constraintName != null) {
                comment.append(constraintName);
            } else {
                comment.append("not_available");
            }
            comment.append("(");
            comment.append(localColumnName);
            comment.append(") REFER ");
            comment.append(referencedDbName);
            comment.append("/");
            comment.append(referencedTableName);
            comment.append("(");
            comment.append(referencedColumnName);
            comment.append(")");
            int lastParenIndex = line.lastIndexOf(")");
            if (lastParenIndex == line.length() - 1) continue;
            String cascadeOptions = line.substring(lastParenIndex + 1);
            comment.append(cascadeOptions);
        }
        row[2] = this.s2b(comment.toString());
        rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet extractForeignKeyFromCreateTable(String dbName, String tableName) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        ResultSet rs = null;
        Statement stmt = null;
        if (tableName != null) {
            tableList.add(tableName);
        } else {
            try {
                String quotedDbName = dbName;
                if (!this.pedantic) {
                    quotedDbName = StringUtils.quoteIdentifier(dbName, this.quotedId, true);
                }
                ResultSet resultSet = rs = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.getTables(null, quotedDbName, null, new String[]{"TABLE"}) : this.getTables(quotedDbName, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    tableList.add(rs.getString("TABLE_NAME"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        Field[] fields = new Field[]{new Field("", "Name", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, Integer.MAX_VALUE), new Field("", "Type", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "Comment", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, Integer.MAX_VALUE)};
        stmt = this.conn.getMetadataSafeStatement();
        try {
            for (String tableToExtract : tableList) {
                StringBuilder query = new StringBuilder("SHOW CREATE TABLE ");
                query.append(StringUtils.getFullyQualifiedName(dbName, tableToExtract, this.quotedId, true));
                try {
                    rs = stmt.executeQuery(query.toString());
                }
                catch (SQLException e) {
                    String sqlState = e.getSQLState();
                    int errorCode = e.getErrorCode();
                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                    throw e;
                }
                while (rs != null && rs.next()) {
                    this.extractForeignKeyForTable(rows, rs, dbName);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TYPE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "ATTR_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 32), new Field("", "ATTR_TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "ATTR_SIZE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "DECIMAL_DIGITS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "NUM_PREC_RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "NULLABLE ", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "ATTR_DEF", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SQL_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "SQL_DATETIME_SUB", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "CHAR_OCTET_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "ORDINAL_POSITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "IS_NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SCOPE_CATALOG", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SCOPE_SCHEMA", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SCOPE_TABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SOURCE_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 32)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.getDatabase(catalog, schema);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            Field[] fields = new Field[]{new Field("", "SCOPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "COLUMN_SIZE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "BUFFER_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "DECIMAL_DIGITS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 10), new Field("", "PSEUDO_COLUMN", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5)};
            final ArrayList rows = new ArrayList();
            try (final Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet rs = null;
                        try {
                            block22: {
                                StringBuilder query = new StringBuilder("SHOW COLUMNS FROM ");
                                query.append(StringUtils.quoteIdentifier(tableFilter, DatabaseMetaData.this.quotedId, true));
                                query.append(" FROM ");
                                query.append(StringUtils.quoteIdentifier(db, DatabaseMetaData.this.quotedId, true));
                                try {
                                    rs = stmt.executeQuery(query.toString());
                                }
                                catch (SQLException e) {
                                    String sqlState = e.getSQLState();
                                    int errorCode = e.getErrorCode();
                                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) break block22;
                                    throw e;
                                }
                            }
                            while (rs != null && rs.next()) {
                                String keyType = rs.getString("Key");
                                if (keyType == null || !StringUtils.startsWithIgnoreCase(keyType, "PRI")) continue;
                                byte[][] row = new byte[8][];
                                row[0] = Integer.toString(2).getBytes();
                                row[1] = rs.getBytes("Field");
                                String type = rs.getString("Type");
                                int size = stmt.getMaxFieldSize();
                                int decimals = 0;
                                boolean hasLength = false;
                                if (type.indexOf("enum") != -1) {
                                    String temp = type.substring(type.indexOf("("), type.indexOf(")"));
                                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                                    int maxLength = 0;
                                    while (tokenizer.hasMoreTokens()) {
                                        maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                                    }
                                    size = maxLength;
                                    decimals = 0;
                                    type = "enum";
                                } else if (type.indexOf("(") != -1) {
                                    hasLength = true;
                                    if (type.indexOf(",") != -1) {
                                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(",")));
                                        decimals = Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(")")));
                                    } else {
                                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(")")));
                                    }
                                    type = type.substring(0, type.indexOf("("));
                                }
                                MysqlType ft = MysqlType.getByName(type.toUpperCase());
                                row[2] = DatabaseMetaData.this.s2b(String.valueOf(ft == MysqlType.YEAR && !DatabaseMetaData.this.yearIsDateType ? 5 : ft.getJdbcType()));
                                row[3] = DatabaseMetaData.this.s2b(type);
                                row[4] = hasLength ? Integer.toString(size + decimals).getBytes() : Long.toString(ft.getPrecision()).getBytes();
                                row[5] = Integer.toString(maxBufferSize).getBytes();
                                row[6] = Integer.toString(decimals).getBytes();
                                row[7] = Integer.toString(1).getBytes();
                                rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                            }
                        }
                        catch (SQLException sqlEx) {
                            if (!"42S02".equals(sqlEx.getSQLState())) {
                                throw sqlEx;
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                                rs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getProcedureOrFunctionParameterTypes(String dbName, String objectName, ProcedureType procType, String parameterNamePattern, List<Row> resultRows, boolean forGetFunctionColumns) throws SQLException {
        String declaration;
        String storageDefnClosures;
        String storageDefnDelims;
        boolean isProcedureInAnsiMode;
        byte[] procCatAsBytes;
        byte[] procNameAsBytes;
        String parameterDef;
        block36: {
            Statement paramRetrievalStmt = null;
            ResultSet paramRetrievalRs = null;
            parameterDef = null;
            procNameAsBytes = null;
            procCatAsBytes = null;
            isProcedureInAnsiMode = false;
            storageDefnDelims = null;
            storageDefnClosures = null;
            try {
                paramRetrievalStmt = this.conn.getMetadataSafeStatement();
                if (paramRetrievalStmt.getMaxRows() != 0) {
                    paramRetrievalStmt.setMaxRows(0);
                }
                procCatAsBytes = StringUtils.getBytes(dbName, "UTF-8");
                procNameAsBytes = StringUtils.getBytes(objectName, "UTF-8");
                String fieldName = null;
                StringBuilder query = new StringBuilder();
                if (procType == ProcedureType.PROCEDURE) {
                    fieldName = "Create Procedure";
                    query.append("SHOW CREATE PROCEDURE ");
                } else {
                    fieldName = "Create Function";
                    query.append("SHOW CREATE FUNCTION ");
                }
                query.append(StringUtils.quoteIdentifier(dbName, this.quotedId, true));
                query.append('.');
                query.append(StringUtils.quoteIdentifier(objectName, this.quotedId, true));
                paramRetrievalRs = paramRetrievalStmt.executeQuery(query.toString());
                if (!paramRetrievalRs.next()) break block36;
                String procedureDef = paramRetrievalRs.getString(fieldName);
                if (!(this.conn.getPropertySet().getBooleanProperty(PropertyKey.noAccessToProcedureBodies).getValue().booleanValue() || procedureDef != null && procedureDef.length() != 0)) {
                    throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.4"), "S1000", this.getExceptionInterceptor());
                }
                try {
                    String sqlMode = paramRetrievalRs.getString("sql_mode");
                    if (StringUtils.indexOfIgnoreCase(sqlMode, "ANSI") != -1) {
                        isProcedureInAnsiMode = true;
                    }
                }
                catch (SQLException sqlMode) {
                    // empty catch block
                }
                String identifierMarkers = isProcedureInAnsiMode ? "`\"" : "`";
                String identifierAndStringMarkers = "'" + identifierMarkers;
                storageDefnDelims = "(" + identifierMarkers;
                storageDefnClosures = ")" + identifierMarkers;
                if (procedureDef != null && procedureDef.length() != 0) {
                    procedureDef = StringUtils.stripCommentsAndHints(procedureDef, identifierAndStringMarkers, identifierAndStringMarkers, !this.session.getServerSession().isNoBackslashEscapesSet());
                    int openParenIndex = StringUtils.indexOfIgnoreCase(0, procedureDef, "(", this.quotedId, this.quotedId, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__FULL);
                    int endOfParamDeclarationIndex = 0;
                    endOfParamDeclarationIndex = this.endPositionOfParameterDeclaration(openParenIndex, procedureDef, this.quotedId);
                    if (procType == ProcedureType.FUNCTION) {
                        int declarationStart;
                        int returnsIndex = StringUtils.indexOfIgnoreCase(0, procedureDef, " RETURNS ", this.quotedId, this.quotedId, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__FULL);
                        int endReturnsDef = this.findEndOfReturnsClause(procedureDef, returnsIndex);
                        for (declarationStart = returnsIndex + "RETURNS ".length(); declarationStart < procedureDef.length() && Character.isWhitespace(procedureDef.charAt(declarationStart)); ++declarationStart) {
                        }
                        String returnsDefn = procedureDef.substring(declarationStart, endReturnsDef).trim();
                        TypeDescriptor returnDescriptor = new TypeDescriptor(returnsDefn, "YES");
                        resultRows.add(this.convertTypeDescriptorToProcedureRow(procNameAsBytes, procCatAsBytes, "", false, false, true, returnDescriptor, forGetFunctionColumns, 0));
                    }
                    if (openParenIndex == -1 || endOfParamDeclarationIndex == -1) {
                        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
                    }
                    parameterDef = procedureDef.substring(openParenIndex + 1, endOfParamDeclarationIndex);
                }
            }
            finally {
                SQLException sqlExRethrow = null;
                if (paramRetrievalRs != null) {
                    try {
                        paramRetrievalRs.close();
                    }
                    catch (SQLException sqlEx) {
                        sqlExRethrow = sqlEx;
                    }
                    paramRetrievalRs = null;
                }
                if (paramRetrievalStmt != null) {
                    try {
                        paramRetrievalStmt.close();
                    }
                    catch (SQLException sqlEx) {
                        sqlExRethrow = sqlEx;
                    }
                    paramRetrievalStmt = null;
                }
                if (sqlExRethrow != null) {
                    throw sqlExRethrow;
                }
            }
        }
        if (parameterDef == null) return;
        int ordinal = 1;
        List<String> parseList = StringUtils.split(parameterDef, ",", storageDefnDelims, storageDefnClosures, true);
        int parseListLen = parseList.size();
        for (int i = 0; i < parseListLen && (declaration = parseList.get(i)).trim().length() != 0; ++i) {
            String paramNameFilter;
            declaration = declaration.replaceAll("[\\t\\n\\x0B\\f\\r]", " ");
            StringTokenizer declarationTok = new StringTokenizer(declaration, " \t");
            String paramName = null;
            boolean isOutParam = false;
            boolean isInParam = false;
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.8"), "S1000", this.getExceptionInterceptor());
            String possibleParamName = declarationTok.nextToken();
            if (possibleParamName.equalsIgnoreCase("OUT")) {
                isOutParam = true;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("INOUT")) {
                isOutParam = true;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("IN")) {
                isOutParam = false;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else {
                isOutParam = false;
                isInParam = true;
                paramName = possibleParamName;
            }
            TypeDescriptor typeDesc = null;
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.7"), "S1000", this.getExceptionInterceptor());
            StringBuilder typeInfo = new StringBuilder(declarationTok.nextToken());
            while (declarationTok.hasMoreTokens()) {
                typeInfo.append(" ");
                typeInfo.append(declarationTok.nextToken());
            }
            typeDesc = new TypeDescriptor(typeInfo.toString(), "YES");
            if (paramName.startsWith("`") && paramName.endsWith("`")) {
                paramName = StringUtils.unQuoteIdentifier(paramName, "`");
            } else if (isProcedureInAnsiMode && paramName.startsWith("\"") && paramName.endsWith("\"")) {
                paramName = StringUtils.unQuoteIdentifier(paramName, "\"");
            }
            String string = paramNameFilter = this.pedantic ? parameterNamePattern : StringUtils.unQuoteIdentifier(parameterNamePattern, this.quotedId);
            if (paramNameFilter != null && !StringUtils.wildCompareIgnoreCase(paramName, paramNameFilter)) continue;
            Row row = this.convertTypeDescriptorToProcedureRow(procNameAsBytes, procCatAsBytes, paramName, isOutParam, isInParam, false, typeDesc, forGetFunctionColumns, ordinal++);
            resultRows.add(row);
        }
    }

    private int endPositionOfParameterDeclaration(int beginIndex, String procedureDef, String quoteChar) throws SQLException {
        int currentPos = beginIndex + 1;
        int parenDepth = 1;
        while (parenDepth > 0 && currentPos < procedureDef.length()) {
            int closedParenIndex = StringUtils.indexOfIgnoreCase(currentPos, procedureDef, ")", quoteChar, quoteChar, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (closedParenIndex != -1) {
                int nextOpenParenIndex = StringUtils.indexOfIgnoreCase(currentPos, procedureDef, "(", quoteChar, quoteChar, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
                if (nextOpenParenIndex != -1 && nextOpenParenIndex < closedParenIndex) {
                    ++parenDepth;
                    currentPos = closedParenIndex + 1;
                    continue;
                }
                --parenDepth;
                currentPos = closedParenIndex;
                continue;
            }
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
        }
        return currentPos;
    }

    private int findEndOfReturnsClause(String procedureDefn, int positionOfReturnKeyword) throws SQLException {
        int i;
        String openingMarkers = this.quotedId + "(";
        String closingMarkers = this.quotedId + ")";
        String[] tokens = new String[]{"LANGUAGE", "NOT", "DETERMINISTIC", "CONTAINS", "NO", "READ", "MODIFIES", "SQL", "COMMENT", "BEGIN", "RETURN"};
        int startLookingAt = positionOfReturnKeyword + "RETURNS".length() + 1;
        int endOfReturn = -1;
        for (i = 0; i < tokens.length; ++i) {
            int nextEndOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, tokens[i], openingMarkers, closingMarkers, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (nextEndOfReturn == -1 || endOfReturn != -1 && nextEndOfReturn >= endOfReturn) continue;
            endOfReturn = nextEndOfReturn;
        }
        if (endOfReturn != -1) {
            return endOfReturn;
        }
        endOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, ":", openingMarkers, closingMarkers, this.session.getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (endOfReturn != -1) {
            for (i = endOfReturn; i > 0; --i) {
                if (!Character.isWhitespace(procedureDefn.charAt(i))) continue;
                return i;
            }
        }
        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
    }

    private int getCascadeDeleteOption(String cascadeOptions) {
        int onDeletePos = cascadeOptions.indexOf("ON DELETE");
        if (onDeletePos != -1) {
            String deleteOptions = cascadeOptions.substring(onDeletePos, cascadeOptions.length());
            if (deleteOptions.startsWith("ON DELETE CASCADE")) {
                return 0;
            }
            if (deleteOptions.startsWith("ON DELETE SET NULL")) {
                return 2;
            }
        }
        return 1;
    }

    private int getCascadeUpdateOption(String cascadeOptions) {
        int onUpdatePos = cascadeOptions.indexOf("ON UPDATE");
        if (onUpdatePos != -1) {
            String updateOptions = cascadeOptions.substring(onUpdatePos, cascadeOptions.length());
            if (updateOptions.startsWith("ON UPDATE CASCADE")) {
                return 0;
            }
            if (updateOptions.startsWith("ON UPDATE SET NULL")) {
                return 2;
            }
        }
        return 1;
    }

    protected IteratorWithCleanup<String> getDatabaseIterator(String dbSpec) throws SQLException {
        if (dbSpec == null) {
            return this.nullDatabaseMeansCurrent.getValue() != false ? new SingleStringIterator(this.storesLowerCaseIdentifiers() ? this.database.toLowerCase() : this.database) : new StringListIterator(this.getDatabases());
        }
        if (this.storesLowerCaseIdentifiers()) {
            dbSpec = dbSpec.toLowerCase();
        }
        return new SingleStringIterator(this.pedantic ? dbSpec : StringUtils.unQuoteIdentifier(dbSpec, this.quotedId));
    }

    protected IteratorWithCleanup<String> getSchemaPatternIterator(String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            return this.nullDatabaseMeansCurrent.getValue() != false ? new SingleStringIterator(this.database) : new StringListIterator(this.getDatabases());
        }
        return new StringListIterator(this.getDatabases(schemaPattern));
    }

    protected List<String> getDatabases() throws SQLException {
        return this.getDatabases(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getDatabases(String dbPattern) throws SQLException {
        String dbFilter = this.pedantic ? dbPattern : StringUtils.unQuoteIdentifier(dbPattern, this.quotedId);
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder("SHOW DATABASES");
            if (dbFilter != null) {
                query.append(" LIKE ?");
            }
            pStmt = this.prepareMetaDataSafeStatement(query.toString());
            if (dbFilter != null) {
                pStmt.setString(1, dbFilter);
            }
            rs = pStmt.executeQuery();
            int dbCount = 0;
            if (rs.last()) {
                dbCount = rs.getRow();
                rs.beforeFirst();
            }
            ArrayList<String> resultsAsList = new ArrayList<String>(dbCount);
            while (rs.next()) {
                resultsAsList.add(rs.getString(1));
            }
            Collections.sort(resultsAsList);
            ArrayList<String> arrayList = resultsAsList;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    AssertionFailedException.shouldNotHappen(e);
                }
                rs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException e) {
                    AssertionFailedException.shouldNotHappen(e);
                }
                pStmt = null;
            }
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            List<Object> resultsAsList = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? new ArrayList() : this.getDatabases();
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0)};
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>(resultsAsList.size());
            for (String string : resultsAsList) {
                byte[][] row = new byte[][]{this.s2b(string)};
                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return ".";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? "CATALOG" : "database";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected String getDatabase(String catalog, String schema) {
        if (this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA) {
            return schema == null && this.nullDatabaseMeansCurrent.getValue() != false ? this.database : schema;
        }
        return catalog == null && this.nullDatabaseMeansCurrent.getValue() != false ? this.database : catalog;
    }

    protected Field[] getColumnPrivilegesFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 1), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTOR", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 77), new Field("", "GRANTEE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 77), new Field("", "PRIVILEGE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "IS_GRANTABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 3)};
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv");
            query.append(" FROM mysql.columns_priv c, mysql.tables_priv t");
            query.append(" WHERE c.host = t.host AND c.db = t.db AND c.table_name = t.table_name");
            if (dbFilter != null) {
                query.append(" AND c.db = ?");
            }
            query.append(" AND c.table_name = ?");
            if (columnNameFilter != null) {
                query.append(" AND c.column_name LIKE ?");
            }
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try {
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, this.storesLowerCaseIdentifiers() ? dbFilter.toLowerCase() : dbFilter);
                }
                pStmt.setString(nextId++, this.storesLowerCaseIdentifiers() ? tableFilter.toLowerCase() : tableFilter);
                if (columnNameFilter != null) {
                    pStmt.setString(nextId, columnNameFilter);
                }
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String host = rs.getString(1);
                    String db = rs.getString(2);
                    String grantor = rs.getString(3);
                    String user = rs.getString(4);
                    if (user == null || user.length() == 0) {
                        user = "%";
                    }
                    StringBuilder fullUser = new StringBuilder(user);
                    if (host != null && this.useHostsInPrivileges) {
                        fullUser.append("@");
                        fullUser.append(host);
                    }
                    String tableName = rs.getString(5);
                    String columnName = rs.getString(6);
                    String allPrivileges = rs.getString(7);
                    if (allPrivileges == null) continue;
                    allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                    StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                    while (st.hasMoreTokens()) {
                        String privilege = st.nextToken().trim();
                        byte[][] row = new byte[][]{dbMapsToSchema ? this.s2b("def") : this.s2b(db), dbMapsToSchema ? this.s2b(db) : null, this.s2b(tableName), this.s2b(columnName), grantor != null ? this.s2b(grantor) : null, this.s2b(fullUser.toString()), this.s2b(privilege), null};
                        rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                    rs = null;
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (Exception exception) {}
                    pStmt = null;
                }
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.getColumnPrivilegesFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            Field[] fields = this.createColumnsFields();
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            try (Statement stmt = this.conn.getMetadataSafeStatement();){
                TreeMap<String, ArrayList<String>> tableNamesPerDb = new TreeMap<String, ArrayList<String>>();
                ResultSet tables = null;
                try {
                    tables = this.getTables(catalog, schemaPattern, tableNamePattern, null);
                    while (tables.next()) {
                        String db = tables.getString(dbMapsToSchema ? "TABLE_SCHEM" : "TABLE_CAT");
                        ArrayList<String> tableNames = (ArrayList<String>)tableNamesPerDb.get(db);
                        if (tableNames == null) {
                            tableNames = new ArrayList<String>();
                        }
                        tableNames.add(tables.getString("TABLE_NAME"));
                        tableNamesPerDb.put(db, tableNames);
                    }
                }
                finally {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Exception sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        tables = null;
                    }
                }
                for (String dbName : tableNamesPerDb.keySet()) {
                    for (String tableName : (List)tableNamesPerDb.get(dbName)) {
                        ResultSet rs = null;
                        try {
                            StringBuilder query = new StringBuilder("SHOW FULL COLUMNS FROM ");
                            query.append(StringUtils.quoteIdentifier(tableName, this.quotedId, true));
                            query.append(" FROM ");
                            query.append(StringUtils.quoteIdentifier(dbName, this.quotedId, true));
                            boolean fixUpOrdinalsRequired = false;
                            HashMap<String, Integer> ordinalFixUpMap = null;
                            if (columnNameFilter != null && !columnNameFilter.equals("%")) {
                                fixUpOrdinalsRequired = true;
                                ordinalFixUpMap = new HashMap<String, Integer>();
                                rs = stmt.executeQuery(query.toString());
                                int ordinalPos = 1;
                                while (rs.next()) {
                                    String columnName = rs.getString("Field");
                                    ordinalFixUpMap.put(columnName, ordinalPos++);
                                }
                                rs.close();
                            }
                            if (columnNameFilter != null) {
                                query.append(" LIKE ");
                                query.append(StringUtils.quoteIdentifier(columnNameFilter, "'", true));
                            }
                            rs = stmt.executeQuery(query.toString());
                            int ordPos = 1;
                            while (rs.next()) {
                                TypeDescriptor typeDesc = new TypeDescriptor(rs.getString("Type"), rs.getString("Null"));
                                byte[][] row = new byte[24][];
                                row[0] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b("def") : this.s2b(dbName);
                                row[1] = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.s2b(dbName) : null;
                                row[2] = this.s2b(tableName);
                                row[3] = rs.getBytes("Field");
                                row[4] = Short.toString((short)(typeDesc.mysqlType == MysqlType.YEAR && !this.yearIsDateType ? 5 : (short)typeDesc.mysqlType.getJdbcType())).getBytes();
                                row[5] = this.s2b(typeDesc.mysqlType.getName());
                                if (typeDesc.columnSize == null) {
                                    row[6] = null;
                                } else {
                                    String collation = rs.getString("Collation");
                                    int mbminlen = 1;
                                    if (collation != null) {
                                        if (collation.indexOf("ucs2") > -1 || collation.indexOf("utf16") > -1) {
                                            mbminlen = 2;
                                        } else if (collation.indexOf("utf32") > -1) {
                                            mbminlen = 4;
                                        }
                                    }
                                    row[6] = mbminlen == 1 ? this.s2b(typeDesc.columnSize.toString()) : this.s2b(Integer.valueOf(typeDesc.columnSize / mbminlen).toString());
                                }
                                row[7] = this.s2b(Integer.toString(typeDesc.bufferLength));
                                row[8] = typeDesc.decimalDigits == null ? null : this.s2b(typeDesc.decimalDigits.toString());
                                row[9] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
                                row[10] = this.s2b(Integer.toString(typeDesc.nullability));
                                try {
                                    row[11] = rs.getBytes("Comment");
                                }
                                catch (Exception e) {
                                    row[11] = new byte[0];
                                }
                                row[12] = rs.getBytes("Default");
                                row[13] = new byte[]{48};
                                row[14] = new byte[]{48};
                                row[15] = (byte[])(StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "CHAR") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "BLOB") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "TEXT") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "ENUM") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "SET") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "BINARY") != -1 ? row[6] : null);
                                if (!fixUpOrdinalsRequired) {
                                    row[16] = Integer.toString(ordPos++).getBytes();
                                } else {
                                    String origColName = rs.getString("Field");
                                    Integer realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                                    if (realOrdinal != null) {
                                        row[16] = realOrdinal.toString().getBytes();
                                    } else {
                                        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.10"), "S1000", this.getExceptionInterceptor());
                                    }
                                }
                                row[17] = this.s2b(typeDesc.isNullable);
                                row[18] = null;
                                row[19] = null;
                                row[20] = null;
                                row[21] = null;
                                row[22] = this.s2b("");
                                String extra = rs.getString("Extra");
                                if (extra != null) {
                                    row[22] = this.s2b(StringUtils.indexOfIgnoreCase(extra, "auto_increment") != -1 ? "YES" : "NO");
                                    row[23] = this.s2b(StringUtils.indexOfIgnoreCase(extra, "generated") != -1 ? "YES" : "NO");
                                }
                                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                            }
                        }
                        finally {
                            if (rs == null) continue;
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {}
                            rs = null;
                        }
                    }
                }
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createColumnsFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 5), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 16), new Field("", "COLUMN_SIZE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "DECIMAL_DIGITS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "NUM_PREC_RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "COLUMN_DEF", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "SQL_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "SQL_DATETIME_SUB", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "CHAR_OCTET_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "IS_NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 3), new Field("", "SCOPE_CATALOG", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "SCOPE_SCHEMA", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "SCOPE_TABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "SOURCE_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 10), new Field("", "IS_AUTOINCREMENT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 3), new Field("", "IS_GENERATEDCOLUMN", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 3)};
        return fields;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.conn;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null || foreignTable == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            final boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String parentDbFromTerm = this.getDatabase(parentCatalog, parentSchema);
            final String parentDbFilter = this.pedantic ? parentDbFromTerm : StringUtils.unQuoteIdentifier(parentDbFromTerm, this.quotedId);
            final String parentTableFilter = this.pedantic ? parentTable : StringUtils.unQuoteIdentifier(parentTable, this.quotedId);
            String foreignDbFilter = this.getDatabase(foreignCatalog, foreignSchema);
            final String foreignTableFilter = this.pedantic ? foreignTable : StringUtils.unQuoteIdentifier(foreignTable, this.quotedId);
            Field[] fields = this.createFkMetadataFields();
            final ArrayList rows = new ArrayList();
            try (Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(foreignDbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet fkRs = null;
                        try {
                            fkRs = DatabaseMetaData.this.extractForeignKeyFromCreateTable(db, DatabaseMetaData.this.normalizeCase(foreignTableFilter));
                            while (fkRs.next()) {
                                String comment;
                                String tableType = fkRs.getString("Type");
                                if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK) || (comment = fkRs.getString("Comment").trim()) == null) continue;
                                StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                if (commentTokens.hasMoreTokens()) {
                                    commentTokens.nextToken();
                                }
                                while (commentTokens.hasMoreTokens()) {
                                    String keys = commentTokens.nextToken();
                                    ReferencingAndReferencedColumns parsedInfo = DatabaseMetaData.this.parseTableStatusIntoReferencingAndReferencedColumns(keys);
                                    String foreignTableName = fkRs.getString("Name");
                                    if (!foreignTableName.contentEquals(DatabaseMetaData.this.normalizeCase(foreignTableFilter)) || !parsedInfo.referencedTable.contentEquals(DatabaseMetaData.this.normalizeCase(parentTableFilter)) || parentDbFilter != null && !parsedInfo.referencedDatabase.contentEquals(DatabaseMetaData.this.normalizeCase(parentDbFilter))) continue;
                                    int keySeq = 1;
                                    Iterator<String> referencingColumns = parsedInfo.referencingColumnsList.iterator();
                                    Iterator<String> referencedColumns = parsedInfo.referencedColumnsList.iterator();
                                    while (referencingColumns.hasNext()) {
                                        byte[][] row = new byte[14][];
                                        row[0] = dbMapsToSchema ? DatabaseMetaData.this.s2b("def") : DatabaseMetaData.this.s2b(parsedInfo.referencedDatabase);
                                        row[1] = dbMapsToSchema ? DatabaseMetaData.this.s2b(parsedInfo.referencedDatabase) : null;
                                        row[2] = DatabaseMetaData.this.s2b(parsedInfo.referencedTable);
                                        String referencedColumn = StringUtils.unQuoteIdentifier(referencedColumns.next(), DatabaseMetaData.this.quotedId);
                                        row[3] = DatabaseMetaData.this.s2b(referencedColumn);
                                        row[4] = dbMapsToSchema ? DatabaseMetaData.this.s2b("def") : DatabaseMetaData.this.s2b(db);
                                        row[5] = dbMapsToSchema ? DatabaseMetaData.this.s2b(db) : null;
                                        row[6] = DatabaseMetaData.this.s2b(foreignTableName);
                                        String referencingColumn = StringUtils.unQuoteIdentifier(referencingColumns.next(), DatabaseMetaData.this.quotedId);
                                        row[7] = DatabaseMetaData.this.s2b(referencingColumn);
                                        row[8] = Integer.toString(keySeq).getBytes();
                                        int[] actions = DatabaseMetaData.this.getForeignKeyActions(keys);
                                        row[9] = Integer.toString(actions[1]).getBytes();
                                        row[10] = Integer.toString(actions[0]).getBytes();
                                        row[11] = DatabaseMetaData.this.s2b(parsedInfo.constraintName);
                                        row[12] = null;
                                        row[13] = Integer.toString(7).getBytes();
                                        rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                        ++keySeq;
                                    }
                                }
                            }
                        }
                        finally {
                            if (fkRs != null) {
                                try {
                                    fkRs.close();
                                }
                                catch (Exception sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkRs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createFkMetadataFields() {
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "PKTABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "PKTABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "PKCOLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "FKTABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "FKTABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "FKTABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "FKCOLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "KEY_SEQ", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 2), new Field("", "UPDATE_RULE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 2), new Field("", "DELETE_RULE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 2), new Field("", "FK_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "PK_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "DEFERRABILITY", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 2)};
        return fields;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.conn.getServerVersion().getMajor();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.conn.getServerVersion().getMinor();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return "MySQL";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.conn.getServerVersion().toString();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return 4;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    @Override
    public int getDriverMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return "MySQL Connector/J";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return "mysql-connector-j-9.2.0 (Revision: a3909bfeb62d5a517ab444bb88ba7ecf26100297)";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.getDatabase(catalog, schema);
            final String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            Field[] fields = this.createFkMetadataFields();
            final ArrayList rows = new ArrayList();
            try (Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>((IteratorWithCleanup)new StringListIterator(this.getDatabases())){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet fkRs = null;
                        try {
                            fkRs = DatabaseMetaData.this.extractForeignKeyFromCreateTable(db, null);
                            while (fkRs.next()) {
                                String comment;
                                String tableType = fkRs.getString("Type");
                                if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK) || (comment = fkRs.getString("Comment").trim()) == null) continue;
                                StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                if (commentTokens.hasMoreTokens()) {
                                    commentTokens.nextToken();
                                }
                                while (commentTokens.hasMoreTokens()) {
                                    String keys = commentTokens.nextToken();
                                    DatabaseMetaData.this.populateKeyResults(DatabaseMetaData.this.normalizeCase(dbFilter), DatabaseMetaData.this.normalizeCase(tableFilter), db, fkRs.getString("Name"), keys, true, rows);
                                }
                            }
                        }
                        finally {
                            if (fkRs != null) {
                                try {
                                    fkRs.close();
                                }
                                catch (SQLException sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkRs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return "$";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this.session.getIdentifierQuoteString();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.getDatabase(catalog, schema);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            Field[] fields = this.createFkMetadataFields();
            final ArrayList rows = new ArrayList();
            try (Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet fkRs = null;
                        try {
                            fkRs = DatabaseMetaData.this.extractForeignKeyFromCreateTable(db, DatabaseMetaData.this.normalizeCase(tableFilter));
                            while (fkRs.next()) {
                                String comment;
                                String tableType = fkRs.getString("Type");
                                if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK) || (comment = fkRs.getString("Comment").trim()) == null) continue;
                                StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                if (commentTokens.hasMoreTokens()) {
                                    commentTokens.nextToken();
                                }
                                while (commentTokens.hasMoreTokens()) {
                                    String keys = commentTokens.nextToken();
                                    DatabaseMetaData.this.populateKeyResults(null, null, db, fkRs.getString("NAME"), keys, false, rows);
                                }
                            }
                        }
                        finally {
                            if (fkRs != null) {
                                try {
                                    fkRs.close();
                                }
                                catch (SQLException sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkRs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, final boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            final boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schema);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            Field[] fields = this.createIndexInfoFields();
            final ArrayList rows = new ArrayList();
            try (final Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet rs = null;
                        try {
                            block12: {
                                StringBuilder query = new StringBuilder("SHOW INDEX FROM ");
                                query.append(StringUtils.quoteIdentifier(tableFilter, DatabaseMetaData.this.quotedId, DatabaseMetaData.this.pedantic));
                                query.append(" FROM ");
                                query.append(StringUtils.quoteIdentifier(db, DatabaseMetaData.this.quotedId, true));
                                try {
                                    rs = stmt.executeQuery(query.toString());
                                }
                                catch (SQLException e) {
                                    String sqlState = e.getSQLState();
                                    int errorCode = e.getErrorCode();
                                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) break block12;
                                    throw e;
                                }
                            }
                            TreeMap<IndexMetaDataKey, ByteArrayRow> sortedRows = new TreeMap<IndexMetaDataKey, ByteArrayRow>();
                            while (rs != null && rs.next()) {
                                byte[][] row = new byte[14][];
                                row[0] = dbMapsToSchema ? DatabaseMetaData.this.s2b("def") : DatabaseMetaData.this.s2b(db);
                                row[1] = dbMapsToSchema ? DatabaseMetaData.this.s2b(db) : null;
                                row[2] = rs.getBytes("Table");
                                boolean indexIsUnique = rs.getInt("Non_unique") == 0;
                                row[3] = !indexIsUnique ? DatabaseMetaData.this.s2b("true") : DatabaseMetaData.this.s2b("false");
                                row[4] = null;
                                row[5] = rs.getBytes("Key_name");
                                short indexType = 3;
                                row[6] = Integer.toString(indexType).getBytes();
                                row[7] = rs.getBytes("Seq_in_index");
                                row[8] = rs.getBytes("Column_name");
                                row[9] = rs.getBytes("Collation");
                                long cardinality = rs.getLong("Cardinality");
                                row[10] = DatabaseMetaData.this.s2b(String.valueOf(cardinality));
                                row[11] = DatabaseMetaData.this.s2b("0");
                                row[12] = null;
                                IndexMetaDataKey indexInfoKey = new IndexMetaDataKey(!indexIsUnique, indexType, rs.getString("Key_name").toLowerCase(), rs.getShort("Seq_in_index"));
                                if (unique) {
                                    if (!indexIsUnique) continue;
                                    sortedRows.put(indexInfoKey, new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                    continue;
                                }
                                sortedRows.put(indexInfoKey, new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                            }
                            rows.addAll(sortedRows.values());
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                                rs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createIndexInfoFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "NON_UNIQUE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BOOLEAN, 4), new Field("", "INDEX_QUALIFIER", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 1), new Field("", "INDEX_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 32), new Field("", "ORDINAL_POSITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "ASC_OR_DESC", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 1), new Field("", "CARDINALITY", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BIGINT, 20), new Field("", "PAGES", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BIGINT, 20), new Field("", "FILTER_CONDITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32)};
        return fields;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return 4;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return 2;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return 0xFFFFF8;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return 32;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return 0xFFFFF8;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return 64;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return 64;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return 16;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return 64;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return 256;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return 512;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return 0;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return 64;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return 256;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return 0;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return 0x7FFFFFF7;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return 0;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return maxBufferSize - 4;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return 0;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return 64;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return 256;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return 16;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] getPrimaryKeysFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "KEY_SEQ", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "PK_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32)};
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            final boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schema);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            final ArrayList rows = new ArrayList();
            try (final Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet rs = null;
                        try {
                            block12: {
                                StringBuilder query = new StringBuilder("SHOW KEYS FROM ");
                                query.append(StringUtils.quoteIdentifier(tableFilter, DatabaseMetaData.this.quotedId, true));
                                query.append(" FROM ");
                                query.append(StringUtils.quoteIdentifier(db, DatabaseMetaData.this.quotedId, true));
                                try {
                                    rs = stmt.executeQuery(query.toString());
                                }
                                catch (SQLException e) {
                                    String sqlState = e.getSQLState();
                                    int errorCode = e.getErrorCode();
                                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) break block12;
                                    throw e;
                                }
                            }
                            TreeMap<String, byte[][]> sortMap = new TreeMap<String, byte[][]>(String.CASE_INSENSITIVE_ORDER);
                            while (rs != null && rs.next()) {
                                String keyType = rs.getString("Key_name");
                                if (keyType == null || !keyType.equalsIgnoreCase("PRIMARY") && !keyType.equalsIgnoreCase("PRI")) continue;
                                byte[][] row = new byte[6][];
                                row[0] = dbMapsToSchema ? DatabaseMetaData.this.s2b("def") : DatabaseMetaData.this.s2b(db);
                                row[1] = dbMapsToSchema ? DatabaseMetaData.this.s2b(db) : null;
                                row[2] = DatabaseMetaData.this.s2b(rs.getString("Table"));
                                String columnName = rs.getString("Column_name");
                                row[3] = DatabaseMetaData.this.s2b(columnName);
                                row[4] = DatabaseMetaData.this.s2b(rs.getString("Seq_in_index"));
                                row[5] = DatabaseMetaData.this.s2b(keyType);
                                sortMap.put(columnName, row);
                            }
                            for (byte[][] row : sortMap.values()) {
                                rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                                rs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.getPrimaryKeysFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            return this.getProcedureOrFunctionColumns(this.createProcedureColumnsFields(), catalog, schemaPattern, procedureNamePattern, columnNamePattern, true, this.conn.getPropertySet().getBooleanProperty(PropertyKey.getProceduresReturnsFunctions).getValue());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createProcedureColumnsFields() {
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "PROCEDURE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "PROCEDURE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "COLUMN_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "PRECISION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "SCALE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 12), new Field("", "RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "COLUMN_DEF", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "SQL_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "SQL_DATETIME_SUB", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "CHAR_OCTET_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "ORDINAL_POSITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "IS_NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512), new Field("", "SPECIFIC_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 512)};
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getProcedureOrFunctionColumns(Field[] fields, String catalog, String schemaPattern, String procedureOrFunctionNamePattern, String columnNamePattern, boolean returnProcedures, boolean returnFunctions) throws SQLException {
        boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        ArrayList<ComparableWrapper> procsOrFuncsToExtract = new ArrayList<ComparableWrapper>();
        ResultSet procsAndOrFuncsRs = null;
        try {
            procsAndOrFuncsRs = this.getProceduresAndOrFunctions(this.createFieldMetadataForGetProcedures(), catalog, schemaPattern, procedureOrFunctionNamePattern, returnProcedures, returnFunctions);
            boolean hasResults = false;
            while (procsAndOrFuncsRs.next()) {
                procsOrFuncsToExtract.add(new ComparableWrapper(this, (Comparable)new TableDbObjectKey(dbMapsToSchema ? procsAndOrFuncsRs.getString("PROCEDURE_SCHEM") : procsAndOrFuncsRs.getString("PROCEDURE_CAT"), procsAndOrFuncsRs.getString("PROCEDURE_NAME")), (Object)(procsAndOrFuncsRs.getShort("PROCEDURE_TYPE") == 1 ? ProcedureType.PROCEDURE : ProcedureType.FUNCTION)));
                hasResults = true;
            }
            if (!hasResults) {
            } else {
                Collections.sort(procsOrFuncsToExtract);
            }
        }
        finally {
            SQLException rethrowSqlEx = null;
            if (procsAndOrFuncsRs != null) {
                try {
                    procsAndOrFuncsRs.close();
                }
                catch (SQLException sqlEx) {
                    rethrowSqlEx = sqlEx;
                }
                procsAndOrFuncsRs = null;
            }
            if (rethrowSqlEx != null) {
                throw rethrowSqlEx;
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (ComparableWrapper procOrFunc : procsOrFuncsToExtract) {
            TableDbObjectKey dbObject = (TableDbObjectKey)procOrFunc.getKey();
            ProcedureType procType = (ProcedureType)((Object)procOrFunc.getValue());
            this.getProcedureOrFunctionParameterTypes(dbObject.dbName, dbObject.objectName, procType, columnNamePattern, rows, fields.length == 17);
        }
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return this.getProceduresAndOrFunctions(this.createFieldMetadataForGetProcedures(), catalog, schemaPattern, procedureNamePattern, true, this.conn.getPropertySet().getBooleanProperty(PropertyKey.getProceduresReturnsFunctions).getValue());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createFieldMetadataForGetProcedures() {
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "PROCEDURE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "PROCEDURE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "reserved1", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "reserved2", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "reserved3", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "PROCEDURE_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "SPECIFIC_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255)};
        return fields;
    }

    protected ResultSet getProceduresAndOrFunctions(final Field[] fields, String catalog, String schemaPattern, String procedureNamePattern, final boolean includeProcedures, final boolean includeFunctions) throws SQLException {
        ArrayList rows = new ArrayList();
        final boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        String dbFilter = this.getDatabase(catalog, schemaPattern);
        final String procedureNameFilter = this.pedantic ? procedureNamePattern : StringUtils.unQuoteIdentifier(procedureNamePattern, this.quotedId);
        final ArrayList procedureRowsToSort = new ArrayList();
        new IterateBlock<String>(dbMapsToSchema ? this.getSchemaPatternIterator(dbFilter) : this.getDatabaseIterator(dbFilter)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void forEach(String db) throws SQLException {
                ResultSet proceduresRs = null;
                StringBuilder selectFromMySQLProcSQL = new StringBuilder();
                selectFromMySQLProcSQL.append("SELECT db, name, type, comment FROM mysql.proc WHERE");
                if (includeProcedures && !includeFunctions) {
                    selectFromMySQLProcSQL.append(" type = 'PROCEDURE' AND ");
                } else if (!includeProcedures && includeFunctions) {
                    selectFromMySQLProcSQL.append(" type = 'FUNCTION' AND ");
                }
                selectFromMySQLProcSQL.append(dbMapsToSchema ? " db LIKE ?" : " db = ?");
                if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                    selectFromMySQLProcSQL.append(" AND name LIKE ?");
                }
                selectFromMySQLProcSQL.append(" ORDER BY name, type");
                PreparedStatement proceduresStmt = DatabaseMetaData.this.prepareMetaDataSafeStatement(selectFromMySQLProcSQL.toString());
                try {
                    proceduresStmt.setString(1, DatabaseMetaData.this.storesLowerCaseIdentifiers() ? db.toLowerCase() : db);
                    if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                        proceduresStmt.setString(2, procedureNameFilter);
                    }
                    try {
                        proceduresRs = proceduresStmt.executeQuery();
                        if (includeProcedures) {
                            DatabaseMetaData.this.convertToJdbcProcedureList(true, proceduresRs, procedureRowsToSort);
                        }
                        if (includeFunctions) {
                            DatabaseMetaData.this.convertToJdbcFunctionList(proceduresRs, procedureRowsToSort, fields);
                        }
                    }
                    catch (SQLException e) {
                        String sql;
                        if (includeFunctions) {
                            proceduresStmt.close();
                            sql = "SHOW FUNCTION STATUS WHERE " + (dbMapsToSchema ? "Db LIKE ?" : "Db = ?");
                            if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                                sql = sql + " AND Name LIKE ?";
                            }
                            proceduresStmt = DatabaseMetaData.this.prepareMetaDataSafeStatement(sql);
                            proceduresStmt.setString(1, db);
                            if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                                proceduresStmt.setString(2, procedureNameFilter);
                            }
                            proceduresRs = proceduresStmt.executeQuery();
                            DatabaseMetaData.this.convertToJdbcFunctionList(proceduresRs, procedureRowsToSort, fields);
                        }
                        if (includeProcedures) {
                            proceduresStmt.close();
                            sql = "SHOW PROCEDURE STATUS WHERE " + (dbMapsToSchema ? "Db LIKE ?" : "Db = ?");
                            if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                                sql = sql + " AND Name LIKE ?";
                            }
                            proceduresStmt = DatabaseMetaData.this.prepareMetaDataSafeStatement(sql);
                            proceduresStmt.setString(1, db);
                            if (!StringUtils.isNullOrEmpty(procedureNameFilter)) {
                                proceduresStmt.setString(2, procedureNameFilter);
                            }
                            proceduresRs = proceduresStmt.executeQuery();
                            DatabaseMetaData.this.convertToJdbcProcedureList(false, proceduresRs, procedureRowsToSort);
                        }
                    }
                }
                finally {
                    SQLException rethrowSqlEx = null;
                    if (proceduresRs != null) {
                        try {
                            proceduresRs.close();
                        }
                        catch (SQLException sqlEx) {
                            rethrowSqlEx = sqlEx;
                        }
                        proceduresRs = null;
                    }
                    if (proceduresStmt != null) {
                        try {
                            proceduresStmt.close();
                        }
                        catch (SQLException sqlEx) {
                            rethrowSqlEx = sqlEx;
                        }
                        proceduresStmt = null;
                    }
                    if (rethrowSqlEx != null) {
                        throw rethrowSqlEx;
                    }
                }
            }
        }.doForAll();
        Collections.sort(procedureRowsToSort);
        for (ComparableWrapper procRow : procedureRowsToSort) {
            rows.add(procRow.getValue());
        }
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return "PROCEDURE";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return 1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            return this.getSchemas(null, null);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            List<Object> dbList = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.getDatabases(schemaPattern) : new ArrayList();
            Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0), new Field("", "TABLE_CATALOG", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 0)};
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>(dbList.size());
            for (String string : dbList) {
                byte[][] row = new byte[][]{this.s2b(string), this.s2b("def")};
                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? "SCHEMA" : "";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return "\\";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            if (mysqlKeywords != null) {
                return mysqlKeywords;
            }
            LOCK.lock();
            try {
                if (mysqlKeywords != null) {
                    String string = mysqlKeywords;
                    return string;
                }
                TreeSet mysqlKeywordSet = new TreeSet();
                StringBuilder mysqlKeywordsBuffer = new StringBuilder();
                Collections.addAll(mysqlKeywordSet, MYSQL_KEYWORDS);
                mysqlKeywordSet.removeAll(SQL2003_KEYWORDS);
                for (String keyword : mysqlKeywordSet) {
                    mysqlKeywordsBuffer.append(",").append(keyword);
                }
                mysqlKeywords = mysqlKeywordsBuffer.substring(1);
                String string = mysqlKeywords;
                return string;
            }
            finally {
                LOCK.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return 2;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return "ASCII,BIN,BIT_LENGTH,CHAR,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONV,ELT,EXPORT_SET,FIELD,FIND_IN_SET,HEX,INSERT,INSTR,LCASE,LEFT,LENGTH,LOAD_FILE,LOCATE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH,MID,OCT,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SPACE,STRCMP,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SUPERTABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TYPE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SUPERTYPE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SUPERTYPE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "SUPERTYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 1), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTOR", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 77), new Field("", "GRANTEE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 77), new Field("", "PRIVILEGE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 64), new Field("", "IS_GRANTABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 3)};
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schemaPattern);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableNameFilter = this.pedantic ? tableNamePattern : StringUtils.unQuoteIdentifier(tableNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder("SELECT host,db,table_name,grantor,user,table_priv FROM mysql.tables_priv");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(dbMapsToSchema ? " db LIKE ?" : " db = ?");
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" table_name LIKE ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            ResultSet rs = null;
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            PreparedStatement pStmt = null;
            try {
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, this.storesLowerCaseIdentifiers() ? dbFilter.toLowerCase() : dbFilter);
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextId, this.storesLowerCaseIdentifiers() ? tableNameFilter.toLowerCase() : tableNameFilter);
                }
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String allPrivileges;
                    String host = rs.getString(1);
                    String db = rs.getString(2);
                    String table = rs.getString(3);
                    String grantor = rs.getString(4);
                    String user = rs.getString(5);
                    if (user == null || user.length() == 0) {
                        user = "%";
                    }
                    StringBuilder fullUser = new StringBuilder(user);
                    if (host != null && this.useHostsInPrivileges) {
                        fullUser.append("@");
                        fullUser.append(host);
                    }
                    if ((allPrivileges = rs.getString(6)) == null) continue;
                    allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                    StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                    while (st.hasMoreTokens()) {
                        String privilege = st.nextToken().trim();
                        ResultSet columnRs = null;
                        try {
                            columnRs = this.getColumns(catalog, schemaPattern, StringUtils.quoteIdentifier(table, this.quotedId, !this.pedantic), null);
                            while (columnRs.next()) {
                                byte[][] row = new byte[8][];
                                row[0] = dbMapsToSchema ? this.s2b("def") : this.s2b(db);
                                row[1] = dbMapsToSchema ? this.s2b(db) : null;
                                row[2] = this.s2b(table);
                                row[3] = grantor != null ? this.s2b(grantor) : null;
                                row[4] = this.s2b(fullUser.toString());
                                row[5] = this.s2b(privilege);
                                row[6] = null;
                                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                            }
                        }
                        finally {
                            if (columnRs == null) continue;
                            try {
                                columnRs.close();
                            }
                            catch (Exception exception) {}
                            columnRs = null;
                        }
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                    rs = null;
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (Exception exception) {}
                    pStmt = null;
                }
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, final String[] types) throws SQLException {
        try {
            final TreeMap sortedRows = new TreeMap();
            ArrayList rows = new ArrayList();
            final Statement stmt = this.conn.getMetadataSafeStatement();
            final boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            final String tableNameFilter = this.pedantic ? tableNamePattern : StringUtils.unQuoteIdentifier(tableNamePattern, this.quotedId);
            try {
                new IterateBlock<String>(dbMapsToSchema ? this.getSchemaPatternIterator(dbFilter) : this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        boolean operatingOnSystemDB = "information_schema".equalsIgnoreCase(db) || "mysql".equalsIgnoreCase(db) || "performance_schema".equalsIgnoreCase(db) || "sys".equalsIgnoreCase(db);
                        ResultSet rs = null;
                        try {
                            try {
                                StringBuilder query = new StringBuilder("SHOW FULL TABLES FROM ");
                                query.append(StringUtils.quoteIdentifier(db, DatabaseMetaData.this.quotedId, true));
                                if (tableNameFilter != null) {
                                    query.append(" LIKE ");
                                    query.append(StringUtils.quoteIdentifier(tableNameFilter, "'", true));
                                }
                                rs = stmt.executeQuery(query.toString());
                            }
                            catch (SQLException sqlEx) {
                                if ("08S01".equals(sqlEx.getSQLState())) {
                                    throw sqlEx;
                                }
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    rs = null;
                                }
                                return;
                            }
                            boolean shouldReportTables = false;
                            boolean shouldReportViews = false;
                            boolean shouldReportSystemTables = false;
                            boolean shouldReportSystemViews = false;
                            boolean shouldReportLocalTemporaries = false;
                            if (types == null || types.length == 0) {
                                shouldReportTables = true;
                                shouldReportViews = true;
                                shouldReportSystemTables = true;
                                shouldReportSystemViews = true;
                                shouldReportLocalTemporaries = true;
                            } else {
                                for (int i = 0; i < types.length; ++i) {
                                    if (TableType.TABLE.equalsTo(types[i])) {
                                        shouldReportTables = true;
                                        continue;
                                    }
                                    if (TableType.VIEW.equalsTo(types[i])) {
                                        shouldReportViews = true;
                                        continue;
                                    }
                                    if (TableType.SYSTEM_TABLE.equalsTo(types[i])) {
                                        shouldReportSystemTables = true;
                                        continue;
                                    }
                                    if (TableType.SYSTEM_VIEW.equalsTo(types[i])) {
                                        shouldReportSystemViews = true;
                                        continue;
                                    }
                                    if (!TableType.LOCAL_TEMPORARY.equalsTo(types[i])) continue;
                                    shouldReportLocalTemporaries = true;
                                }
                            }
                            int typeColumnIndex = 0;
                            boolean hasTableTypes = false;
                            try {
                                typeColumnIndex = rs.findColumn("table_type");
                                hasTableTypes = true;
                            }
                            catch (SQLException sqlEx) {
                                try {
                                    typeColumnIndex = rs.findColumn("Type");
                                    hasTableTypes = true;
                                }
                                catch (SQLException sqlEx2) {
                                    hasTableTypes = false;
                                }
                            }
                            block24: while (rs.next()) {
                                byte[][] row = new byte[10][];
                                row[0] = dbMapsToSchema ? DatabaseMetaData.this.s2b("def") : DatabaseMetaData.this.s2b(db);
                                row[1] = dbMapsToSchema ? DatabaseMetaData.this.s2b(db) : null;
                                row[2] = rs.getBytes(1);
                                row[4] = new byte[0];
                                row[5] = null;
                                row[6] = null;
                                row[7] = null;
                                row[8] = null;
                                row[9] = null;
                                if (hasTableTypes) {
                                    String tableType = rs.getString(typeColumnIndex);
                                    switch (TableType.getTableTypeCompliantWith(tableType)) {
                                        case TABLE: {
                                            boolean reportTable = false;
                                            TableMetaDataKey tablesKey = null;
                                            if (operatingOnSystemDB && shouldReportSystemTables) {
                                                row[3] = TableType.SYSTEM_TABLE.asBytes();
                                                tablesKey = new TableMetaDataKey(TableType.SYSTEM_TABLE.getName(), db, null, rs.getString(1));
                                                reportTable = true;
                                            } else if (!operatingOnSystemDB && shouldReportTables) {
                                                row[3] = TableType.TABLE.asBytes();
                                                tablesKey = new TableMetaDataKey(TableType.TABLE.getName(), db, null, rs.getString(1));
                                                reportTable = true;
                                            }
                                            if (!reportTable) continue block24;
                                            sortedRows.put(tablesKey, new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                        case VIEW: {
                                            if (!shouldReportViews) continue block24;
                                            row[3] = TableType.VIEW.asBytes();
                                            sortedRows.put(new TableMetaDataKey(TableType.VIEW.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                        case SYSTEM_TABLE: {
                                            if (!shouldReportSystemTables) continue block24;
                                            row[3] = TableType.SYSTEM_TABLE.asBytes();
                                            sortedRows.put(new TableMetaDataKey(TableType.SYSTEM_TABLE.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                        case SYSTEM_VIEW: {
                                            if (!shouldReportSystemViews) continue block24;
                                            row[3] = TableType.SYSTEM_VIEW.asBytes();
                                            sortedRows.put(new TableMetaDataKey(TableType.SYSTEM_VIEW.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                        case LOCAL_TEMPORARY: {
                                            if (!shouldReportLocalTemporaries) continue block24;
                                            row[3] = TableType.LOCAL_TEMPORARY.asBytes();
                                            sortedRows.put(new TableMetaDataKey(TableType.LOCAL_TEMPORARY.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                        default: {
                                            row[3] = TableType.TABLE.asBytes();
                                            sortedRows.put(new TableMetaDataKey(TableType.TABLE.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (!shouldReportTables) continue;
                                row[3] = TableType.TABLE.asBytes();
                                sortedRows.put(new TableMetaDataKey(TableType.TABLE.getName(), db, null, rs.getString(1)), new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                                rs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            rows.addAll(sortedRows.values());
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, this.createTablesFields()));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected ColumnDefinition createTablesFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 255), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 255), new Field("", "TABLE_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 5), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "TYPE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "TYPE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "SELF_REFERENCING_COL_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0), new Field("", "REF_GENERATION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 0)};
        return new DefaultColumnDefinition(fields);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            Field[] fields = new Field[]{new Field("", "TABLE_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 256)};
            rows.add(new ByteArrayRow(new byte[][]{TableType.LOCAL_TEMPORARY.asBytes()}, this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(new byte[][]{TableType.SYSTEM_TABLE.asBytes()}, this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(new byte[][]{TableType.SYSTEM_VIEW.asBytes()}, this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(new byte[][]{TableType.TABLE.asBytes()}, this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(new byte[][]{TableType.VIEW.asBytes()}, this.getExceptionInterceptor()));
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private byte[][] getTypeInfo(String mysqlTypeName) throws SQLException {
        MysqlType mt = MysqlType.getByName(mysqlTypeName);
        byte[][] row = new byte[18][];
        row[0] = this.s2b(mysqlTypeName);
        row[1] = Integer.toString(mt == MysqlType.YEAR && !this.yearIsDateType ? 5 : mt.getJdbcType()).getBytes();
        row[2] = Integer.toString(mt.getPrecision() > Integer.MAX_VALUE ? Integer.MAX_VALUE : mt.getPrecision().intValue()).getBytes();
        switch (mt) {
            case ENUM: 
            case SET: 
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case TEXT: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case BINARY: 
            case VARBINARY: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: 
            case GEOMETRY: 
            case UNKNOWN: 
            case VECTOR: {
                row[3] = this.s2b("'");
                row[4] = this.s2b("'");
                break;
            }
            default: {
                row[3] = this.s2b("");
                row[4] = this.s2b("");
            }
        }
        row[5] = this.s2b(mt.getCreateParams());
        row[6] = Integer.toString(1).getBytes();
        row[7] = this.s2b("true");
        row[8] = Integer.toString(3).getBytes();
        row[9] = this.s2b(mt.isAllowed(32) ? "true" : "false");
        row[10] = this.s2b("false");
        switch (mt) {
            case TINYINT: 
            case TINYINT_UNSIGNED: 
            case BOOLEAN: 
            case BIGINT: 
            case BIGINT_UNSIGNED: 
            case INT: 
            case INT_UNSIGNED: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: 
            case SMALLINT: 
            case SMALLINT_UNSIGNED: {
                row[11] = this.s2b("true");
                break;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: 
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                boolean supportsAutoIncrement = !this.session.versionMeetsMinimum(8, 4, 0);
                row[11] = supportsAutoIncrement ? this.s2b("true") : this.s2b("false");
                break;
            }
            default: {
                row[11] = this.s2b("false");
            }
        }
        row[12] = this.s2b(mt.getName());
        switch (mt) {
            case DECIMAL: 
            case DECIMAL_UNSIGNED: 
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                row[13] = this.s2b("-308");
                row[14] = this.s2b("308");
                break;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                row[13] = this.s2b("-38");
                row[14] = this.s2b("38");
                break;
            }
            default: {
                row[13] = this.s2b("0");
                row[14] = this.s2b("0");
            }
        }
        row[15] = this.s2b("0");
        row[16] = this.s2b("0");
        row[17] = this.s2b("10");
        return row;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 5), new Field("", "PRECISION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "LITERAL_PREFIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 4), new Field("", "LITERAL_SUFFIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 4), new Field("", "CREATE_PARAMS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "CASE_SENSITIVE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BOOLEAN, 3), new Field("", "SEARCHABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 3), new Field("", "UNSIGNED_ATTRIBUTE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BOOLEAN, 3), new Field("", "FIXED_PREC_SCALE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BOOLEAN, 3), new Field("", "AUTO_INCREMENT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.BOOLEAN, 3), new Field("", "LOCAL_TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "MINIMUM_SCALE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "MAXIMUM_SCALE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "SQL_DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "SQL_DATETIME_SUB", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "NUM_PREC_RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10)};
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            rows.add(new ByteArrayRow(this.getTypeInfo("BIT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TINYINT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TINYINT UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("BIGINT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("BIGINT UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("LONG VARBINARY"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMBLOB"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("LONGBLOB"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("BLOB"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("VECTOR"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("VARBINARY"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TINYBLOB"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("BINARY"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("LONG VARCHAR"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMTEXT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("LONGTEXT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TEXT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("CHAR"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("ENUM"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("SET"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DECIMAL"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("NUMERIC"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("INTEGER"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("INT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMINT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("INTEGER UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("INT UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMINT UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("SMALLINT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("SMALLINT UNSIGNED"), this.getExceptionInterceptor()));
            if (!this.yearIsDateType) {
                rows.add(new ByteArrayRow(this.getTypeInfo("YEAR"), this.getExceptionInterceptor()));
            }
            rows.add(new ByteArrayRow(this.getTypeInfo("FLOAT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE PRECISION"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("REAL"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE PRECISION UNSIGNED"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("VARCHAR"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TINYTEXT"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("BOOL"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DATE"), this.getExceptionInterceptor()));
            if (this.yearIsDateType) {
                rows.add(new ByteArrayRow(this.getTypeInfo("YEAR"), this.getExceptionInterceptor()));
            }
            rows.add(new ByteArrayRow(this.getTypeInfo("TIME"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("DATETIME"), this.getExceptionInterceptor()));
            rows.add(new ByteArrayRow(this.getTypeInfo("TIMESTAMP"), this.getExceptionInterceptor()));
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 32), new Field("", "TYPE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 32), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 32), new Field("", "CLASS_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 32), new Field("", "BASE_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 10)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this.conn.getURL();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        try {
            if (this.useHostsInPrivileges) {
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = this.conn.getMetadataSafeStatement();
                    rs = stmt.executeQuery("SELECT USER()");
                    rs.next();
                    String string = rs.getString(1);
                    return string;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        rs = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        stmt = null;
                    }
                }
            }
            return this.conn.getUser();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] getVersionColumnsFields() {
        Field[] fields = new Field[]{new Field("", "SCOPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 32), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 5), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 16), new Field("", "COLUMN_SIZE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 16), new Field("", "BUFFER_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 16), new Field("", "DECIMAL_DIGITS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 16), new Field("", "PSEUDO_COLUMN", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 5)};
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.getDatabase(catalog, schema);
            final String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            final ArrayList rows = new ArrayList();
            try (final Statement stmt = this.conn.getMetadataSafeStatement();){
                new IterateBlock<String>(this.getDatabaseIterator(dbFilter)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void forEach(String db) throws SQLException {
                        ResultSet rs = null;
                        try {
                            block16: {
                                StringBuilder query = new StringBuilder("SHOW COLUMNS FROM ");
                                query.append(StringUtils.quoteIdentifier(tableFilter, DatabaseMetaData.this.quotedId, true));
                                query.append(" FROM ");
                                query.append(StringUtils.quoteIdentifier(db, DatabaseMetaData.this.quotedId, true));
                                query.append(" WHERE Extra LIKE '%on update CURRENT_TIMESTAMP%'");
                                try {
                                    rs = stmt.executeQuery(query.toString());
                                }
                                catch (SQLException e) {
                                    String sqlState = e.getSQLState();
                                    int errorCode = e.getErrorCode();
                                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) break block16;
                                    throw e;
                                }
                            }
                            while (rs != null && rs.next()) {
                                TypeDescriptor typeDesc = new TypeDescriptor(rs.getString("Type"), rs.getString("Null"));
                                byte[][] row = new byte[][]{null, rs.getBytes("Field"), Short.toString(typeDesc.mysqlType == MysqlType.YEAR && !DatabaseMetaData.this.yearIsDateType ? (short)5 : (short)typeDesc.mysqlType.getJdbcType()).getBytes(), DatabaseMetaData.this.s2b(typeDesc.mysqlType.getName()), typeDesc.columnSize == null ? null : DatabaseMetaData.this.s2b(typeDesc.columnSize.toString()), DatabaseMetaData.this.s2b(Integer.toString(typeDesc.bufferLength)), typeDesc.decimalDigits == null ? null : DatabaseMetaData.this.s2b(typeDesc.decimalDigits.toString()), Integer.toString(1).getBytes()};
                                rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                            }
                        }
                        catch (SQLException sqlEx) {
                            if (!"42S02".equals(sqlEx.getSQLState())) {
                                throw sqlEx;
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                                rs = null;
                            }
                        }
                    }
                }.doForAll();
            }
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.getVersionColumnsFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.conn.getPropertySet().getBooleanProperty(PropertyKey.emulateLocators).getValue() == false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return !this.nullsAreSortedHigh();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    void populateKeyResults(String parentDatabase, String parentTable, String foreignDatabase, String foreignTable, String keys, boolean forExport, List<Row> resultRows) throws SQLException {
        ReferencingAndReferencedColumns parsedInfo = this.parseTableStatusIntoReferencingAndReferencedColumns(keys);
        if (forExport) {
            if (parentDatabase == null && this.nullDatabaseMeansCurrent.getValue().booleanValue()) {
                parentDatabase = this.database;
            }
            if (!parsedInfo.referencedTable.contentEquals(parentTable) || parentDatabase != null && !parsedInfo.referencedDatabase.contentEquals(parentDatabase)) {
                return;
            }
        }
        if (parsedInfo.referencingColumnsList.size() != parsedInfo.referencedColumnsList.size()) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.12"), "S1000", this.getExceptionInterceptor());
        }
        boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        int keySeq = 1;
        Iterator<String> referencingColumns = parsedInfo.referencingColumnsList.iterator();
        Iterator<String> referencedColumns = parsedInfo.referencedColumnsList.iterator();
        while (referencingColumns.hasNext()) {
            byte[][] row = new byte[14][];
            row[0] = dbMapsToSchema ? this.s2b("def") : this.s2b(parsedInfo.referencedDatabase);
            row[1] = dbMapsToSchema ? this.s2b(parsedInfo.referencedDatabase) : null;
            row[2] = this.s2b(parsedInfo.referencedTable);
            String referencedColumn = StringUtils.unQuoteIdentifier(referencedColumns.next(), this.quotedId);
            row[3] = this.s2b(referencedColumn);
            row[4] = dbMapsToSchema ? this.s2b("def") : this.s2b(foreignDatabase);
            row[5] = dbMapsToSchema ? this.s2b(foreignDatabase) : null;
            row[6] = this.s2b(foreignTable);
            String referencingColumn = StringUtils.unQuoteIdentifier(referencingColumns.next(), this.quotedId);
            row[7] = this.s2b(referencingColumn);
            row[8] = this.s2b(Integer.toString(keySeq++));
            int[] actions = this.getForeignKeyActions(keys);
            row[9] = this.s2b(Integer.toString(actions[1]));
            row[10] = this.s2b(Integer.toString(actions[0]));
            row[11] = this.s2b(parsedInfo.constraintName);
            row[12] = null;
            row[13] = this.s2b(Integer.toString(7));
            resultRows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
        }
    }

    ReferencingAndReferencedColumns parseTableStatusIntoReferencingAndReferencedColumns(String keysComment) throws SQLException {
        String columnsDelimitter = ",";
        int indexOfOpenParenLocalColumns = StringUtils.indexOfIgnoreCase(0, keysComment, "(", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (indexOfOpenParenLocalColumns == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.14"), "S1000", this.getExceptionInterceptor());
        }
        String constraintName = StringUtils.unQuoteIdentifier(keysComment.substring(0, indexOfOpenParenLocalColumns).trim(), this.quotedId);
        String keysCommentTrimmed = (keysComment = keysComment.substring(indexOfOpenParenLocalColumns, keysComment.length())).trim();
        int indexOfCloseParenLocalColumns = StringUtils.indexOfIgnoreCase(0, keysCommentTrimmed, ")", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (indexOfCloseParenLocalColumns == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.15"), "S1000", this.getExceptionInterceptor());
        }
        String localColumnNames = keysCommentTrimmed.substring(1, indexOfCloseParenLocalColumns);
        int indexOfRefer = StringUtils.indexOfIgnoreCase(0, keysCommentTrimmed, "REFER ", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (indexOfRefer == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.16"), "S1000", this.getExceptionInterceptor());
        }
        int indexOfOpenParenReferCol = StringUtils.indexOfIgnoreCase(indexOfRefer += "REFER ".length(), keysCommentTrimmed, "(", this.quotedId, this.quotedId, SearchMode.__MRK_COM_MYM_HNT_WS);
        if (indexOfOpenParenReferCol == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.17"), "S1000", this.getExceptionInterceptor());
        }
        String referDbTable = keysCommentTrimmed.substring(indexOfRefer, indexOfOpenParenReferCol);
        int indexOfSlash = StringUtils.indexOfIgnoreCase(0, referDbTable, "/", this.quotedId, this.quotedId, SearchMode.__MRK_COM_MYM_HNT_WS);
        if (indexOfSlash == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.18"), "S1000", this.getExceptionInterceptor());
        }
        String referDb = StringUtils.unQuoteIdentifier(referDbTable.substring(0, indexOfSlash), this.quotedId);
        String referTable = StringUtils.unQuoteIdentifier(referDbTable.substring(indexOfSlash + 1), this.quotedId);
        int indexOfCloseParenRefer = StringUtils.indexOfIgnoreCase(indexOfOpenParenReferCol, keysCommentTrimmed, ")", this.quotedId, this.quotedId, SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (indexOfCloseParenRefer == -1) {
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.19"), "S1000", this.getExceptionInterceptor());
        }
        String referColumnNamesString = keysCommentTrimmed.substring(indexOfOpenParenReferCol + 1, indexOfCloseParenRefer);
        List<String> referColumnsList = StringUtils.split(referColumnNamesString, columnsDelimitter, this.quotedId, this.quotedId, false);
        List<String> localColumnsList = StringUtils.split(localColumnNames, columnsDelimitter, this.quotedId, this.quotedId, false);
        return new ReferencingAndReferencedColumns(localColumnsList, referColumnsList, constraintName, referDb, referTable);
    }

    protected int[] getForeignKeyActions(String commentString) {
        int[] actions = new int[]{1, 1};
        int lastParenIndex = commentString.lastIndexOf(")");
        if (lastParenIndex != commentString.length() - 1) {
            String cascadeOptions = commentString.substring(lastParenIndex + 1).trim().toUpperCase(Locale.ENGLISH);
            actions[0] = this.getCascadeDeleteOption(cascadeOptions);
            actions[1] = this.getCascadeUpdateOption(cascadeOptions);
        }
        return actions;
    }

    protected String normalizeCase(String entity) {
        if (entity == null) {
            return null;
        }
        try {
            return this.storesLowerCaseIdentifiers() ? entity.toLowerCase() : entity;
        }
        catch (SQLException e) {
            return entity;
        }
    }

    protected byte[] s2b(String s2) throws SQLException {
        if (s2 == null) {
            return null;
        }
        try {
            return StringUtils.getBytes(s2, this.conn.getCharacterSetMetadata());
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.conn.storesLowerCaseTableName();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.conn.storesLowerCaseTableName();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return !this.conn.storesLowerCaseTableName();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return !this.conn.storesLowerCaseTableName();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return MysqlType.supportsConvert(fromType, toType);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.conn.getPropertySet().getBooleanProperty(PropertyKey.overrideSupportsIntegrityEnhancementFacility).getValue() != false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return !this.conn.lowerCaseTableNames();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return !this.conn.lowerCaseTableNames();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            if (!(type != 1003 && type != 1004 || concurrency != 1007 && concurrency != 1008)) {
                return true;
            }
            if (type == 1005) {
                return false;
            }
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.20"), "S1009", this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return holdability == 1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return type == 1003 || type == 1004;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            switch (level) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 255), new Field("", "MAX_LEN", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 10), new Field("", "DEFAULT_VALUE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 255), new Field("", "DESCRIPTION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 255)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            return this.getProcedureOrFunctionColumns(this.createFunctionColumnsFields(), catalog, schemaPattern, functionNamePattern, columnNamePattern, false, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected Field[] createFunctionColumnsFields() {
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "FUNCTION_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "FUNCTION_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "COLUMN_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 64), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "TYPE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 64), new Field("", "PRECISION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "SCALE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 12), new Field("", "RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "CHAR_OCTET_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "ORDINAL_POSITION", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 32), new Field("", "IS_NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 12), new Field("", "SPECIFIC_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 64)};
        return fields;
    }

    protected Field[] getFunctionsFields() {
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "FUNCTION_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "FUNCTION_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255), new Field("", "FUNCTION_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.SMALLINT, 6), new Field("", "SPECIFIC_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.CHAR, 255)};
        return fields;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return this.getProceduresAndOrFunctions(this.getFunctionsFields(), catalog, schemaPattern, functionNamePattern, false, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public boolean providesQueryObjectGenerator() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    protected PreparedStatement prepareMetaDataSafeStatement(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "TABLE_SCHEM", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "TABLE_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "COLUMN_NAME", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "DATA_TYPE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "COLUMN_SIZE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "DECIMAL_DIGITS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "NUM_PREC_RADIX", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "COLUMN_USAGE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "REMARKS", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512), new Field("", "CHAR_OCTET_LENGTH", this.metadataCollationIndex, this.metadataEncoding, MysqlType.INT, 12), new Field("", "IS_NULLABLE", this.metadataCollationIndex, this.metadataEncoding, MysqlType.VARCHAR, 512)};
            return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        try {
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.conn.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public String getMetadataEncoding() {
        return this.metadataEncoding;
    }

    public void setMetadataEncoding(String metadataEncoding) {
        this.metadataEncoding = metadataEncoding;
    }

    public int getMetadataCollationIndex() {
        return this.metadataCollationIndex;
    }

    public void setMetadataCollationIndex(int metadataCollationIndex) {
        this.metadataCollationIndex = metadataCollationIndex;
    }

    private static /* synthetic */ String lambda$prepareMetaDataSafeStatement$3() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$prepareMetaDataSafeStatement$2() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$prepareMetaDataSafeStatement$1() {
        return this.conn.getUser();
    }

    private /* synthetic */ String lambda$prepareMetaDataSafeStatement$0() {
        return this.conn.getDatabase();
    }

    protected static enum ProcedureType {
        PROCEDURE,
        FUNCTION;

    }

    protected static enum TableType {
        LOCAL_TEMPORARY("LOCAL TEMPORARY"),
        SYSTEM_TABLE("SYSTEM TABLE"),
        SYSTEM_VIEW("SYSTEM VIEW"),
        TABLE("TABLE", new String[]{"BASE TABLE"}),
        VIEW("VIEW"),
        UNKNOWN("UNKNOWN");

        private String name;
        private byte[] nameAsBytes;
        private String[] synonyms;

        private TableType(String tableTypeName) {
            this(tableTypeName, null);
        }

        private TableType(String tableTypeName, String[] tableTypeSynonyms) {
            this.name = tableTypeName;
            this.nameAsBytes = tableTypeName.getBytes();
            this.synonyms = tableTypeSynonyms;
        }

        String getName() {
            return this.name;
        }

        byte[] asBytes() {
            return this.nameAsBytes;
        }

        boolean equalsTo(String tableTypeName) {
            return this.name.equalsIgnoreCase(tableTypeName);
        }

        static TableType getTableTypeEqualTo(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.equalsTo(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }

        boolean compliesWith(String tableTypeName) {
            if (this.equalsTo(tableTypeName)) {
                return true;
            }
            if (this.synonyms != null) {
                for (String synonym : this.synonyms) {
                    if (!synonym.equalsIgnoreCase(tableTypeName)) continue;
                    return true;
                }
            }
            return false;
        }

        static TableType getTableTypeCompliantWith(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.compliesWith(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }
    }

    protected static class ComparableWrapper<K extends Comparable<? super K>, V>
    implements Comparable<ComparableWrapper<K, V>> {
        K key;
        V value;
        final /* synthetic */ DatabaseMetaData this$0;

        public ComparableWrapper(K key, V value) {
            this.this$0 = this$0;
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ComparableWrapper<K, V> other) {
            return this.getKey().compareTo(other.getKey());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ComparableWrapper)) {
                return false;
            }
            K otherKey = ((ComparableWrapper)obj).getKey();
            return this.key.equals(otherKey);
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 0;
        }

        public String toString() {
            return "{KEY:" + this.key + "; VALUE:" + this.value + "}";
        }
    }

    protected class TableDbObjectKey
    implements Comparable<TableDbObjectKey> {
        String dbName;
        String objectName;

        TableDbObjectKey(String dbName, String objectName) {
            this.dbName = dbName;
            this.objectName = objectName;
        }

        @Override
        public int compareTo(TableDbObjectKey tablesKey) {
            int compareResult = this.dbName.compareTo(tablesKey.dbName);
            if (compareResult != 0 || (compareResult = this.objectName.compareTo(tablesKey.objectName)) != 0) {
                return compareResult;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TableDbObjectKey)) {
                return false;
            }
            return this.compareTo((TableDbObjectKey)obj) == 0;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 0;
        }
    }

    protected class TableMetaDataKey
    implements Comparable<TableMetaDataKey> {
        String tableType;
        String tableCat;
        String tableSchem;
        String tableName;

        TableMetaDataKey(String tableType, String tableCat, String tableSchem, String tableName) {
            this.tableType = tableType == null ? "" : tableType;
            this.tableCat = tableCat == null ? "" : tableCat;
            this.tableSchem = tableSchem == null ? "" : tableSchem;
            this.tableName = tableName == null ? "" : tableName;
        }

        @Override
        public int compareTo(TableMetaDataKey tablesKey) {
            int compareResult = this.tableType.compareTo(tablesKey.tableType);
            if (compareResult != 0 || (compareResult = this.tableCat.compareTo(tablesKey.tableCat)) != 0 || (compareResult = this.tableSchem.compareTo(tablesKey.tableSchem)) != 0) {
                return compareResult;
            }
            return this.tableName.compareTo(tablesKey.tableName);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TableMetaDataKey)) {
                return false;
            }
            return this.compareTo((TableMetaDataKey)obj) == 0;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 0;
        }
    }

    protected class IndexMetaDataKey
    implements Comparable<IndexMetaDataKey> {
        Boolean columnNonUnique;
        Short columnType;
        String columnIndexName;
        Short columnOrdinalPosition;

        IndexMetaDataKey(boolean columnNonUnique, short columnType, String columnIndexName, short columnOrdinalPosition) {
            this.columnNonUnique = columnNonUnique;
            this.columnType = columnType;
            this.columnIndexName = columnIndexName;
            this.columnOrdinalPosition = columnOrdinalPosition;
        }

        @Override
        public int compareTo(IndexMetaDataKey indexInfoKey) {
            int compareResult = this.columnNonUnique.compareTo(indexInfoKey.columnNonUnique);
            if (compareResult != 0 || (compareResult = this.columnType.compareTo(indexInfoKey.columnType)) != 0 || (compareResult = this.columnIndexName.compareTo(indexInfoKey.columnIndexName)) != 0) {
                return compareResult;
            }
            return this.columnOrdinalPosition.compareTo(indexInfoKey.columnOrdinalPosition);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IndexMetaDataKey)) {
                return false;
            }
            return this.compareTo((IndexMetaDataKey)obj) == 0;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 0;
        }
    }

    class TypeDescriptor {
        int bufferLength;
        Integer datetimePrecision = null;
        Integer columnSize = null;
        Integer charOctetLength = null;
        Integer decimalDigits = null;
        String isNullable;
        int nullability;
        int numPrecRadix = 10;
        String mysqlTypeName;
        MysqlType mysqlType;

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            if (typeInfo == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.0"), "S1009", DatabaseMetaData.this.getExceptionInterceptor());
            }
            this.mysqlType = MysqlType.getByName(typeInfo);
            int maxLength = 0;
            switch (this.mysqlType) {
                case ENUM: {
                    String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String nextToken = tokenizer.nextToken();
                        maxLength = Math.max(maxLength, nextToken.length() - 2);
                    }
                    this.columnSize = maxLength;
                    break;
                }
                case SET: {
                    String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    int numElements = tokenizer.countTokens();
                    if (numElements > 0) {
                        maxLength += numElements - 1;
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String setMember = tokenizer.nextToken().trim();
                        if (setMember.startsWith("'") && setMember.endsWith("'")) {
                            maxLength += setMember.length() - 2;
                            continue;
                        }
                        maxLength += setMember.length();
                    }
                    this.columnSize = maxLength;
                    break;
                }
                case FLOAT: 
                case FLOAT_UNSIGNED: {
                    if (typeInfo.indexOf(",") != -1) {
                        this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                        this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
                        break;
                    }
                    if (typeInfo.indexOf("(") != -1) {
                        int size = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim());
                        if (size <= 23) break;
                        this.mysqlType = this.mysqlType == MysqlType.FLOAT ? MysqlType.DOUBLE : MysqlType.DOUBLE_UNSIGNED;
                        this.columnSize = 22;
                        this.decimalDigits = 0;
                        break;
                    }
                    this.columnSize = 12;
                    this.decimalDigits = 0;
                    break;
                }
                case DECIMAL: 
                case DECIMAL_UNSIGNED: 
                case DOUBLE: 
                case DOUBLE_UNSIGNED: {
                    if (typeInfo.indexOf(",") != -1) {
                        this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                        this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
                        break;
                    }
                    switch (this.mysqlType) {
                        case DECIMAL: 
                        case DECIMAL_UNSIGNED: {
                            this.columnSize = 65;
                            break;
                        }
                        case DOUBLE: 
                        case DOUBLE_UNSIGNED: {
                            this.columnSize = 22;
                            break;
                        }
                    }
                    this.decimalDigits = 0;
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case TINYTEXT: 
                case MEDIUMTEXT: 
                case LONGTEXT: 
                case JSON: 
                case TEXT: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case BINARY: 
                case VARBINARY: 
                case BIT: {
                    if (this.mysqlType == MysqlType.CHAR) {
                        this.columnSize = 1;
                    }
                    if (typeInfo.indexOf("(") == -1) break;
                    int endParenIndex = typeInfo.indexOf(")");
                    if (endParenIndex == -1) {
                        endParenIndex = typeInfo.length();
                    }
                    this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex).trim());
                    if (!DatabaseMetaData.this.tinyInt1isBit || this.columnSize != 1 || !StringUtils.startsWithIgnoreCase(typeInfo, "tinyint")) break;
                    if (DatabaseMetaData.this.transformedBitIsBoolean) {
                        this.mysqlType = MysqlType.BOOLEAN;
                        break;
                    }
                    this.mysqlType = MysqlType.BIT;
                    break;
                }
                case TINYINT: {
                    if (DatabaseMetaData.this.tinyInt1isBit && typeInfo.indexOf("(1)") != -1) {
                        if (DatabaseMetaData.this.transformedBitIsBoolean) {
                            this.mysqlType = MysqlType.BOOLEAN;
                            break;
                        }
                        this.mysqlType = MysqlType.BIT;
                        break;
                    }
                    this.columnSize = 3;
                    break;
                }
                case TINYINT_UNSIGNED: {
                    this.columnSize = 3;
                    break;
                }
                case DATE: {
                    this.datetimePrecision = 0;
                    this.columnSize = 10;
                    break;
                }
                case TIME: {
                    int fract;
                    this.datetimePrecision = 0;
                    this.columnSize = 8;
                    if (typeInfo.indexOf("(") == -1 || (fract = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim())) <= 0) break;
                    this.datetimePrecision = fract;
                    TypeDescriptor typeDescriptor = this;
                    typeDescriptor.columnSize = typeDescriptor.columnSize + (fract + 1);
                    break;
                }
                case DATETIME: 
                case TIMESTAMP: {
                    int fract;
                    this.datetimePrecision = 0;
                    this.columnSize = 19;
                    if (typeInfo.indexOf("(") == -1 || (fract = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim())) <= 0) break;
                    this.datetimePrecision = fract;
                    TypeDescriptor typeDescriptor = this;
                    typeDescriptor.columnSize = typeDescriptor.columnSize + (fract + 1);
                    break;
                }
            }
            if (this.columnSize == null) {
                this.columnSize = this.mysqlType.getPrecision() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.mysqlType.getPrecision().intValue();
            }
            switch (this.mysqlType) {
                case CHAR: 
                case VARCHAR: 
                case TINYTEXT: 
                case MEDIUMTEXT: 
                case LONGTEXT: 
                case JSON: 
                case TEXT: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case BINARY: 
                case VARBINARY: 
                case BIT: {
                    this.charOctetLength = this.columnSize;
                    break;
                }
            }
            this.bufferLength = maxBufferSize;
            this.numPrecRadix = 10;
            if (nullabilityInfo != null) {
                if (nullabilityInfo.equals("YES")) {
                    this.nullability = 1;
                    this.isNullable = "YES";
                } else if (nullabilityInfo.equals("UNKNOWN")) {
                    this.nullability = 2;
                    this.isNullable = "";
                } else {
                    this.nullability = 0;
                    this.isNullable = "NO";
                }
            } else {
                this.nullability = 0;
                this.isNullable = "NO";
            }
        }
    }

    protected class SingleStringIterator
    extends IteratorWithCleanup<String> {
        boolean onFirst;
        String value;

        SingleStringIterator(String s2) {
            this.onFirst = true;
            this.value = s2;
        }

        @Override
        void close() throws SQLException {
        }

        @Override
        boolean hasNext() throws SQLException {
            return this.onFirst;
        }

        @Override
        String next() throws SQLException {
            this.onFirst = false;
            return this.value;
        }
    }

    protected class StringListIterator
    extends IteratorWithCleanup<String> {
        int idx;
        List<String> list;

        StringListIterator(List<String> list) {
            this.idx = -1;
            this.list = list;
        }

        @Override
        void close() throws SQLException {
            this.list = null;
        }

        @Override
        boolean hasNext() throws SQLException {
            return this.idx < this.list.size() - 1;
        }

        @Override
        String next() throws SQLException {
            ++this.idx;
            return this.list.get(this.idx);
        }
    }

    class ReferencingAndReferencedColumns {
        final List<String> referencingColumnsList;
        final List<String> referencedColumnsList;
        final String constraintName;
        final String referencedDatabase;
        final String referencedTable;

        ReferencingAndReferencedColumns(List<String> localColumns, List<String> refColumns, String constName, String refDatabase, String refTable) {
            this.referencingColumnsList = localColumns;
            this.referencedColumnsList = refColumns;
            this.constraintName = constName;
            this.referencedTable = refTable;
            this.referencedDatabase = refDatabase;
        }
    }

    protected abstract class IteratorWithCleanup<T> {
        protected IteratorWithCleanup() {
        }

        abstract void close() throws SQLException;

        abstract boolean hasNext() throws SQLException;

        abstract T next() throws SQLException;
    }
}

