/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.CommandHandler;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.connection.ConnectionManager;
import net.rafalohaki.veloauth.database.DatabaseConfig;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.database.DatabaseType;
import net.rafalohaki.veloauth.exception.VeloAuthException;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.listener.AuthListener;
import net.rafalohaki.veloauth.listener.EarlyLoginBlocker;
import net.rafalohaki.veloauth.premium.PremiumResolverService;
import net.rafalohaki.veloauth.util.VirtualThreadExecutorProvider;
import org.slf4j.Logger;

@Plugin(id="veloauth", name="VeloAuth", version="1.0.0", description="Complete Velocity Authentication Plugin with BCrypt, Virtual Threads and multi-database support", authors={"Rafal"})
public class VeloAuth {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private Settings settings;
    private Messages messages;
    private DatabaseManager databaseManager;
    private AuthCache authCache;
    private CommandHandler commandHandler;
    private ConnectionManager connectionManager;
    private AuthListener authListener;
    private PremiumResolverService premiumResolverService;
    private volatile boolean initialized = false;

    @Inject
    public VeloAuth(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        if (logger.isDebugEnabled()) {
            logger.debug("VeloAuth konstruktor - Java {}, Velocity API {}", (Object)System.getProperty("java.version"), (Object)server.getVersion().getVersion());
        }
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.logger.info("=== VeloAuth v1.0.0 - Initialization ===");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Java: {}, Virtual Threads: {}", (Object)System.getProperty("java.version"), (Object)(Thread.currentThread().isVirtual() ? "Available" : "Unavailable"));
        }
        this.logger.info("Registering early PreLogin blocker for initialization protection...");
        try {
            EarlyLoginBlocker earlyBlocker = new EarlyLoginBlocker(this);
            this.server.getEventManager().register((Object)this, (Object)earlyBlocker);
            this.logger.info("\u2705 EarlyLoginBlocker registered BEFORE initialization - PreLogin protection active");
        }
        catch (Exception e) {
            this.logger.error("Failed to register early PreLogin blocker", e);
            return;
        }
        CompletableFuture.runAsync(this::initializePlugin, VirtualThreadExecutorProvider.getVirtualExecutor()).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.logger.error("Error during VeloAuth initialization", (Throwable)throwable);
                this.shutdown();
            } else {
                if (this.databaseManager != null) {
                    this.databaseManager.clearCache();
                    this.logger.info("Cleared stale database cache entries");
                }
                if (this.authCache != null) {
                    this.authCache.clearAll();
                    this.logger.info("Cleared stale authentication cache entries");
                }
                this.initialized = true;
                this.logger.info(this.messages.get("plugin.initialization.ready", new Object[0]));
                this.logStartupInfo();
            }
        });
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info(this.messages.get("plugin.initialization.shutdown", new Object[0]));
        this.shutdown();
        this.logger.info(this.messages.get("plugin.initialization.closed", new Object[0]));
    }

    private void initializePlugin() {
        try {
            this.logger.info("Loading configuration...");
            this.settings = new Settings(this.dataDirectory);
            if (!this.settings.load()) {
                throw VeloAuthException.configuration("settings loading", null);
            }
            this.logger.info("Initializing message system...");
            this.messages = new Messages();
            this.messages.setLanguage(this.settings.getLanguage());
            this.logger.info(this.messages.get("plugin.initialization.loading_config", new Object[0]));
            this.logger.info(this.messages.get("plugin.initialization.init_messages", new Object[0]));
            this.logger.info(this.messages.get("plugin.initialization.init_database", new Object[0]));
            DatabaseConfig dbConfig = this.createDatabaseConfig();
            this.databaseManager = new DatabaseManager(dbConfig, this.messages);
            boolean dbInitialized = this.databaseManager.initialize().join();
            if (!dbInitialized) {
                throw VeloAuthException.database("initialization", null);
            }
            this.logger.info(this.messages.get("plugin.initialization.init_cache", new Object[0]));
            this.authCache = new AuthCache(this.settings.getCacheTtlMinutes(), this.settings.getCacheMaxSize(), this.settings.getCacheMaxSize(), this.settings.getCacheMaxSize(), this.settings.getBruteForceMaxAttempts(), this.settings.getBruteForceTimeoutMinutes(), this.settings.getCacheCleanupIntervalMinutes(), this.settings, this.messages);
            this.logger.info(this.messages.get("plugin.initialization.registering_commands", new Object[0]));
            this.commandHandler = new CommandHandler(this, this.databaseManager, this.authCache, this.settings, this.messages);
            this.commandHandler.registerCommands();
            this.logger.info(this.messages.get("plugin.initialization.init_connection_manager", new Object[0]));
            this.connectionManager = new ConnectionManager(this, this.databaseManager, this.authCache, this.settings, this.messages);
            this.logger.info(this.messages.get("plugin.initialization.init_premium_resolver", new Object[0]));
            this.premiumResolverService = new PremiumResolverService(this.logger, this.settings, this.databaseManager.getPremiumUuidDao());
            this.logger.info(this.messages.get("plugin.initialization.registering_listeners", new Object[0]));
            this.authListener = new AuthListener(this, this.connectionManager, this.authCache, this.settings, this.premiumResolverService, this.databaseManager, this.messages);
            this.server.getEventManager().register((Object)this, (Object)this.authListener);
            this.logger.info("\u2705 Full AuthListener registered after initialization");
            this.connectionManager.debugServers();
            this.logger.info(this.messages.get("plugin.initialization.components_ready", new Object[0]));
        }
        catch (IllegalStateException e) {
            this.logger.error("Critical state error during VeloAuth initialization", e);
            throw VeloAuthException.configuration("plugin initialization", e);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Critical argument error during VeloAuth initialization", e);
            throw VeloAuthException.configuration("invalid arguments", e);
        }
        catch (VeloAuthException e) {
            this.logger.error("VeloAuth error during initialization", e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unexpected error during VeloAuth initialization", e);
            throw VeloAuthException.configuration("unexpected error", e);
        }
    }

    private void waitForPendingOperations() {
        this.logger.debug("Component shutdown in progress - pending operations handled internally");
    }

    private DatabaseConfig createDatabaseConfig() {
        String storageType = this.settings.getDatabaseStorageType();
        DatabaseType dbType = DatabaseType.fromName(storageType);
        if (dbType != null && dbType.isLocalDatabase()) {
            return DatabaseConfig.forLocalDatabase(storageType, this.settings.getDatabaseName());
        }
        return DatabaseConfig.forRemoteWithHikari(storageType, this.settings.getDatabaseHostname(), this.settings.getDatabasePort(), this.settings.getDatabaseName(), this.settings.getDatabaseUser(), this.settings.getDatabasePassword(), this.settings.getDatabaseConnectionPoolSize(), (int)this.settings.getDatabaseMaxLifetimeMillis(), this.settings.getDatabaseConnectionParameters(), this.settings.getPostgreSQLSettings(), this.settings.isDebugEnabled());
    }

    private void shutdown() {
        this.initialized = false;
        try {
            this.logger.info("Inicjowanie graceful shutdown VeloAuth...");
            if (this.authListener != null) {
                this.server.getEventManager().unregisterListener((Object)this, (Object)this.authListener);
                this.logger.debug("AuthListener wyrejestrowany");
            }
            if (this.commandHandler != null) {
                this.commandHandler.unregisterCommands();
                this.logger.debug("Komendy wyrejestrowane");
            }
            this.waitForPendingOperations();
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.logger.debug("ConnectionManager zamkni\u0119ty");
            }
            if (this.authCache != null) {
                this.authCache.shutdown();
                this.logger.debug("AuthCache zamkni\u0119ty");
            }
            if (this.databaseManager != null) {
                this.databaseManager.shutdown();
                this.logger.debug("DatabaseManager zamkni\u0119ty");
            }
            VirtualThreadExecutorProvider.shutdown();
            this.logger.debug("VirtualThreadExecutorProvider zamkni\u0119ty");
            this.logger.info("VeloAuth shutdown completed successfully");
        }
        catch (IllegalStateException e) {
            this.logger.error("B\u0142\u0105d stanu podczas graceful shutdown", e);
        }
    }

    private void logStartupInfo() {
        this.logger.info(this.messages.get("config.display.header", new Object[0]));
        this.logger.info(this.messages.get("config.display.database", new Object[0]), (Object)this.settings.getDatabaseStorageType(), (Object)(this.databaseManager.isConnected() ? this.messages.get("database.connected", new Object[0]) : this.messages.get("database.disconnected", new Object[0])));
        this.logger.info(this.messages.get("config.display.cache_ttl", new Object[0]), (Object)this.settings.getCacheTtlMinutes());
        this.logger.info(this.messages.get("config.display.cache_max_size", new Object[0]), (Object)this.settings.getCacheMaxSize());
        this.logger.info(this.messages.get("config.display.brute_force", new Object[0]), (Object)this.settings.getBruteForceMaxAttempts(), (Object)this.settings.getBruteForceTimeoutMinutes());
        this.logger.info(this.messages.get("config.display.picolimbo_server", new Object[0]), (Object)this.settings.getPicoLimboServerName());
        this.logger.info(this.messages.get("config.display.bcrypt_cost", new Object[0]), (Object)this.settings.getBcryptCost());
        this.logger.info(this.messages.get("config.display.premium_check", new Object[0]), (Object)(this.settings.isPremiumCheckEnabled() ? this.messages.get("premium.check_enabled", new Object[0]) : this.messages.get("premium.check_disabled", new Object[0])));
        AuthCache.CacheStats stats = this.authCache.getStats();
        this.logger.info(this.messages.get("config.display.cache_stats", new Object[0]), stats.authorizedPlayersCount(), stats.bruteForceEntriesCount(), stats.premiumCacheCount());
    }

    public boolean reloadConfig() {
        try {
            this.logger.info(this.messages.get("config.reloading", new Object[0]));
            if (this.settings.load()) {
                this.logger.info(this.messages.get("config.reloaded_success", new Object[0]));
                this.logStartupInfo();
                return true;
            }
            this.logger.error(this.messages.get("config.reload_failed", new Object[0]));
            return false;
        }
        catch (IllegalStateException e) {
            this.logger.error("B\u0142\u0105d stanu podczas prze\u0142adowywania konfiguracji", e);
            return false;
        }
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AuthCache getAuthCache() {
        return this.authCache;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getVersion() {
        return "1.0.0";
    }
}

