/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.CommandHelper;
import net.rafalohaki.veloauth.command.IPRateLimiter;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.libs.bcrypt.bcrypt.BCrypt;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandHandler {
    private static final Marker AUTH_MARKER = MarkerFactory.getMarker("AUTH");
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");
    private static final Marker DB_MARKER = MarkerFactory.getMarker("DATABASE");
    private final VeloAuth plugin;
    private final DatabaseManager databaseManager;
    private final AuthCache authCache;
    private final Settings settings;
    private final Messages messages;
    private final Logger logger;
    private final IPRateLimiter ipRateLimiter;

    public CommandHandler(VeloAuth plugin, DatabaseManager databaseManager, AuthCache authCache, Settings settings, Messages messages) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.authCache = authCache;
        this.settings = settings;
        this.messages = messages;
        this.logger = plugin.getLogger();
        this.ipRateLimiter = new IPRateLimiter(10, 5);
    }

    public void registerCommands() {
        CommandManager commandManager = this.plugin.getServer().getCommandManager();
        commandManager.register(commandManager.metaBuilder("login").aliases(new String[]{"log", "l"}).build(), (Command)new LoginCommand());
        commandManager.register(commandManager.metaBuilder("register").aliases(new String[]{"reg", "r"}).build(), (Command)new RegisterCommand());
        commandManager.register(commandManager.metaBuilder("changepassword").build(), (Command)new ChangePasswordCommand());
        commandManager.register(commandManager.metaBuilder("unregister").build(), (Command)new UnregisterCommand());
        commandManager.register(commandManager.metaBuilder("vauth").build(), (Command)new VAuthCommand());
        this.logger.info(this.messages.get("connection.commands.registered", new Object[0]));
    }

    public void unregisterCommands() {
        CommandManager commandManager = this.plugin.getServer().getCommandManager();
        commandManager.unregister("login");
        commandManager.unregister("register");
        commandManager.unregister("changepassword");
        commandManager.unregister("unregister");
        commandManager.unregister("vauth");
        this.logger.info("Komendy wyrejestrowane");
    }

    private AuthenticationContext validateAndAuthenticatePlayer(CommandSource source, String[] args, String commandName) {
        Player player = CommandHelper.validatePlayerSource(source, this.messages);
        if (player == null) {
            return null;
        }
        InetAddress playerAddress = ValidationUtils.getPlayerAddress(player);
        if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
            player.sendMessage(ValidationUtils.createErrorComponent(this.messages.get("security.brute_force.blocked", new Object[0])));
            this.logger.warn(SECURITY_MARKER, "[BRUTE FORCE BLOCK] IP {} attempted {}", (Object)playerAddress.getHostAddress(), (Object)commandName);
            return null;
        }
        String username = player.getUsername();
        DatabaseManager.DbResult<RegisteredPlayer> dbResult = this.databaseManager.findPlayerByNickname(username).join();
        if (this.handleDatabaseError(dbResult, player, commandName + " lookup for")) {
            return null;
        }
        RegisteredPlayer registeredPlayer = dbResult.getValue();
        return new AuthenticationContext(player, username, playerAddress, registeredPlayer);
    }

    private DatabaseManager.DbResult<Boolean> checkPremiumStatus(Player player, String operation) {
        DatabaseManager.DbResult<Boolean> premiumResult = this.databaseManager.isPremium(player.getUsername()).join();
        if (premiumResult.isDatabaseError()) {
            this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} failed for {}: {}", operation, player.getUsername(), premiumResult.getErrorMessage());
            player.sendMessage(ValidationUtils.createErrorComponent(this.messages.get("error.database.query", new Object[0])));
        }
        return premiumResult;
    }

    private boolean handleDatabaseError(DatabaseManager.DbResult<?> result, Player player, String operation) {
        if (result.isDatabaseError()) {
            this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} failed for {}: {}", operation, player.getUsername(), result.getErrorMessage());
            player.sendMessage(ValidationUtils.createErrorComponent(this.messages.get("error.database.query", new Object[0])));
            return true;
        }
        return false;
    }

    private class LoginCommand
    implements SimpleCommand {
        private LoginCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (args.length != 1) {
                CommandHelper.sendError(source, CommandHandler.this.messages, "auth.login.usage");
                return;
            }
            String password = args[0];
            CommandHelper.runAsyncCommand(() -> this.processLogin(source, password), CommandHandler.this.messages, source, "error.database.query");
        }

        private void processLogin(CommandSource source, String password) {
            Player player = (Player)source;
            AuthenticationContext authContext = CommandHandler.this.validateAndAuthenticatePlayer(source, new String[]{password}, "login");
            if (authContext == null) {
                return;
            }
            if (CommandHandler.this.authCache.isPlayerAuthorized(player.getUniqueId(), ValidationUtils.getPlayerIp(player))) {
                player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.login.already_logged_in", new Object[0])));
                return;
            }
            BCrypt.Result result = BCrypt.verifyer().verify(password.toCharArray(), authContext.registeredPlayer.getHash());
            if (result.verified) {
                this.handleSuccessfulLogin(authContext);
            } else {
                this.handleFailedLogin(authContext);
            }
        }

        private void handleSuccessfulLogin(AuthenticationContext authContext) {
            try {
                authContext.registeredPlayer.updateLoginData(ValidationUtils.getPlayerIp(authContext.player));
                DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(authContext.registeredPlayer).join();
                if (CommandHandler.this.handleDatabaseError(saveResult, authContext.player, "Failed to save login data for")) {
                    return;
                }
                DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(authContext.player, "Premium status check during login");
                if (premiumResult.isDatabaseError()) {
                    return;
                }
                boolean isPremium = premiumResult.getValue();
                CachedAuthUser cachedUser = CachedAuthUser.fromRegisteredPlayer(authContext.registeredPlayer, isPremium);
                CommandHandler.this.authCache.addAuthorizedPlayer(authContext.player.getUniqueId(), cachedUser);
                CommandHandler.this.authCache.startSession(authContext.player.getUniqueId(), authContext.username, ValidationUtils.getPlayerIp(authContext.player));
                this.resetSecurityCounters(authContext.playerAddress);
                authContext.player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.login.success", new Object[0])));
                CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zalogowa\u0142 si\u0119 pomy\u015blnie z IP {} - sesja rozpocz\u0119ta", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
                CommandHandler.this.plugin.getConnectionManager().transferToBackend(authContext.player);
            }
            catch (Exception e) {
                CommandHandler.this.logger.error("B\u0142\u0105d podczas przetwarzania udanego logowania: {}", (Object)authContext.username, (Object)e);
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("error.database.query", new Object[0])));
            }
        }

        private void handleFailedLogin(AuthenticationContext authContext) {
            boolean blocked = false;
            if (authContext.playerAddress != null) {
                blocked = CommandHandler.this.authCache.registerFailedLogin(authContext.playerAddress);
            }
            if (blocked) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("security.brute_force.blocked", new Object[0])));
                CommandHandler.this.logger.warn("Gracz {} zablokowany za brute force z IP {}", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
            } else {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.login.incorrect_password", new Object[0])));
                CommandHandler.this.logger.debug("Nieudana pr\u00f3ba logowania gracza {} z IP {}", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
            }
        }

        private void resetSecurityCounters(InetAddress playerAddress) {
            if (playerAddress != null) {
                CommandHandler.this.authCache.resetLoginAttempts(playerAddress);
                CommandHandler.this.ipRateLimiter.reset(playerAddress);
            }
        }
    }

    private class RegisterCommand
    implements SimpleCommand {
        private RegisterCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            Player player = CommandHelper.validatePlayerSource(source, CommandHandler.this.messages);
            if (player == null) {
                return;
            }
            ValidationUtils.ValidationResult validationResult = ValidationUtils.validateArgumentCount(args, 2, CommandHandler.this.messages.get("auth.register.usage", new Object[0]));
            if (!validationResult.valid()) {
                player.sendMessage(ValidationUtils.createWarningComponent(validationResult.getErrorMessage()));
                return;
            }
            String password = args[0];
            String confirmPassword = args[1];
            ValidationUtils.ValidationResult passwordValidation = ValidationUtils.validatePassword(password, CommandHandler.this.settings);
            if (!passwordValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(passwordValidation.getErrorMessage()));
                return;
            }
            ValidationUtils.ValidationResult matchValidation = ValidationUtils.validatePasswordMatch(password, confirmPassword);
            if (!matchValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(matchValidation.getErrorMessage()));
                return;
            }
            CommandHelper.runAsyncCommandWithTimeout(() -> this.processRegistration(player, password), CommandHandler.this.messages, source, "error.database.query", "auth.registration.timeout");
        }

        private void processRegistration(Player player, String password) {
            AuthenticationContext authContext = CommandHandler.this.validateAndAuthenticatePlayer((CommandSource)player, new String[]{password}, "registration");
            if (authContext == null) {
                return;
            }
            if (authContext.registeredPlayer != null) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.register.already_registered", new Object[0])));
                return;
            }
            String hashedPassword = BCrypt.with(BCrypt.Version.VERSION_2Y).hashToString(CommandHandler.this.settings.getBcryptCost(), password.toCharArray());
            RegisteredPlayer newPlayer = new RegisteredPlayer(authContext.username, hashedPassword, ValidationUtils.getPlayerIp(authContext.player), authContext.player.getUniqueId().toString());
            DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(newPlayer).join();
            if (CommandHandler.this.handleDatabaseError(saveResult, authContext.player, "Failed to save new player")) {
                return;
            }
            boolean saved = saveResult.getValue();
            if (!saved) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("error.database.query", new Object[0])));
                return;
            }
            DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(authContext.player, "Premium status check during registration");
            if (premiumResult.isDatabaseError()) {
                return;
            }
            boolean isPremium = premiumResult.getValue();
            CachedAuthUser cachedUser = CachedAuthUser.fromRegisteredPlayer(newPlayer, isPremium);
            CommandHandler.this.authCache.addAuthorizedPlayer(authContext.player.getUniqueId(), cachedUser);
            CommandHandler.this.authCache.startSession(authContext.player.getUniqueId(), authContext.username, ValidationUtils.getPlayerIp(authContext.player));
            this.resetSecurityCounters(authContext.playerAddress);
            authContext.player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.register.success", new Object[0])));
            CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zarejestrowany pomy\u015blnie z IP {}", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
            CommandHandler.this.plugin.getConnectionManager().transferToBackend(authContext.player);
        }

        private void resetSecurityCounters(InetAddress playerAddress) {
            if (playerAddress != null) {
                CommandHandler.this.authCache.resetLoginAttempts(playerAddress);
                CommandHandler.this.ipRateLimiter.reset(playerAddress);
            }
        }
    }

    private class ChangePasswordCommand
    implements SimpleCommand {
        private ChangePasswordCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            Player player = CommandHelper.validatePlayerSource(source, CommandHandler.this.messages);
            if (player == null) {
                return;
            }
            ValidationUtils.ValidationResult validationResult = ValidationUtils.validateArgumentCount(args, 2, CommandHandler.this.messages.get("auth.changepassword.usage", new Object[0]));
            if (!validationResult.valid()) {
                player.sendMessage(ValidationUtils.createWarningComponent(validationResult.getErrorMessage()));
                return;
            }
            String oldPassword = args[0];
            String newPassword = args[1];
            ValidationUtils.ValidationResult passwordValidation = ValidationUtils.validatePassword(newPassword, CommandHandler.this.settings);
            if (!passwordValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(passwordValidation.getErrorMessage()));
                return;
            }
            CommandHelper.runAsyncCommand(() -> this.processPasswordChange(player, oldPassword, newPassword), CommandHandler.this.messages, source, "error.database.query");
        }

        private void processPasswordChange(Player player, String oldPassword, String newPassword) {
            AuthenticationContext authContext = CommandHandler.this.validateAndAuthenticatePlayer((CommandSource)player, new String[]{oldPassword, newPassword}, "password change");
            if (authContext == null) {
                return;
            }
            if (authContext.registeredPlayer == null) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.login.not_registered", new Object[0])));
                return;
            }
            BCrypt.Result result = BCrypt.verifyer().verify(oldPassword.toCharArray(), authContext.registeredPlayer.getHash());
            if (!result.verified) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.changepassword.incorrect_old_password", new Object[0])));
                return;
            }
            String newHashedPassword = BCrypt.with(BCrypt.Version.VERSION_2Y).hashToString(CommandHandler.this.settings.getBcryptCost(), newPassword.toCharArray());
            authContext.registeredPlayer.setHash(newHashedPassword);
            DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(authContext.registeredPlayer).join();
            if (CommandHandler.this.handleDatabaseError(saveResult, authContext.player, "Password change save failed for")) {
                return;
            }
            boolean saved = saveResult.getValue();
            if (!saved) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("error.database.query", new Object[0])));
                return;
            }
            DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(authContext.player, "Premium check during password change");
            if (!premiumResult.isDatabaseError() && premiumResult.getValue().booleanValue()) {
                CommandHandler.this.authCache.removePremiumPlayer(authContext.username);
            }
            CommandHandler.this.authCache.endSession(authContext.player.getUniqueId());
            CommandHandler.this.plugin.getServer().getAllPlayers().stream().filter(p -> !p.equals((Object)authContext.player)).filter(p -> p.getUsername().equalsIgnoreCase(authContext.username)).forEach(p -> {
                p.disconnect(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("general.kick.message", new Object[0])));
                CommandHandler.this.logger.warn("Roz\u0142\u0105czono duplikat gracza {} - zmiana has\u0142a z IP {}", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
            });
            authContext.player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.changepassword.success", new Object[0])));
            CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zmieni\u0142 has\u0142o z IP {}", (Object)authContext.username, (Object)ValidationUtils.getPlayerIp(authContext.player));
        }
    }

    private class UnregisterCommand
    implements SimpleCommand {
        private UnregisterCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (!CommandHelper.checkAdminPermission(source, CommandHandler.this.messages)) {
                return;
            }
            if (args.length != 1) {
                CommandHelper.sendError(source, CommandHandler.this.messages, "admin.unregister.usage");
                return;
            }
            String nickname = args[0];
            CommandHelper.runAsyncCommand(() -> this.processAdminUnregistration(source, nickname), CommandHandler.this.messages, source, "error.database.query");
        }

        private void processAdminUnregistration(CommandSource source, String nickname) {
            try {
                DatabaseManager.DbResult<RegisteredPlayer> dbResult = CommandHandler.this.databaseManager.findPlayerByNickname(nickname).join();
                if (this.handleDatabaseError(dbResult, source, nickname, "Admin unregistration failed for")) {
                    return;
                }
                RegisteredPlayer registeredPlayer = dbResult.getValue();
                if (registeredPlayer == null) {
                    source.sendMessage(ValidationUtils.createErrorComponent("Gracz " + nickname + " nie zosta\u0142 znaleziony w bazie danych!"));
                    return;
                }
                UUID playerUuid = this.parsePlayerUuid(registeredPlayer, nickname, source);
                if (playerUuid == null) {
                    return;
                }
                DatabaseManager.DbResult<Boolean> deleteResult = CommandHandler.this.databaseManager.deletePlayer(nickname).join();
                if (this.handleDatabaseError(deleteResult, source, nickname, "Admin unregistration delete failed for")) {
                    return;
                }
                boolean deleted = deleteResult.getValue();
                if (deleted) {
                    CommandHandler.this.authCache.removeAuthorizedPlayer(playerUuid);
                    CommandHandler.this.authCache.endSession(playerUuid);
                    CommandHandler.this.authCache.removePremiumPlayer(nickname);
                    CommandHandler.this.plugin.getServer().getPlayer(nickname).ifPresent(player -> {
                        player.disconnect(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("general.kick.message", new Object[0])));
                        CommandHandler.this.logger.info("Roz\u0142\u0105czono gracza {} - usuni\u0119cie konta przez admina", (Object)nickname);
                    });
                    CommandHelper.sendSuccess(source, "Konto gracza " + nickname + " zosta\u0142o usuni\u0119te!");
                    CommandHandler.this.logger.info(AUTH_MARKER, "Administrator {} usun\u0105\u0142 konto gracza {}", (Object)(source instanceof Player ? ((Player)source).getUsername() : "CONSOLE"), (Object)nickname);
                } else {
                    CommandHelper.sendError(source, CommandHandler.this.messages, "error.database.query");
                    CommandHandler.this.logger.error(DB_MARKER, "Nie uda\u0142o si\u0119 usun\u0105\u0107 konta gracza {} przez admina", (Object)nickname);
                }
            }
            catch (Exception e) {
                CommandHandler.this.logger.error(DB_MARKER, "B\u0142\u0105d podczas admin-usuwania konta gracza: {}", (Object)nickname, (Object)e);
                CommandHelper.sendError(source, CommandHandler.this.messages, "error.database.query");
            }
        }

        private boolean handleDatabaseError(DatabaseManager.DbResult<?> result, CommandSource source, String nickname, String operation) {
            if (result.isDatabaseError()) {
                CommandHandler.this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} {}: {}", operation, nickname, result.getErrorMessage());
                CommandHelper.sendError(source, CommandHandler.this.messages, "error.database.query");
                return true;
            }
            return false;
        }

        private UUID parsePlayerUuid(RegisteredPlayer registeredPlayer, String nickname, CommandSource source) {
            try {
                return UUID.fromString(registeredPlayer.getUuid());
            }
            catch (IllegalArgumentException e) {
                CommandHandler.this.logger.warn("Nieprawid\u0142owy UUID dla gracza {}: {}", (Object)nickname, (Object)registeredPlayer.getUuid());
                source.sendMessage(ValidationUtils.createErrorComponent("B\u0142\u0105d: nieprawid\u0142owy UUID gracza!"));
                return null;
            }
        }
    }

    private class VAuthCommand
    implements SimpleCommand {
        private VAuthCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            String subcommand;
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (!CommandHelper.checkAdminPermission(source, CommandHandler.this.messages)) {
                return;
            }
            if (args.length == 0) {
                this.sendAdminHelp(source);
                return;
            }
            switch (subcommand = args[0].toLowerCase()) {
                case "reload": {
                    boolean success = CommandHandler.this.plugin.reloadConfig();
                    if (success) {
                        source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.reload.success", new Object[0])));
                        break;
                    }
                    source.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("admin.reload.failed", new Object[0])));
                    break;
                }
                case "cache-reset": {
                    if (args.length == 2) {
                        String nickname = args[1];
                        CommandHandler.this.plugin.getServer().getPlayer(nickname).ifPresentOrElse(player -> {
                            CommandHandler.this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                            source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.cache_reset.player", nickname, new Object[0])));
                        }, () -> source.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("admin.cache_reset.player_not_found", nickname, new Object[0]))));
                        break;
                    }
                    CommandHandler.this.authCache.clearAll();
                    source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.cache_reset.success", new Object[0])));
                    break;
                }
                case "stats": {
                    AuthCache.CacheStats stats = CommandHandler.this.authCache.getStats();
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.header", new Object[0]));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.registered_accounts", stats.authorizedPlayersCount()));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.cache_size", stats.bruteForceEntriesCount()));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.cache_size", stats.premiumCacheCount()));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.cache_size", CommandHandler.this.databaseManager.getCacheSize()));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.database_status", String.format("%.1f%%", stats.getHitRate()), new Object[0]));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.registered_accounts", stats.getTotalRequests()));
                    CommandHelper.sendWarning(source, CommandHandler.this.messages.get("admin.stats.database_status", CommandHandler.this.databaseManager.isConnected() ? CommandHandler.this.messages.get("database.connected", new Object[0]) : CommandHandler.this.messages.get("database.disconnected", new Object[0]), new Object[0]));
                    break;
                }
                default: {
                    this.sendAdminHelp(source);
                }
            }
        }

        private void sendAdminHelp(CommandSource source) {
            CommandHelper.sendWarning(source, "=== VeloAuth Admin ===");
            CommandHelper.sendWarning(source, "/vauth reload - Reload configuration");
            CommandHelper.sendWarning(source, "/vauth cache-reset [player] - Clear cache");
            CommandHelper.sendWarning(source, "/vauth stats - Show statistics");
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            String[] args = (String[])invocation.arguments();
            if (args.length == 1) {
                return List.of("reload", "cache-reset", "stats");
            }
            return List.of();
        }
    }

    private static class AuthenticationContext {
        final Player player;
        final String username;
        final InetAddress playerAddress;
        final RegisteredPlayer registeredPlayer;

        AuthenticationContext(Player player, String username, InetAddress playerAddress, RegisteredPlayer registeredPlayer) {
            this.player = player;
            this.username = username;
            this.playerAddress = playerAddress;
            this.registeredPlayer = registeredPlayer;
        }
    }
}

