/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.util.VirtualThreadExecutorProvider;

public final class CommandHelper {
    private CommandHelper() {
    }

    public static Player validatePlayerSource(CommandSource source, Messages messages) {
        if (!(source instanceof Player)) {
            source.sendMessage(ValidationUtils.createErrorComponent(messages.get("error.player_only", new Object[0])));
            return null;
        }
        Player player = (Player)source;
        return player;
    }

    public static boolean checkAdminPermission(CommandSource source, Messages messages) {
        if (!source.hasPermission("veloauth.admin")) {
            source.sendMessage(ValidationUtils.createErrorComponent(messages.get("error.permission", new Object[0])));
            return false;
        }
        return true;
    }

    public static void sendError(CommandSource source, String message) {
        source.sendMessage(ValidationUtils.createErrorComponent(message));
    }

    public static void sendError(CommandSource source, Messages messages, String key) {
        source.sendMessage(ValidationUtils.createErrorComponent(messages.get(key, new Object[0])));
    }

    public static void sendSuccess(CommandSource source, String message) {
        source.sendMessage(ValidationUtils.createSuccessComponent(message));
    }

    public static void sendSuccess(CommandSource source, Messages messages, String key) {
        source.sendMessage(ValidationUtils.createSuccessComponent(messages.get(key, new Object[0])));
    }

    public static void sendWarning(CommandSource source, String message) {
        source.sendMessage(ValidationUtils.createWarningComponent(message));
    }

    public static void runAsyncCommand(Runnable task, Messages messages, CommandSource source, String errorKey) {
        CompletableFuture.runAsync(task, VirtualThreadExecutorProvider.getVirtualExecutor()).exceptionally(throwable -> {
            source.sendMessage(ValidationUtils.createErrorComponent(messages.get(errorKey, new Object[0])));
            return null;
        });
    }

    public static void runAsyncCommandWithTimeout(Runnable task, Messages messages, CommandSource source, String errorKey, String timeoutKey) {
        CompletableFuture.runAsync(task, VirtualThreadExecutorProvider.getVirtualExecutor()).orTimeout(30L, TimeUnit.SECONDS).exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                source.sendMessage(ValidationUtils.createErrorComponent(messages.get(timeoutKey, new Object[0])));
            } else {
                source.sendMessage(ValidationUtils.createErrorComponent(messages.get(errorKey, new Object[0])));
            }
            return null;
        });
    }
}

