/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.config.Settings;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static ValidationResult validatePassword(String password, Settings settings) {
        if (password == null || password.isEmpty()) {
            return ValidationResult.error("Has\u0142o nie mo\u017ce by\u0107 puste!");
        }
        if (password.length() < settings.getMinPasswordLength()) {
            return ValidationResult.error("Has\u0142o jest za kr\u00f3tkie! Minimum " + settings.getMinPasswordLength() + " znak\u00f3w.");
        }
        if (password.length() > settings.getMaxPasswordLength()) {
            return ValidationResult.error("Has\u0142o jest za d\u0142ugie! Maksimum " + settings.getMaxPasswordLength() + " znak\u00f3w.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validatePasswordMatch(String password, String confirmPassword) {
        if (!password.equals(confirmPassword)) {
            return ValidationResult.error("Has\u0142a nie s\u0105 identyczne!");
        }
        return ValidationResult.success();
    }

    public static String getPlayerIp(Player player) {
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress().getHostAddress();
        }
        return "unknown";
    }

    public static InetAddress getPlayerAddress(Player player) {
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress();
        }
        return null;
    }

    public static ValidationResult validatePlayerSource(CommandSource source) {
        if (!(source instanceof Player)) {
            return ValidationResult.error("Ta komenda jest tylko dla graczy!");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateArgumentCount(String[] args, int expectedCount, String usage) {
        if (args.length != expectedCount) {
            return ValidationResult.error(usage);
        }
        return ValidationResult.success();
    }

    public static Component createErrorComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.RED);
    }

    public static Component createSuccessComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.GREEN);
    }

    public static Component createWarningComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.YELLOW);
    }

    public record ValidationResult(boolean valid, String message) {
        public static ValidationResult success() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult error(String message) {
            return new ValidationResult(false, message);
        }

        public String getErrorMessage() {
            return this.message;
        }
    }
}

