/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.connection;

import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConnectionManager {
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");
    private final VeloAuth plugin;
    private final DatabaseManager databaseManager;
    private final AuthCache authCache;
    private final Settings settings;
    private final Logger logger;
    private final Messages messages;

    public ConnectionManager(VeloAuth plugin, DatabaseManager databaseManager, AuthCache authCache, Settings settings, Messages messages) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.authCache = authCache;
        this.settings = settings;
        this.logger = plugin.getLogger();
        this.messages = messages;
        this.logger.info(messages.get("connection.manager.initialized", new Object[0]), (Object)settings.getPicoLimboServerName());
    }

    public CompletableFuture<Boolean> handlePlayerConnection(Player player) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!this.plugin.isInitialized()) {
                    this.logger.warn("\ud83d\udd12 BLOKADA STARTU: Gracz {} pr\u00f3bowa\u0142 po\u0142\u0105czy\u0107 si\u0119 przed pe\u0142n\u0105 inicjalizacj\u0105 VeloAuth - roz\u0142\u0105czanie", (Object)player.getUsername());
                    player.disconnect((Component)Component.text((String)"VeloAuth si\u0119 uruchamia. Spr\u00f3buj po\u0142\u0105czy\u0107 si\u0119 ponownie za chwil\u0119.", (TextColor)NamedTextColor.RED));
                    return false;
                }
                String playerIp = this.getPlayerIp(player);
                InetAddress playerAddress = this.getPlayerAddress(player);
                this.logger.debug("Obs\u0142uga po\u0142\u0105czenia gracza {} z IP {}", (Object)player.getUsername(), (Object)playerIp);
                if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
                    this.logger.warn("Gracz {} zablokowany za brute force z IP {}", (Object)player.getUsername(), (Object)playerIp);
                    player.disconnect((Component)Component.text((String)"Zbyt wiele nieudanych pr\u00f3b logowania. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED));
                    return false;
                }
                CachedAuthUser cachedUser = this.authCache.getAuthorizedPlayer(player.getUniqueId());
                if (cachedUser != null && cachedUser.matchesIp(playerIp)) {
                    this.logger.debug("Cache HIT dla gracza {} - transfer na backend", (Object)player.getUsername());
                    return this.verifyAndTransferToBackend(player, cachedUser);
                }
                this.logger.debug("Cache MISS dla gracza {} - transfer na PicoLimbo", (Object)player.getUsername());
                return this.transferToPicoLimbo(player);
            }
            catch (Exception e) {
                this.logger.error("B\u0142\u0105d podczas obs\u0142ugi po\u0142\u0105czenia gracza: {}", (Object)player.getUsername(), (Object)e);
                player.disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
                return false;
            }
        });
    }

    private boolean verifyAndTransferToBackend(Player player, CachedAuthUser cachedUser) {
        try {
            DatabaseManager.DbResult<RegisteredPlayer> dbResult = this.databaseManager.findPlayerByNickname(player.getUsername()).join();
            if (dbResult.isDatabaseError()) {
                this.logger.error("Database error during player verification for {}: {}", (Object)player.getUsername(), (Object)dbResult.getErrorMessage());
                this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                this.authCache.endSession(player.getUniqueId());
                player.disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d weryfikacji bazy danych. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED));
                return false;
            }
            RegisteredPlayer dbPlayer = dbResult.getValue();
            if (dbPlayer == null) {
                this.logger.warn("Gracz {} w cache ale nie w bazie danych - usuwam z cache", (Object)player.getUsername());
                this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                this.authCache.endSession(player.getUniqueId());
                return this.transferToPicoLimbo(player);
            }
            UUID playerUuid = player.getUniqueId();
            UUID storedUuid = dbPlayer.getUuidAsUUID();
            if (storedUuid != null && !playerUuid.equals(storedUuid)) {
                this.logger.error(SECURITY_MARKER, "[UUID MISMATCH DETECTED] Gracz {} ma UUID {} ale baza zawiera {} (IP: {})", player.getUsername(), playerUuid, storedUuid, this.getPlayerIp(player));
                this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                this.authCache.endSession(player.getUniqueId());
                player.disconnect((Component)Component.text((String)"UUID nie zgadza si\u0119 z kontem! Potencjalny atak spoofing.", (TextColor)NamedTextColor.RED));
                return false;
            }
            String currentIp = this.getPlayerIp(player);
            if (!currentIp.equals(dbPlayer.getLoginIp())) {
                dbPlayer.updateLoginData(currentIp);
                ((CompletableFuture)this.databaseManager.savePlayer(dbPlayer).thenAccept(result -> {
                    CachedAuthUser updatedUser = cachedUser.withUpdatedIp(currentIp);
                    this.authCache.addAuthorizedPlayer(player.getUniqueId(), updatedUser);
                    this.logger.debug("Zaktualizowano IP gracza {} w bazie danych i cache: {}", (Object)player.getUsername(), (Object)currentIp);
                })).exceptionally(throwable -> {
                    this.logger.error("B\u0142\u0105d podczas zapisu danych gracza {} do bazy danych - cache nie zaktualizowany", (Object)player.getUsername(), throwable);
                    return null;
                });
            }
            return this.transferToBackend(player);
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas weryfikacji gracza: {}", (Object)player.getUsername(), (Object)e);
            return this.transferToPicoLimbo(player);
        }
    }

    public boolean transferToPicoLimbo(Player player) {
        try {
            Optional picoLimboServer = this.plugin.getServer().getServer(this.settings.getPicoLimboServerName());
            if (picoLimboServer.isEmpty()) {
                this.logger.error("Serwer PicoLimbo '{}' nie jest zarejestrowany!", (Object)this.settings.getPicoLimboServerName());
                player.disconnect((Component)Component.text((String)"Serwer autoryzacji jest niedost\u0119pny. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED));
                return false;
            }
            RegisteredServer targetServer = (RegisteredServer)picoLimboServer.get();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.messages.get("player.transfer.attempt", new Object[0]), (Object)player.getUsername());
            }
            CompletionStage messageFuture = ((CompletableFuture)this.databaseManager.findPlayerByNickname(player.getUsername()).thenAccept(dbResult -> {
                if (dbResult.isDatabaseError()) {
                    this.logger.warn("Database error while checking account for {}: {}", (Object)player.getUsername(), (Object)dbResult.getErrorMessage());
                    this.sendGenericAuthMessage(player);
                    return;
                }
                RegisteredPlayer existingPlayer = (RegisteredPlayer)dbResult.getValue();
                if (existingPlayer != null) {
                    this.sendLoginMessage(player);
                    this.logger.debug("Wykryto istniej\u0105ce konto dla {} - pokazano komunikat logowania", (Object)player.getUsername());
                } else {
                    this.sendRegisterMessage(player);
                    this.logger.debug("Wykryto nowe konto dla {} - pokazano komunikat rejestracji", (Object)player.getUsername());
                }
            })).exceptionally(throwable -> {
                this.logger.warn("B\u0142\u0105d podczas sprawdzania konta dla {}: {}", (Object)player.getUsername(), (Object)throwable.getMessage());
                this.sendGenericAuthMessage(player);
                return null;
            });
            ((CompletableFuture)((CompletableFuture)messageFuture).orTimeout(10L, TimeUnit.SECONDS).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.logger.error("Krytyczny b\u0142\u0105d w operacji wiadomo\u015bci dla {}: {}", player.getUsername(), throwable.getMessage(), throwable);
                }
            })).join();
            return this.executePicoLimboTransfer(player, targetServer);
        }
        catch (Exception e) {
            this.logger.error("Krytyczny b\u0142\u0105d podczas pr\u00f3by transferu gracza na PicoLimbo: {}", (Object)player.getUsername(), (Object)e);
            this.disconnectWithError(player, "Wyst\u0105pi\u0142 krytyczny b\u0142\u0105d podczas \u0142\u0105czenia z serwerem autoryzacji.");
            return false;
        }
    }

    private boolean executePicoLimboTransfer(Player player, RegisteredServer targetServer) {
        try {
            ConnectionRequestBuilder.Result result = (ConnectionRequestBuilder.Result)player.createConnectionRequest(targetServer).connect().join();
            if (result.isSuccessful()) {
                this.logger.info(this.messages.get("player.transfer.success", new Object[0]), (Object)player.getUsername());
                return true;
            }
            this.logger.warn("\u274c Transfer {} na PicoLimbo FAILED: {}", (Object)player.getUsername(), (Object)result.getReasonComponent().orElse(this.createUnknownErrorComponent()));
            player.sendMessage((Component)Component.text((String)"Nie uda\u0142o si\u0119 po\u0142\u0105czy\u0107 z serwerem autoryzacji. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
            return false;
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas transferu gracza {} na PicoLimbo: {}", player.getUsername(), e.getMessage(), e);
            player.sendMessage((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia z serwerem autoryzacji.", (TextColor)NamedTextColor.RED));
            return false;
        }
    }

    public boolean transferToBackend(Player player) {
        Optional<RegisteredServer> backendServer = this.findAvailableBackendServer();
        if (backendServer.isEmpty()) {
            this.logger.error("Brak dost\u0119pnych serwer\u00f3w backend!");
            player.sendMessage((Component)Component.text((String)"Brak dost\u0119pnych serwer\u00f3w gry. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED));
            return false;
        }
        RegisteredServer targetServer = backendServer.get();
        String serverName = targetServer.getServerInfo().getName();
        player.sendMessage((Component)Component.text((String)"\u0141\u0105czenie z serwerem gry...", (TextColor)NamedTextColor.YELLOW));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.messages.get("player.transfer.backend.attempt", new Object[0]), (Object)player.getUsername(), (Object)serverName);
        }
        try {
            boolean transferSuccess = ((ConnectionRequestBuilder.Result)player.createConnectionRequest(targetServer).connect().join()).isSuccessful();
            if (transferSuccess) {
                this.logger.info(this.messages.get("player.transfer.backend.success", new Object[0]), (Object)player.getUsername(), (Object)serverName);
                return true;
            }
            this.logger.warn("Nie uda\u0142o si\u0119 przenie\u015b\u0107 gracza {} na serwer {}", (Object)player.getUsername(), (Object)serverName);
            player.sendMessage((Component)Component.text((String)"Nie uda\u0142o si\u0119 po\u0142\u0105czy\u0107 z serwerem gry. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
            return false;
        }
        catch (Exception e) {
            try {
                this.logger.error("B\u0142\u0105d podczas transferu gracza {} na serwer {}: {}", player.getUsername(), serverName, e.getMessage(), e);
                player.sendMessage((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia z serwerem gry.", (TextColor)NamedTextColor.RED));
                return false;
            }
            catch (Exception e2) {
                this.logger.error("Krytyczny b\u0142\u0105d podczas transferu gracza {}: {}", player.getUsername(), e2.getMessage(), e2);
                player.sendMessage((Component)Component.text((String)"Wyst\u0105pi\u0142 krytyczny b\u0142\u0105d podczas transferu.", (TextColor)NamedTextColor.RED));
                return false;
            }
        }
    }

    private Optional<RegisteredServer> findAvailableBackendServer() {
        String picoLimboName = this.settings.getPicoLimboServerName();
        return this.plugin.getServer().getAllServers().stream().filter(server -> !server.getServerInfo().getName().equals(picoLimboName)).filter(server -> {
            try {
                return server.ping().join() != null;
            }
            catch (Exception e) {
                this.logger.debug("Serwer {} niedost\u0119pny: {}", (Object)server.getServerInfo().getName(), (Object)e.getMessage());
                return false;
            }
        }).findFirst();
    }

    public boolean isPlayerOnPicoLimbo(Player player) {
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).map(serverName -> serverName.equals(this.settings.getPicoLimboServerName())).orElse(false);
    }

    public boolean isPlayerOnBackend(Player player) {
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).map(serverName -> !serverName.equals(this.settings.getPicoLimboServerName())).orElse(false);
    }

    public void forceReauth(Player player) {
        try {
            this.authCache.removeAuthorizedPlayer(player.getUniqueId());
            this.transferToPicoLimbo(player);
            player.sendMessage((Component)Component.text((String)"Zosta\u0142e\u015b wylogowany. Zaloguj si\u0119 ponownie.", (TextColor)NamedTextColor.YELLOW));
            this.logger.info("Wymuszono ponown\u0105 autoryzacj\u0119 gracza: {}", (Object)player.getUsername());
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas wymuszania ponownej autoryzacji: {}", (Object)player.getUsername(), (Object)e);
        }
    }

    public void shutdown() {
        this.logger.info("ConnectionManager zamkni\u0119ty");
    }

    public void debugServers() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("connection.servers.available", new Object[0]));
        }
        this.plugin.getServer().getAllServers().forEach(server -> {
            String name = server.getServerInfo().getName();
            String address = server.getServerInfo().getAddress().toString();
            this.logger.info("  - {} ({})", (Object)name, (Object)address);
        });
        this.logger.info(this.messages.get("connection.picolimbo.server", new Object[0]), (Object)this.settings.getPicoLimboServerName());
        Optional picoLimbo = this.plugin.getServer().getServer(this.settings.getPicoLimboServerName());
        if (picoLimbo.isEmpty()) {
            this.logger.error(this.messages.get("connection.picolimbo.error", new Object[0]), (Object)this.settings.getPicoLimboServerName());
        } else {
            this.logger.info(this.messages.get("connection.picolimbo.found", new Object[0]), (Object)this.settings.getPicoLimboServerName(), (Object)((RegisteredServer)picoLimbo.get()).getServerInfo().getAddress());
        }
    }

    private String getPlayerIp(Player player) {
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress().getHostAddress();
        }
        return "unknown";
    }

    private InetAddress getPlayerAddress(Player player) {
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress();
        }
        return null;
    }

    private void sendLoginMessage(Player player) {
        player.sendMessage((Component)Component.text((String)"Twoje konto ju\u017c istnieje! U\u017cyj /login <has\u0142o>", (TextColor)NamedTextColor.GREEN));
    }

    private void sendRegisterMessage(Player player) {
        player.sendMessage((Component)Component.text((String)"Witaj po raz pierwszy! U\u017cyj /register <has\u0142o> <powt\u00f3rz>", (TextColor)NamedTextColor.AQUA));
    }

    private void sendGenericAuthMessage(Player player) {
        player.sendMessage((Component)Component.text((String)"Musisz si\u0119 zalogowa\u0107! U\u017cyj /login <has\u0142o> lub /register <has\u0142o> <powt\u00f3rz>", (TextColor)NamedTextColor.YELLOW));
    }

    private void disconnectWithError(Player player, String message) {
        player.disconnect((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
    }

    private Component createUnknownErrorComponent() {
        return Component.text((String)"Nieznany b\u0142\u0105d", (TextColor)NamedTextColor.RED);
    }
}

