/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.database;

public enum DatabaseType {
    MYSQL("MYSQL", "com.mysql.cj.jdbc.Driver", "mysql", 3306),
    POSTGRESQL("POSTGRESQL", "org.postgresql.Driver", "postgresql", 5432),
    H2("H2", "org.h2.Driver", "h2", 0),
    SQLITE("SQLITE", "org.sqlite.JDBC", "sqlite", 0);

    private final String name;
    private final String driverClass;
    private final String urlPrefix;
    private final int defaultPort;

    private DatabaseType(String name, String driverClass, String urlPrefix, int defaultPort) {
        this.name = name;
        this.driverClass = driverClass;
        this.urlPrefix = urlPrefix;
        this.defaultPort = defaultPort;
    }

    public static DatabaseType fromName(String name) {
        if (name == null) {
            return null;
        }
        try {
            return DatabaseType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DatabaseType fromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        if (url.startsWith("postgresql://")) {
            return POSTGRESQL;
        }
        if (url.startsWith("mysql://")) {
            return MYSQL;
        }
        if (url.startsWith("mariadb://")) {
            return MYSQL;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean isRemoteDatabase() {
        return this == MYSQL || this == POSTGRESQL;
    }

    public boolean isLocalDatabase() {
        return this == H2 || this == SQLITE;
    }
}

