/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import net.rafalohaki.veloauth.database.DatabaseConfig;
import net.rafalohaki.veloauth.database.DatabaseType;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcAuthDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuthDao.class);
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final String COMMA_SPACE_EQUALS_QUESTION = " = ?, ";
    private final DatabaseConfig config;
    private final boolean postgres;
    private final String authTable;
    private final String nicknameColumn;
    private final String lowercaseNicknameColumn;
    private final String hashColumn;
    private final String ipColumn;
    private final String loginIpColumn;
    private final String uuidColumn;
    private final String regDateColumn;
    private final String loginDateColumn;
    private final String selectPlayerSql;
    private final String insertPlayerSql;
    private final String updatePlayerSql;
    private final String deletePlayerSql;

    public JdbcAuthDao(DatabaseConfig config) {
        this.config = Objects.requireNonNull(config, "config nie mo\u017ce by\u0107 null");
        this.postgres = DatabaseType.POSTGRESQL.getName().equalsIgnoreCase(config.getStorageType());
        this.authTable = this.table("AUTH");
        this.nicknameColumn = this.column("NICKNAME");
        this.lowercaseNicknameColumn = this.column("LOWERCASENICKNAME");
        this.hashColumn = this.column("HASH");
        this.ipColumn = this.column("IP");
        this.loginIpColumn = this.column("LOGINIP");
        this.uuidColumn = this.column("UUID");
        this.regDateColumn = this.column("REGDATE");
        this.loginDateColumn = this.column("LOGINDATE");
        this.selectPlayerSql = "SELECT " + this.joinColumns(this.nicknameColumn, this.lowercaseNicknameColumn, this.hashColumn, this.ipColumn, this.loginIpColumn, this.uuidColumn, this.regDateColumn, this.loginDateColumn) + " FROM " + this.authTable + WHERE_CLAUSE + this.lowercaseNicknameColumn + " = ?";
        this.insertPlayerSql = "INSERT INTO " + this.authTable + " (" + this.joinColumns(this.lowercaseNicknameColumn, this.nicknameColumn, this.hashColumn, this.ipColumn, this.loginIpColumn, this.uuidColumn, this.regDateColumn, this.loginDateColumn) + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        this.updatePlayerSql = "UPDATE " + this.authTable + " SET " + this.nicknameColumn + COMMA_SPACE_EQUALS_QUESTION + this.hashColumn + COMMA_SPACE_EQUALS_QUESTION + this.ipColumn + COMMA_SPACE_EQUALS_QUESTION + this.loginIpColumn + COMMA_SPACE_EQUALS_QUESTION + this.uuidColumn + COMMA_SPACE_EQUALS_QUESTION + this.regDateColumn + COMMA_SPACE_EQUALS_QUESTION + this.loginDateColumn + " = ? WHERE " + this.lowercaseNicknameColumn + " = ?";
        this.deletePlayerSql = "DELETE FROM " + this.authTable + WHERE_CLAUSE + this.lowercaseNicknameColumn + " = ?";
    }

    /*
     * Exception decompiling
     */
    public RegisteredPlayer findPlayerByLowercaseNickname(String lowercaseNickname) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean upsertPlayer(RegisteredPlayer player) throws SQLException {
        Objects.requireNonNull(player, "player nie mo\u017ce by\u0107 null");
        try (Connection connection = this.openConnection();){
            boolean previousAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try {
                int updated = this.executeUpdate(connection, player);
                if (updated == 0) {
                    this.executeInsert(connection, player);
                }
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(previousAutoCommit);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public boolean deletePlayer(String lowercaseNickname) throws SQLException {
        try (Connection connection = this.openConnection();){
            boolean bl;
            block12: {
                PreparedStatement statement = connection.prepareStatement(this.deletePlayerSql);
                try {
                    statement.setString(1, lowercaseNickname);
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean healthCheck() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int executeUpdate(Connection connection, RegisteredPlayer player) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.updatePlayerSql);){
            this.bindUpdate(statement, player);
            int n = statement.executeUpdate();
            return n;
        }
    }

    private void executeInsert(Connection connection, RegisteredPlayer player) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.insertPlayerSql);){
            this.bindInsert(statement, player);
            statement.executeUpdate();
        }
    }

    private void bindInsert(PreparedStatement statement, RegisteredPlayer player) throws SQLException {
        statement.setString(1, player.getLowercaseNickname());
        statement.setString(2, player.getNickname());
        statement.setString(3, player.getHash());
        statement.setString(4, player.getIp());
        statement.setString(5, player.getLoginIp());
        statement.setString(6, player.getUuid());
        statement.setLong(7, player.getRegDate());
        statement.setLong(8, player.getLoginDate());
    }

    private void bindUpdate(PreparedStatement statement, RegisteredPlayer player) throws SQLException {
        statement.setString(1, player.getNickname());
        statement.setString(2, player.getHash());
        statement.setString(3, player.getIp());
        statement.setString(4, player.getLoginIp());
        statement.setString(5, player.getUuid());
        statement.setLong(6, player.getRegDate());
        statement.setLong(7, player.getLoginDate());
        statement.setString(8, player.getLowercaseNickname());
    }

    private RegisteredPlayer mapPlayer(ResultSet resultSet) throws SQLException {
        RegisteredPlayer player = new RegisteredPlayer();
        try {
            String nickname = resultSet.getString("NICKNAME");
            if (nickname != null && !nickname.isEmpty()) {
                player.setNickname(nickname);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Nieprawid\u0142owy nickname w bazie danych", e);
            throw new SQLException("Invalid nickname stored in database", e);
        }
        player.setHash(resultSet.getString("HASH"));
        player.setIp(resultSet.getString("IP"));
        player.setLoginIp(resultSet.getString("LOGINIP"));
        player.setUuid(resultSet.getString("UUID"));
        player.setRegDate(resultSet.getLong("REGDATE"));
        player.setLoginDate(resultSet.getLong("LOGINDATE"));
        return player;
    }

    private Connection openConnection() throws SQLException {
        DataSource dataSource = this.config.getDataSource();
        if (dataSource != null) {
            return dataSource.getConnection();
        }
        String user = this.config.getUser();
        String password = this.config.getPassword();
        if (user != null || password != null) {
            return DriverManager.getConnection(this.config.getJdbcUrl(), user, password);
        }
        return DriverManager.getConnection(this.config.getJdbcUrl());
    }

    private String table(String name) {
        return this.postgres ? this.quote(name) : name;
    }

    private String column(String name) {
        return this.postgres ? this.quote(name) : name;
    }

    private String joinColumns(String ... columns) {
        return String.join((CharSequence)", ", columns);
    }

    private String quote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

