/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.i18n;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private static final Map<String, Properties> messageCache = new ConcurrentHashMap<String, Properties>();
    private String currentLanguage = "en";

    public void setLanguage(String language) {
        if (language == null || language.trim().isEmpty()) {
            logger.warn("Invalid language provided, using default 'en'");
            this.currentLanguage = "en";
            return;
        }
        if (!this.isLanguageSupported(language)) {
            logger.warn("Unsupported language '{}', falling back to 'en'", (Object)language);
            this.currentLanguage = "en";
            return;
        }
        this.currentLanguage = language.toLowerCase(Locale.ROOT);
        logger.info("Language set to: {}", (Object)this.currentLanguage);
        this.loadMessages(this.currentLanguage);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String get(String key, Object ... args) {
        return this.get(this.currentLanguage, key, args);
    }

    public String get(String language, String key, Object ... args) {
        Properties messages = this.loadMessages(language);
        String message = messages.getProperty(key);
        if (message == null) {
            logger.debug("Message key '{}' not found for language '{}', falling back to English", (Object)key, (Object)language);
            if (!"en".equals(language)) {
                Properties englishMessages = this.loadMessages("en");
                message = englishMessages.getProperty(key);
            }
            if (message == null) {
                logger.warn("Message key '{}' not found in any language file", (Object)key);
                message = key;
            }
        }
        if (args.length > 0) {
            try {
                return MessageFormat.format(message, args);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Failed to format message '{}': {}", (Object)key, (Object)e.getMessage());
                return message;
            }
        }
        return message;
    }

    public boolean isLanguageSupported(String language) {
        if (language == null) {
            return false;
        }
        String lang = language.toLowerCase(Locale.ROOT);
        return "en".equals(lang) || "pl".equals(lang);
    }

    public String[] getSupportedLanguages() {
        return new String[]{"en", "pl"};
    }

    public void clearCache() {
        messageCache.clear();
        logger.info("Message cache cleared");
    }

    private Properties loadMessages(String language) {
        return messageCache.computeIfAbsent(language, this::loadMessagesFromFile);
    }

    private Properties loadMessagesFromFile(String language) {
        Properties properties = new Properties();
        String fileName = "lang/messages_" + language + ".properties";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            if (inputStream != null) {
                properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                logger.debug("Loaded {} messages from file: {}", (Object)properties.size(), (Object)fileName);
            } else {
                logger.error("Could not find language file: {}", (Object)fileName);
            }
        }
        catch (Exception e) {
            logger.error("Error loading language file: {}", (Object)fileName, (Object)e);
        }
        return properties;
    }

    public String getLanguageDisplayName(String languageCode) {
        return switch (languageCode.toLowerCase(Locale.ROOT)) {
            case "en" -> "English";
            case "pl" -> "Polski";
            default -> languageCode;
        };
    }

    public String getLanguageNativeName(String languageCode) {
        return switch (languageCode.toLowerCase(Locale.ROOT)) {
            case "en" -> "English";
            case "pl" -> "Polski";
            default -> languageCode;
        };
    }
}

