/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.util.Objects;
import net.rafalohaki.veloauth.libs.jackson.annotation.JsonFormat;
import net.rafalohaki.veloauth.libs.jackson.core.JsonGenerator;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.core.type.WritableTypeId;
import net.rafalohaki.veloauth.libs.jackson.databind.BeanProperty;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonMappingException;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializationFeature;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializerProvider;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.ContainerSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.ContextualSerializer;

public abstract class ArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final Boolean _unwrapSingle;

    protected ArraySerializerBase(Class<T> cls) {
        super(cls);
        this._property = null;
        this._unwrapSingle = null;
    }

    @Deprecated
    protected ArraySerializerBase(Class<T> cls, BeanProperty property) {
        super(cls);
        this._property = property;
        this._unwrapSingle = null;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src) {
        super(src._handledType, false);
        this._property = src._property;
        this._unwrapSingle = src._unwrapSingle;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property, Boolean unwrapSingle) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = unwrapSingle;
    }

    @Deprecated
    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = src._unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        Boolean unwrapSingle = null;
        if (property != null && (format = this.findFormatOverrides(serializers, property, this.handledType())) != null && !Objects.equals(unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED), this._unwrapSingle)) {
            return this._withResolved(property, unwrapSingle);
        }
        return this;
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._shouldUnwrapSingle(provider) && this.hasSingleElement(value)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray(value);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public final void serializeWithType(T value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
        g2.assignCurrentValue(value);
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected final boolean _shouldUnwrapSingle(SerializerProvider provider) {
        if (this._unwrapSingle == null) {
            return provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        return this._unwrapSingle;
    }
}

