/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.rafalohaki.veloauth.libs.jackson.annotation.JsonFormat;
import net.rafalohaki.veloauth.libs.jackson.core.JsonGenerator;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.core.type.WritableTypeId;
import net.rafalohaki.veloauth.libs.jackson.databind.BeanProperty;
import net.rafalohaki.veloauth.libs.jackson.databind.JavaType;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonMappingException;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonNode;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializationFeature;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializerProvider;
import net.rafalohaki.veloauth.libs.jackson.databind.annotation.JacksonStdImpl;
import net.rafalohaki.veloauth.libs.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.rafalohaki.veloauth.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.node.ObjectNode;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.ContainerSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.ContextualSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.std.ArraySerializerBase;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.std.ByteArraySerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.std.StdSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.type.TypeFactory;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    protected StdArraySerializers() {
    }

    public static JsonSerializer<?> findStandardImpl(Class<?> cls) {
        return _arraySerializers.get(cls.getName());
    }

    static JavaType simpleElementType(Class<?> elemClass) {
        return TypeFactory.defaultInstance().uncheckedSimpleType(elemClass);
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class BinaryDoubleArraySerializer
    extends StdSerializer<double[]>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        static final BinaryDoubleArraySerializer instance = new BinaryDoubleArraySerializer();

        public BinaryDoubleArraySerializer() {
            super(double[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, double[] value) {
            return value.length == 0;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) throws JsonMappingException {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null) {
                switch (format.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return DoubleArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(double[] value, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            int vectorLen = value.length;
            byte[] b = new byte[vectorLen << 3];
            int out = 0;
            for (int i = 0; i < vectorLen; ++i) {
                long bits = Double.doubleToLongBits(value[i]);
                int hi = (int)(bits >> 32);
                b[out] = (byte)(hi >> 24);
                b[out + 1] = (byte)(hi >> 16);
                b[out + 2] = (byte)(hi >> 8);
                b[out + 3] = (byte)hi;
                int lo = (int)bits;
                b[out + 4] = (byte)(lo >> 24);
                b[out + 5] = (byte)(lo >> 16);
                b[out + 6] = (byte)(lo >> 8);
                b[out + 7] = (byte)lo;
                out += 8;
            }
            g2.writeBinary(ctxt.getConfig().getBase64Variant(), b, 0, b.length);
        }

        @Override
        public void serializeWithType(double[] value, JsonGenerator g2, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value, g2, ctxt);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class BinaryFloatArraySerializer
    extends StdSerializer<float[]>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        static final BinaryFloatArraySerializer instance = new BinaryFloatArraySerializer();

        public BinaryFloatArraySerializer() {
            super(float[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, float[] value) {
            return value.length == 0;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) throws JsonMappingException {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null) {
                switch (format.getShape()) {
                    case ARRAY: 
                    case NATURAL: {
                        return FloatArraySerializer.instance;
                    }
                }
            }
            return this;
        }

        @Override
        public void serialize(float[] value, JsonGenerator g2, SerializerProvider ctxt) throws IOException {
            int vectorLen = value.length;
            byte[] b = new byte[vectorLen << 2];
            int out = 0;
            for (int i = 0; i < vectorLen; ++i) {
                int floatBits = Float.floatToIntBits(value[i]);
                b[out++] = (byte)(floatBits >> 24);
                b[out++] = (byte)(floatBits >> 16);
                b[out++] = (byte)(floatBits >> 8);
                b[out++] = (byte)floatBits;
            }
            g2.writeBinary(ctxt.getConfig().getBase64Variant(), b, 0, b.length);
        }

        @Override
        public void serializeWithType(float[] value, JsonGenerator g2, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(value, g2, ctxt);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Double.TYPE);
        static final DoubleArraySerializer instance = new DoubleArraySerializer();

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new DoubleArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, double[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] value) {
            return value.length == 1;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) throws JsonMappingException {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null && format.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryDoubleArraySerializer.instance;
            }
            return super.createContextual(ctxt, property);
        }

        @Override
        public final void serialize(double[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(double[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeNumber(value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Float.TYPE);
        static final FloatArraySerializer instance = new FloatArraySerializer();

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new FloatArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, float[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] value) {
            return value.length == 1;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) throws JsonMappingException {
            JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
            if (format != null && format.getShape() == JsonFormat.Shape.BINARY) {
                return BinaryFloatArraySerializer.instance;
            }
            return super.createContextual(ctxt, property);
        }

        @Override
        public final void serialize(float[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeStartArray(value, len);
            this.serializeContents(value, g2, provider);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(float[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeNumber(value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new LongArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, long[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(long[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(long[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeNumber(value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new IntArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, int[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(int[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeArray(value, 0, value.length);
        }

        @Override
        public void serializeContents(int[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeNumber(value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, char[] value) {
            return value.length == 0;
        }

        @Override
        public void serialize(char[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                g2.writeStartArray(value, value.length);
                this._writeArrayContents(g2, value);
                g2.writeEndArray();
            } else {
                g2.writeString(value, 0, value.length);
            }
        }

        @Override
        public void serializeWithType(char[] value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef;
            boolean asArray = provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (asArray) {
                typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
                this._writeArrayContents(g2, value);
            } else {
                typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_STRING));
                g2.writeString(value, 0, value.length);
            }
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        private final void _writeArrayContents(JsonGenerator g2, char[] value) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeString(value, i, 1);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            itemSchema.put("type", "string");
            return o.set("items", itemSchema);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new ShortArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, short[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(short[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeStartArray(value, len);
            this.serializeContents(value, g2, provider);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(short[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeNumber((int)value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            return o.set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Boolean.TYPE);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new BooleanArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, boolean[] value) {
            return value.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(boolean[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && this._shouldUnwrapSingle(provider)) {
                this.serializeContents(value, g2, provider);
                return;
            }
            g2.writeStartArray(value, len);
            this.serializeContents(value, g2, provider);
            g2.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                g2.writeBoolean(value[i]);
            }
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.set("items", this.createSchemaNode("boolean"));
            return o;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.BOOLEAN);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> cls) {
            super(cls);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public final ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }
    }
}

