/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import net.rafalohaki.veloauth.libs.jackson.core.JsonGenerator;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.core.type.WritableTypeId;
import net.rafalohaki.veloauth.libs.jackson.databind.JavaType;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonMappingException;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonNode;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializerProvider;
import net.rafalohaki.veloauth.libs.jackson.databind.annotation.JacksonStdImpl;
import net.rafalohaki.veloauth.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    public ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

