/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rafalohaki.veloauth.libs.jackson.core.JsonParseException;
import net.rafalohaki.veloauth.libs.jackson.core.ObjectCodec;
import net.rafalohaki.veloauth.libs.jackson.core.exc.StreamConstraintsException;
import net.rafalohaki.veloauth.libs.jackson.core.io.IOContext;
import net.rafalohaki.veloauth.libs.jackson.dataformat.yaml.YAMLParser;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

public class YAMLAnchorReplayingParser
extends YAMLParser {
    public static final int MAX_EVENTS = 9999;
    public static final int MAX_ANCHORS = 9999;
    public static final int MAX_MERGES = 9999;
    public static final int MAX_REFS = 9999;
    private final ArrayDeque<Integer> mergeStack = new ArrayDeque();
    private final ArrayDeque<AnchorContext> tokenStack = new ArrayDeque();
    private final Map<String, List<Event>> referencedObjects = new HashMap<String, List<Event>>();
    private final ArrayDeque<Event> refEvents = new ArrayDeque();
    private int globalDepth = 0;

    public YAMLAnchorReplayingParser(IOContext ctxt, int parserFeatures, int formatFeatures, LoaderOptions loaderOptions, ObjectCodec codec, Reader reader) {
        super(ctxt, parserFeatures, formatFeatures, loaderOptions, codec, reader);
    }

    private void finishContext(AnchorContext context) throws StreamConstraintsException {
        if (this.referencedObjects.size() + 1 > 9999) {
            throw new StreamConstraintsException("too many references in the document");
        }
        this.referencedObjects.put(context.anchor, context.events);
        if (!this.tokenStack.isEmpty()) {
            List<Event> events = this.tokenStack.peek().events;
            if (events.size() + context.events.size() > 9999) {
                throw new StreamConstraintsException("too many events to replay");
            }
            events.addAll(context.events);
        }
    }

    protected Event trackDepth(Event event) {
        if (event instanceof CollectionStartEvent) {
            ++this.globalDepth;
        } else if (event instanceof CollectionEndEvent) {
            --this.globalDepth;
        }
        return event;
    }

    protected Event filterEvent(Event event) {
        if (event instanceof MappingEndEvent && !this.mergeStack.isEmpty() && this.mergeStack.peek() > this.globalDepth) {
            this.mergeStack.pop();
            return null;
        }
        return event;
    }

    @Override
    protected Event getEvent() throws IOException {
        ScalarEvent scalarEvent;
        String anchor;
        Event event;
        while (!this.refEvents.isEmpty()) {
            event = this.filterEvent(this.trackDepth(this.refEvents.removeFirst()));
            if (event == null) continue;
            return event;
        }
        event = null;
        while (event == null) {
            event = this.trackDepth(super.getEvent());
            if (event == null) {
                return null;
            }
            event = this.filterEvent(event);
        }
        if (event instanceof AliasEvent) {
            AliasEvent alias = (AliasEvent)event;
            List<Event> events = this.referencedObjects.get(alias.getAnchor());
            if (events != null) {
                if (this.refEvents.size() + events.size() > 9999) {
                    throw new StreamConstraintsException("too many events to replay");
                }
                this.refEvents.addAll(events);
                return this.refEvents.removeFirst();
            }
            throw new JsonParseException("invalid alias " + alias.getAnchor());
        }
        if (event instanceof NodeEvent && (anchor = ((NodeEvent)event).getAnchor()) != null) {
            AnchorContext context = new AnchorContext(anchor);
            context.events.add(event);
            if (event instanceof CollectionStartEvent) {
                if (this.tokenStack.size() + 1 > 9999) {
                    throw new StreamConstraintsException("too many anchors in the document");
                }
                this.tokenStack.push(context);
            } else {
                this.finishContext(context);
            }
            return event;
        }
        if (event instanceof ScalarEvent && (scalarEvent = (ScalarEvent)event).getValue().equals("<<")) {
            Event next = this.getEvent();
            if (next instanceof MappingStartEvent) {
                if (this.mergeStack.size() + 1 > 9999) {
                    throw new StreamConstraintsException("too many merges in the document");
                }
                this.mergeStack.push(this.globalDepth);
                return this.getEvent();
            }
            throw new JsonParseException("found field '<<' but value isn't a map");
        }
        if (!this.tokenStack.isEmpty()) {
            AnchorContext context = this.tokenStack.peek();
            if (context.events.size() + 1 > 9999) {
                throw new StreamConstraintsException("too many events to replay");
            }
            context.events.add(event);
            if (event instanceof CollectionStartEvent) {
                ++context.depth;
            } else if (event instanceof CollectionEndEvent) {
                --context.depth;
                if (context.depth == 0) {
                    this.tokenStack.pop();
                    this.finishContext(context);
                }
            }
        }
        return event;
    }

    private static class AnchorContext {
        public final String anchor;
        public final List<Event> events = new ArrayList<Event>();
        public int depth = 1;

        public AnchorContext(String anchor) {
            this.anchor = anchor;
        }
    }
}

