/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.field.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import net.rafalohaki.veloauth.libs.ormlite.field.FieldType;
import net.rafalohaki.veloauth.libs.ormlite.field.SqlType;
import net.rafalohaki.veloauth.libs.ormlite.field.types.BaseDataType;
import net.rafalohaki.veloauth.libs.ormlite.support.DatabaseResults;

public class DateTimeType
extends BaseDataType {
    private static final DateTimeType singleTon = new DateTimeType();
    private static Class<?> dateTimeClass = null;
    private static Method getMillisMethod = null;
    private static Constructor<?> millisConstructor = null;
    private static final String[] associatedClassNames = new String[]{"org.joda.time.DateTime"};

    private DateTimeType() {
        super(SqlType.LONG);
    }

    protected DateTimeType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    public static DateTimeType getSingleton() {
        return singleTon;
    }

    @Override
    public String[] getAssociatedClassNames() {
        return associatedClassNames;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
        return this.extractMillis(javaObject);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Long.parseLong(defaultStr);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default DateTime value: " + defaultStr, e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getLong(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        return this.createInstance((Long)sqlArg);
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        try {
            return this.getDateTimeClass();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) throws SQLException {
        long newVal = System.currentTimeMillis();
        if (currentValue == null) {
            return this.createInstance(newVal);
        }
        Long currentVal = this.extractMillis(currentValue);
        if (newVal == currentVal) {
            return this.createInstance(newVal + 1L);
        }
        return this.createInstance(newVal);
    }

    private Object createInstance(Long sqlArg) throws SQLException {
        try {
            if (millisConstructor == null) {
                Class<?> clazz = this.getDateTimeClass();
                millisConstructor = clazz.getConstructor(Long.TYPE);
            }
            return millisConstructor.newInstance(sqlArg);
        }
        catch (Exception e) {
            throw new SQLException("Could not use reflection to construct a Joda DateTime", e);
        }
    }

    private Long extractMillis(Object javaObject) throws SQLException {
        try {
            if (getMillisMethod == null) {
                Class<?> clazz = this.getDateTimeClass();
                getMillisMethod = clazz.getMethod("getMillis", new Class[0]);
            }
            if (javaObject == null) {
                return null;
            }
            return (Long)getMillisMethod.invoke(javaObject, new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException("Could not use reflection to get millis from Joda DateTime: " + javaObject, e);
        }
    }

    private Class<?> getDateTimeClass() throws ClassNotFoundException {
        if (dateTimeClass == null) {
            dateTimeClass = Class.forName("org.joda.time.DateTime");
        }
        return dateTimeClass;
    }
}

