/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.rafalohaki.veloauth.libs.ormlite.field.SqlType;

public class TypeValMapper {
    private static final Map<SqlType, int[]> typeToValMap = new HashMap<SqlType, int[]>();

    public static int getTypeValForSqlType(SqlType sqlType) throws SQLException {
        int[] typeVals = typeToValMap.get((Object)sqlType);
        if (typeVals == null) {
            throw new SQLException("SqlType is unknown to type val mapping: " + (Object)((Object)sqlType));
        }
        if (typeVals.length == 0) {
            throw new SQLException("SqlType does not have any JDBC type value mapping: " + (Object)((Object)sqlType));
        }
        return typeVals[0];
    }

    public static SqlType getSqlTypeForTypeVal(int typeVal) {
        for (Map.Entry<SqlType, int[]> entry : typeToValMap.entrySet()) {
            for (int val : entry.getValue()) {
                if (val != typeVal) continue;
                return entry.getKey();
            }
        }
        return SqlType.UNKNOWN;
    }

    static {
        for (SqlType sqlType : SqlType.values()) {
            int[] values;
            switch (sqlType) {
                case STRING: {
                    values = new int[]{12};
                    break;
                }
                case LONG_STRING: {
                    values = new int[]{-1};
                    break;
                }
                case DATE: {
                    values = new int[]{93};
                    break;
                }
                case BOOLEAN: {
                    values = new int[]{16};
                    break;
                }
                case CHAR: {
                    values = new int[]{1};
                    break;
                }
                case BYTE: {
                    values = new int[]{-6};
                    break;
                }
                case BYTE_ARRAY: {
                    values = new int[]{-3};
                    break;
                }
                case SHORT: {
                    values = new int[]{5};
                    break;
                }
                case INTEGER: {
                    values = new int[]{4};
                    break;
                }
                case LONG: {
                    values = new int[]{-5};
                    break;
                }
                case FLOAT: {
                    values = new int[]{6};
                    break;
                }
                case DOUBLE: {
                    values = new int[]{8};
                    break;
                }
                case SERIALIZABLE: {
                    values = new int[]{-3};
                    break;
                }
                case BLOB: {
                    values = new int[]{2004};
                    break;
                }
                case BIG_DECIMAL: {
                    values = new int[]{3, 2};
                    break;
                }
                case UUID: {
                    values = new int[]{1111};
                    break;
                }
                case OTHER: {
                    values = new int[]{1111};
                    break;
                }
                case UNKNOWN: {
                    values = new int[]{};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No JDBC mapping for unknown SqlType " + (Object)((Object)sqlType));
                }
            }
            typeToValMap.put(sqlType, values);
        }
    }
}

