/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.logger;

import net.rafalohaki.veloauth.libs.ormlite.logger.Level;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackend;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackendFactory;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackendUtil;

public class ConsoleLogBackend
implements LogBackend {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private String className;

    public ConsoleLogBackend(String className) {
        this.className = className;
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return true;
    }

    @Override
    public void log(Level level, String msg) {
        String output = this.className + ' ' + (Object)((Object)level) + ' ' + msg + LINE_SEPARATOR;
        if (Level.WARNING.isEnabled(level)) {
            System.err.print(output);
        } else {
            System.out.print(output);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable throwable) {
        this.log(level, msg);
        if (throwable != null) {
            this.log(level, LogBackendUtil.throwableToString(throwable));
        }
    }

    public static class ConsoleLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new ConsoleLogBackend(classLabel);
        }
    }
}

