/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.connection.ConnectionManager;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import net.rafalohaki.veloauth.premium.PremiumResolution;
import net.rafalohaki.veloauth.premium.PremiumResolverService;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AuthListener {
    private static final Marker AUTH_MARKER = MarkerFactory.getMarker("AUTH");
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");
    private final VeloAuth plugin;
    private ConnectionManager connectionManager;
    private final AuthCache authCache;
    private final Settings settings;
    private final Logger logger;
    private PremiumResolverService premiumResolverService;
    private DatabaseManager databaseManager;
    private final Messages messages;

    @Inject
    public AuthListener(VeloAuth plugin, ConnectionManager connectionManager, AuthCache authCache, Settings settings, PremiumResolverService premiumResolverService, DatabaseManager databaseManager, Messages messages) {
        this.plugin = plugin;
        this.connectionManager = connectionManager;
        this.authCache = authCache;
        this.settings = settings;
        this.logger = plugin.getLogger();
        this.premiumResolverService = premiumResolverService;
        this.databaseManager = databaseManager;
        this.messages = messages;
        this.logger.info(messages.get("connection.listener.registered", new Object[0]));
    }

    public void updateDependencies(ConnectionManager connectionManager, PremiumResolverService premiumResolverService, DatabaseManager databaseManager) {
        this.connectionManager = connectionManager;
        this.premiumResolverService = premiumResolverService;
        this.databaseManager = databaseManager;
        this.logger.info("AuthListener dependencies updated successfully");
    }

    private static String resolveBlockReason(boolean isAuthorized, boolean hasActiveSession) {
        if (!isAuthorized) {
            return "nieautoryzowany";
        }
        if (!hasActiveSession) {
            return "brak aktywnej sesji";
        }
        return "UUID mismatch";
    }

    @Subscribe(priority=32767, async=false, order=PostOrder.FIRST)
    public void onPreLogin(PreLoginEvent event) {
        String username = event.getUsername();
        this.logger.info("\ud83d\udd0d PreLogin: {}", (Object)username);
        if (!this.plugin.isInitialized()) {
            this.logger.warn("\ud83d\udd12 BLOKADA STARTU: Gracz {} pr\u00f3bowa\u0142 po\u0142\u0105czy\u0107 si\u0119 przed pe\u0142n\u0105 inicjalizacj\u0105 VeloAuth - blokada PreLogin", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)"VeloAuth si\u0119 uruchamia. Spr\u00f3buj po\u0142\u0105czy\u0107 si\u0119 ponownie za chwil\u0119.", (TextColor)NamedTextColor.RED)));
            return;
        }
        if (!this.isValidUsername(username)) {
            String message = "Nieprawid\u0142owy format nazwy u\u017cytkownika! U\u017cyj tylko liter, cyfr i podkre\u015blenia (max 16 znak\u00f3w).";
            this.logger.warn(SECURITY_MARKER, "[USERNAME VALIDATION FAILED] {} - invalid format", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)message, (TextColor)NamedTextColor.RED)));
            return;
        }
        InetAddress playerAddress = this.getPlayerAddressFromPreLogin(event);
        if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
            String message = "Zbyt wiele nieudanych pr\u00f3b logowania. Spr\u00f3buj ponownie p\u00f3\u017aniej.";
            this.logger.warn(SECURITY_MARKER, "[BRUTE FORCE BLOCK] IP {} zablokowany", (Object)playerAddress.getHostAddress());
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)message, (TextColor)NamedTextColor.RED)));
            return;
        }
        if (!this.settings.isPremiumCheckEnabled()) {
            this.logger.debug("Premium check wy\u0142\u0105czony w konfiguracji - wymuszam offline mode dla {}", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            return;
        }
        boolean premium = false;
        PremiumResolutionResult result = this.resolvePremiumStatus(username);
        premium = result.premium();
        if (premium) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOnlineMode());
        } else {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
        }
    }

    private PremiumResolutionResult resolvePremiumStatus(String username) {
        PremiumResolution resolution;
        AuthCache.PremiumCacheEntry cachedStatus = this.authCache.getPremiumStatus(username);
        if (cachedStatus != null) {
            this.logger.debug("Premium cache hit dla {} -> {}", (Object)username, (Object)cachedStatus.isPremium());
            return new PremiumResolutionResult(cachedStatus.isPremium(), cachedStatus.getPremiumUuid());
        }
        try {
            resolution = (PremiumResolution)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.premiumResolverService.resolve(username)).orTimeout(3L, TimeUnit.SECONDS).exceptionally(throwable -> {
                this.logger.warn("Premium resolution timeout for {}, treating as offline: {}", (Object)username, (Object)throwable.getMessage());
                return PremiumResolution.offline(username, "VeloAuth-Timeout", "Timeout - fallback to offline");
            })).join();
        }
        catch (Exception e) {
            this.logger.warn("Premium resolution failed for {}, treating as offline: {}", (Object)username, (Object)e.getMessage());
            resolution = PremiumResolution.offline(username, "VeloAuth-Error", "Error - fallback to offline");
        }
        boolean premium = false;
        UUID premiumUuid = null;
        if (resolution.isPremium()) {
            premium = true;
            premiumUuid = resolution.uuid();
            String canonical = resolution.canonicalUsername() != null ? resolution.canonicalUsername() : username;
            this.authCache.addPremiumPlayer(canonical, premiumUuid);
            this.logger.info(this.messages.get("player.premium.confirmed", new Object[0]), username, resolution.source(), premiumUuid);
        } else if (resolution.isOffline()) {
            this.authCache.addPremiumPlayer(username, null);
            this.logger.debug("{} nie jest premium (resolver: {}, info: {})", username, resolution.source(), resolution.message());
        } else {
            this.logger.warn("\u26a0\ufe0f Nie uda\u0142o si\u0119 jednoznacznie potwierdzi\u0107 statusu premium dla {} (resolver: {}, info: {})", username, resolution.source(), resolution.message());
        }
        return new PremiumResolutionResult(premium, premiumUuid);
    }

    @Subscribe(priority=32767, async=false, order=PostOrder.FIRST)
    public void onLogin(LoginEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getUsername();
        UUID playerUuid = player.getUniqueId();
        String playerIp = this.getPlayerIp(player);
        boolean allowed = true;
        try {
            if (!this.plugin.isInitialized()) {
                this.logger.warn("\ud83d\udd12 BLOKADA STARTU: Gracz {} pr\u00f3bowa\u0142 zalogowa\u0107 si\u0119 przed pe\u0142n\u0105 inicjalizacj\u0105 VeloAuth - blokada logowania", (Object)playerName);
                event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"VeloAuth si\u0119 uruchamia. Spr\u00f3buj zalogowa\u0107 si\u0119 ponownie za chwil\u0119.", (TextColor)NamedTextColor.RED)));
                return;
            }
            this.logger.debug("LoginEvent dla gracza {} (UUID: {}) z IP {}", playerName, playerUuid, playerIp);
            InetAddress playerAddress = this.getPlayerAddress(player);
            if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
                String message = String.format("Zablokowano po\u0142\u0105czenie gracza %s za zbyt wiele nieudanych pr\u00f3b logowania", playerName);
                this.logger.warn(SECURITY_MARKER, message);
                event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"Zbyt wiele nieudanych pr\u00f3b logowania. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED)));
                allowed = false;
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi LoginEvent dla gracza: " + event.getPlayer().getUsername(), e);
            event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED)));
            allowed = false;
        }
        if (allowed) {
            event.setResult(ResultedEvent.ComponentResult.allowed());
        }
    }

    @Subscribe(priority=0)
    public void onDisconnect(DisconnectEvent event) {
        try {
            Player player = event.getPlayer();
            this.logger.debug("Gracz {} roz\u0142\u0105czy\u0142 si\u0119 - sesja pozostaje aktywna", (Object)player.getUsername());
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi DisconnectEvent dla gracza: {}", (Object)event.getPlayer().getUsername(), (Object)e);
        }
    }

    @Subscribe(priority=0)
    public void onPostLogin(PostLoginEvent event) {
        Player player = event.getPlayer();
        String playerIp = this.getPlayerIp(player);
        this.logger.debug("PostLoginEvent dla gracza {} z IP {}", (Object)player.getUsername(), (Object)playerIp);
        try {
            if (player.isOnlineMode()) {
                this.logger.info(AUTH_MARKER, this.messages.get("player.premium.verified", new Object[0]), (Object)player.getUsername());
                UUID playerUuid = player.getUniqueId();
                UUID premiumUuid = Optional.ofNullable(this.authCache.getPremiumStatus(player.getUsername())).map(AuthCache.PremiumCacheEntry::getPremiumUuid).orElse(playerUuid);
                CachedAuthUser cachedUser = new CachedAuthUser(playerUuid, player.getUsername(), playerIp, System.currentTimeMillis(), true, premiumUuid);
                this.authCache.addAuthorizedPlayer(playerUuid, cachedUser);
                this.authCache.startSession(playerUuid, player.getUsername(), playerIp);
                return;
            }
            if (this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp)) {
                this.logger.info(AUTH_MARKER, "\u2705 Gracz {} jest ju\u017c autoryzowany - pozostaje na backendzie", (Object)player.getUsername());
                return;
            }
            this.logger.info(this.messages.get("player.unauthorized.redirect", new Object[0]), (Object)player.getUsername());
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                try {
                    boolean success = this.connectionManager.transferToPicoLimbo(player);
                    if (!success) {
                        this.logger.error("\u274c B\u0142\u0105d podczas przenoszenia gracza {} na PicoLimbo", (Object)player.getUsername());
                        player.disconnect((Component)Component.text((String)"Nie uda\u0142o si\u0119 po\u0142\u0105czy\u0107 z serwerem autoryzacji. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u274c B\u0142\u0105d podczas przenoszenia gracza {} na PicoLimbo: {}", player.getUsername(), e.getMessage(), e);
                    player.disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia z serwerem autoryzacji. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
                }
            }).schedule();
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi PostLoginEvent dla gracza: {}", (Object)event.getPlayer().getUsername(), (Object)e);
            event.getPlayer().disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
        }
    }

    @Subscribe(priority=32767, async=false, order=PostOrder.FIRST)
    public void onServerPreConnect(ServerPreConnectEvent event) {
        try {
            Player player = event.getPlayer();
            String targetServerName = event.getOriginalServer().getServerInfo().getName();
            String playerIp = this.getPlayerIp(player);
            this.logger.debug("ServerPreConnectEvent dla gracza {} -> serwer {}", (Object)player.getUsername(), (Object)targetServerName);
            if (targetServerName.equals(this.settings.getPicoLimboServerName())) {
                boolean isAuthorized = this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp);
                if (isAuthorized) {
                    this.logger.debug("Autoryzowany gracz {} pr\u00f3buje i\u015b\u0107 na PicoLimbo - przekierowuj\u0119 na backend", (Object)player.getUsername());
                    event.setResult(ServerPreConnectEvent.ServerResult.denied());
                    return;
                }
                this.logger.debug("PicoLimbo - pozw\u00f3l (gracz nie jest autoryzowany)");
                return;
            }
            boolean isAuthorized = this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp);
            boolean hasActiveSession = this.authCache.hasActiveSession(player.getUniqueId(), player.getUsername(), ValidationUtils.getPlayerIp(player));
            boolean uuidMatches = this.verifyPlayerUuid(player);
            if (!(isAuthorized && hasActiveSession && uuidMatches)) {
                String reason = AuthListener.resolveBlockReason(isAuthorized, hasActiveSession);
                this.logger.warn(SECURITY_MARKER, this.messages.get("player.blocked.unauthorized", new Object[0]), player.getUsername(), targetServerName, reason, playerIp);
                event.setResult(ServerPreConnectEvent.ServerResult.denied());
                player.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u274c ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"Musisz si\u0119 zalogowa\u0107 na auth!").color((TextColor)NamedTextColor.RED))).build());
                if (!uuidMatches) {
                    this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                    this.authCache.endSession(player.getUniqueId());
                }
                return;
            }
            this.logger.debug("\u2705 Autoryzowany gracz {} idzie na {} (sesja: OK, UUID: OK)", (Object)player.getUsername(), (Object)targetServerName);
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d w ServerPreConnect", e);
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
    }

    @Subscribe(priority=-200)
    public void onServerConnected(ServerConnectedEvent event) {
        try {
            Player player = event.getPlayer();
            String serverName = event.getServer().getServerInfo().getName();
            this.logger.debug("ServerConnectedEvent dla gracza {} -> serwer {}", (Object)player.getUsername(), (Object)serverName);
            if (!serverName.equals(this.settings.getPicoLimboServerName())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(AUTH_MARKER, this.messages.get("player.connected.backend", new Object[0]), (Object)player.getUsername(), (Object)serverName);
                }
                player.sendMessage((Component)Component.text((String)"Witaj na serwerze! Mi\u0142ej gry!", (TextColor)NamedTextColor.GREEN));
            } else {
                this.logger.debug(AUTH_MARKER, "Gracz {} po\u0142\u0105czy\u0142 si\u0119 z PicoLimbo", (Object)player.getUsername());
                player.sendMessage((Component)Component.text((String)"=== Autoryzacja VeloAuth ===", (TextColor)NamedTextColor.GOLD));
                player.sendMessage((Component)Component.text((String)"Je\u015bli masz konto: /login <has\u0142o>", (TextColor)NamedTextColor.YELLOW));
                player.sendMessage((Component)Component.text((String)"Je\u015bli nie masz konta: /register <has\u0142o> <powt\u00f3rz>", (TextColor)NamedTextColor.YELLOW));
            }
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi ServerConnectedEvent", e);
        }
    }

    private String getPlayerIp(Player player) {
        if (player.getRemoteAddress() != null && player.getRemoteAddress().getAddress() != null) {
            return player.getRemoteAddress().getAddress().getHostAddress();
        }
        return "unknown";
    }

    private InetAddress getPlayerAddress(Player player) {
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress();
        }
        return null;
    }

    private InetAddress getPlayerAddressFromPreLogin(PreLoginEvent event) {
        try {
            InetSocketAddress address;
            InboundConnection connection = event.getConnection();
            if (connection != null && (address = connection.getRemoteAddress()) instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = address;
                return inetAddress.getAddress();
            }
        }
        catch (Exception e) {
            this.logger.debug("Nie mo\u017cna pobra\u0107 adresu z PreLoginEvent: {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean isValidUsername(String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (username.length() < 3 || username.length() > 16) {
            return false;
        }
        for (int i = 0; i < username.length(); ++i) {
            char c = username.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    private boolean verifyPlayerUuid(Player player) {
        try {
            if (player.isOnlineMode()) {
                this.logger.debug("Premium gracz {} - pomijam weryfikacj\u0119 UUID z baz\u0105", (Object)player.getUsername());
                return true;
            }
            return CompletableFuture.supplyAsync(() -> {
                try {
                    DatabaseManager.DbResult<RegisteredPlayer> dbResult = this.databaseManager.findPlayerByNickname(player.getUsername()).join();
                    if (dbResult.isDatabaseError()) {
                        this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] UUID verification failed for {}: {}", (Object)player.getUsername(), (Object)dbResult.getErrorMessage());
                        this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                        this.authCache.endSession(player.getUniqueId());
                        return false;
                    }
                    RegisteredPlayer dbPlayer = dbResult.getValue();
                    if (dbPlayer == null) {
                        this.logger.debug("Brak UUID w bazie dla gracza {}", (Object)player.getUsername());
                        return false;
                    }
                    UUID storedUuid = UUID.fromString(dbPlayer.getUuid());
                    UUID playerUuid = player.getUniqueId();
                    boolean matches = playerUuid.equals(storedUuid);
                    if (!matches) {
                        this.logger.warn(SECURITY_MARKER, "[UUID VERIFICATION FAILED] Player: {} (UUID: {}), DB: {} (UUID: {})", player.getUsername(), playerUuid, dbPlayer.getNickname(), storedUuid);
                        this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                        this.authCache.endSession(player.getUniqueId());
                    }
                    return matches;
                }
                catch (Exception e) {
                    this.logger.error("B\u0142\u0105d podczas weryfikacji UUID dla gracza: {}", (Object)player.getUsername(), (Object)e);
                    this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                    this.authCache.endSession(player.getUniqueId());
                    return false;
                }
            }).join();
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas weryfikacji UUID dla gracza: {}", (Object)player.getUsername(), (Object)e);
            this.authCache.removeAuthorizedPlayer(player.getUniqueId());
            this.authCache.endSession(player.getUniqueId());
            return false;
        }
    }

    private record PremiumResolutionResult(boolean premium, UUID premiumUuid) {
    }
}

