/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.model;

import java.util.Objects;
import java.util.UUID;
import net.rafalohaki.veloauth.libs.ormlite.field.DatabaseField;
import net.rafalohaki.veloauth.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="AUTH")
public class RegisteredPlayer {
    @DatabaseField(columnName="NICKNAME", canBeNull=false)
    private String nickname;
    @DatabaseField(columnName="LOWERCASENICKNAME", id=true, canBeNull=false)
    private String lowercaseNickname;
    @DatabaseField(columnName="HASH", canBeNull=false)
    private String hash;
    @DatabaseField(columnName="IP")
    private String ip;
    @DatabaseField(columnName="REGDATE")
    private long regDate;
    @DatabaseField(columnName="UUID")
    private String uuid;
    @DatabaseField(columnName="LOGINIP")
    private String loginIp;
    @DatabaseField(columnName="LOGINDATE")
    private long loginDate;

    public RegisteredPlayer() {
    }

    public RegisteredPlayer(String nickname, String hash, String ip, String uuid) {
        long currentTime;
        if (nickname == null || nickname.isEmpty()) {
            throw new IllegalArgumentException("Nickname nie mo\u017ce by\u0107 pusty");
        }
        if (hash == null || hash.isEmpty()) {
            throw new IllegalArgumentException("Hash nie mo\u017ce by\u0107 pusty");
        }
        this.nickname = nickname;
        this.lowercaseNickname = nickname.toLowerCase();
        this.hash = hash;
        this.ip = ip;
        this.uuid = uuid;
        this.loginIp = ip;
        this.regDate = currentTime = System.currentTimeMillis();
        this.loginDate = currentTime;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        if (nickname == null || nickname.isEmpty()) {
            throw new IllegalArgumentException("Nickname nie mo\u017ce by\u0107 pusty");
        }
        this.nickname = nickname;
        this.lowercaseNickname = nickname.toLowerCase();
    }

    public String getLowercaseNickname() {
        return this.lowercaseNickname;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        if (hash == null || hash.isEmpty()) {
            throw new IllegalArgumentException("Hash nie mo\u017ce by\u0107 pusty");
        }
        this.hash = hash;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public long getLoginDate() {
        return this.loginDate;
    }

    public void setLoginDate(long loginDate) {
        this.loginDate = loginDate;
    }

    @Deprecated(since="1.0.0", forRemoval=true)
    public boolean isPremium() {
        return false;
    }

    public void updateLoginData(String loginIp) {
        this.loginIp = loginIp;
        this.loginDate = System.currentTimeMillis();
    }

    public UUID getUuidAsUUID() {
        if (this.uuid == null || this.uuid.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(this.uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisteredPlayer that = (RegisteredPlayer)obj;
        return Objects.equals(this.lowercaseNickname, that.lowercaseNickname);
    }

    public int hashCode() {
        return Objects.hash(this.lowercaseNickname);
    }

    public String toString() {
        return "RegisteredPlayer{nickname='" + this.nickname + "', lowercaseNickname='" + this.lowercaseNickname + "', ip='" + this.ip + "', loginIp='" + this.loginIp + "', uuid='" + this.uuid + "', regDate=" + this.regDate + ", loginDate=" + this.loginDate + ", isPremium=" + this.isPremium() + "}";
    }
}

