/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.premium;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.rafalohaki.veloauth.premium.HttpJsonClient;
import net.rafalohaki.veloauth.premium.PremiumResolution;
import net.rafalohaki.veloauth.premium.PremiumResolver;
import org.slf4j.Logger;

abstract class AbstractPremiumResolver
implements PremiumResolver {
    private static final int REQUESTS_PER_MINUTE = 60;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private final Logger logger;
    private final boolean enabled;
    private final int timeoutMs;
    private final ConcurrentHashMap<String, AtomicInteger> requestCounts = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicLong> lastResetTime = new ConcurrentHashMap();

    protected AbstractPremiumResolver(Logger logger, boolean enabled, int timeoutMs) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.enabled = enabled;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public PremiumResolution resolve(String username) {
        if (!this.enabled) {
            return PremiumResolution.unknown(this.id(), "disabled");
        }
        if (this.isRateLimited()) {
            this.logger.debug("[{}] Rate limited for {}", (Object)this.getClass().getSimpleName(), (Object)username);
            return PremiumResolution.unknown(this.id(), "rate limited");
        }
        try {
            HttpJsonClient.HttpJsonResponse response = HttpJsonClient.get(this.getEndpoint(), username, this.timeoutMs);
            int code = response.statusCode();
            if (this.isNotFoundResponse(code)) {
                return PremiumResolution.offline(username, this.id(), "not found");
            }
            if (code != 200) {
                this.logger.debug("[{}] HTTP {} for {}", this.getClass().getSimpleName(), code, username);
                return PremiumResolution.unknown(this.id(), "http " + code);
            }
            String body = response.body();
            String uuidStr = this.extractUuidField(body);
            String canonical = this.extractUsernameField(body);
            if (uuidStr == null || canonical == null) {
                this.logger.debug("[{}] Missing fields for {}", (Object)this.getClass().getSimpleName(), (Object)username);
                return PremiumResolution.unknown(this.id(), "missing fields");
            }
            UUID uuid = this.parseUuid(uuidStr);
            if (uuid == null) {
                this.logger.debug("[{}] Invalid uuid {} for {}", this.getClass().getSimpleName(), uuidStr, username);
                return PremiumResolution.unknown(this.id(), "uuid parse error");
            }
            return PremiumResolution.premium(uuid, canonical, this.id());
        }
        catch (IOException ex) {
            this.logger.debug("[{}] IO error for {}: {}", this.getClass().getSimpleName(), username, ex.getMessage());
            return PremiumResolution.unknown(this.id(), "io error");
        }
        catch (Exception ex) {
            this.logger.warn("[{}] Unexpected error for {}", this.getClass().getSimpleName(), username, ex);
            return PremiumResolution.unknown(this.id(), "unexpected");
        }
    }

    protected abstract String getEndpoint();

    protected abstract boolean isNotFoundResponse(int var1);

    protected abstract String extractUuidField(String var1);

    protected abstract String extractUsernameField(String var1);

    protected UUID parseUuid(String uuidStr) {
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private boolean isRateLimited() {
        String resolverId = this.id();
        long currentTime = System.currentTimeMillis();
        AtomicInteger count = this.requestCounts.computeIfAbsent(resolverId, k -> new AtomicInteger(0));
        AtomicLong lastReset = this.lastResetTime.computeIfAbsent(resolverId, k -> new AtomicLong(currentTime));
        long timeSinceReset = currentTime - lastReset.get();
        if (timeSinceReset > 60000L) {
            this.lastResetTime.compute(resolverId, (key, existingValue) -> {
                if (existingValue == null || currentTime - existingValue.get() > 60000L) {
                    count.set(0);
                    return new AtomicLong(currentTime);
                }
                return existingValue;
            });
        }
        return count.incrementAndGet() > 60;
    }
}

