/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.net.InetAddress;
import java.util.UUID;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class CacheHelper {
    private CacheHelper() {
    }

    public static void addAuthorizedPlayer(AuthCache authCache, UUID playerUuid, CachedAuthUser cachedUser, Logger logger, Marker authMarker, String playerName, Messages messages) {
        try {
            authCache.addAuthorizedPlayer(playerUuid, cachedUser);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("cache.add.player", new Object[0]), (Object)playerName);
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.add.player", new Object[0]), (Object)playerName, (Object)e);
        }
    }

    public static void addNewAuthorizedPlayer(AuthCache authCache, RegisteredPlayer registeredPlayer, boolean isPremium, Logger logger, Marker authMarker, Messages messages) {
        try {
            UUID playerUuid = UUID.fromString(registeredPlayer.getUuid());
            CachedAuthUser cachedUser = CachedAuthUser.fromRegisteredPlayer(registeredPlayer, isPremium);
            CacheHelper.addAuthorizedPlayer(authCache, playerUuid, cachedUser, logger, authMarker, registeredPlayer.getNickname(), messages);
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.create.player", new Object[0]), (Object)registeredPlayer.getNickname(), (Object)e);
        }
    }

    public static void removeAuthorizedPlayer(AuthCache authCache, UUID playerUuid, Logger logger, Marker authMarker, String playerName, Messages messages) {
        try {
            authCache.removeAuthorizedPlayer(playerUuid);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("cache.remove.player", new Object[0]), (Object)playerName);
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.remove.player", new Object[0]), (Object)playerName, (Object)e);
        }
    }

    public static void startSession(AuthCache authCache, UUID playerUuid, String playerName, String playerIp, Logger logger, Marker authMarker, Messages messages) {
        try {
            authCache.startSession(playerUuid, playerName, playerIp);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("session.start", new Object[0]), (Object)playerName, (Object)playerIp);
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("session.error.start", new Object[0]), (Object)playerName, (Object)e);
        }
    }

    public static void endSession(AuthCache authCache, UUID playerUuid, String playerName, Logger logger, Marker authMarker, Messages messages) {
        try {
            authCache.endSession(playerUuid);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("session.end", new Object[0]), (Object)playerName);
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("session.error.end", new Object[0]), (Object)playerName, (Object)e);
        }
    }

    public static boolean isPlayerAuthorized(AuthCache authCache, UUID playerUuid, String playerIp, Logger logger, Marker authMarker, String playerName, Messages messages) {
        try {
            boolean authorized = authCache.isPlayerAuthorized(playerUuid, playerIp);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("cache.check.auth", new Object[0]), (Object)playerName, (Object)authorized);
            }
            return authorized;
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.check.auth", new Object[0]), (Object)playerName, (Object)e);
            return false;
        }
    }

    public static void removePremiumPlayer(AuthCache authCache, String playerName, Logger logger, Marker authMarker, Messages messages) {
        try {
            authCache.removePremiumPlayer(playerName);
            if (logger.isDebugEnabled()) {
                logger.debug(authMarker, messages.get("cache.remove.premium", new Object[0]), (Object)playerName);
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.remove.premium", new Object[0]), (Object)playerName, (Object)e);
        }
    }

    public static void resetBruteForceAttempts(AuthCache authCache, InetAddress playerAddress, Logger logger, Marker authMarker, Messages messages) {
        try {
            if (playerAddress != null) {
                authCache.resetLoginAttempts(playerAddress);
                if (logger.isDebugEnabled()) {
                    logger.debug(authMarker, messages.get("brute.force.reset", new Object[0]), (Object)playerAddress.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.reset.brute.force", new Object[0]), (Object)(playerAddress != null ? playerAddress.getHostAddress() : "unknown"), (Object)e);
        }
    }

    public static void completePlayerCleanup(AuthCache authCache, UUID playerUuid, String playerName, Logger logger, Marker authMarker, Messages messages) {
        try {
            CacheHelper.removeAuthorizedPlayer(authCache, playerUuid, logger, authMarker, playerName, messages);
            CacheHelper.endSession(authCache, playerUuid, playerName, logger, authMarker, messages);
            logger.info(authMarker, messages.get("cache.cleanup.complete", new Object[0]), (Object)playerName);
        }
        catch (Exception e) {
            logger.error(authMarker, messages.get("cache.error.cleanup", new Object[0]), (Object)playerName, (Object)e);
        }
    }
}

