/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import net.rafalohaki.veloauth.util.VeloAuthErrorHandler;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class DatabaseHelper {
    private DatabaseHelper() {
    }

    public static CompletableFuture<RegisteredPlayer> findPlayerByNickname(DatabaseManager databaseManager, String nickname, Logger logger, Marker marker, Messages messages) {
        return ((CompletableFuture)databaseManager.findPlayerByNickname(nickname).thenApply(dbResult -> {
            if (dbResult.isDatabaseError()) {
                VeloAuthErrorHandler.handleDatabaseError(new RuntimeException(dbResult.getErrorMessage()), "player lookup", logger, marker, messages, "nickname: " + nickname);
                return null;
            }
            return (RegisteredPlayer)dbResult.getValue();
        })).exceptionally(throwable -> {
            VeloAuthErrorHandler.handleDatabaseError(throwable, "player lookup", logger, marker, messages, "nickname: " + nickname);
            return null;
        });
    }

    public static CompletableFuture<RegisteredPlayer> findPlayerByNickname(DatabaseManager databaseManager, String nickname, Logger logger, Messages messages) {
        return DatabaseHelper.findPlayerByNickname(databaseManager, nickname, logger, null, messages);
    }

    public static <T> T validateDbResult(DatabaseManager.DbResult<T> dbResult, String operation, Logger logger, Marker marker, Messages messages, String context) {
        if (dbResult.isDatabaseError()) {
            VeloAuthErrorHandler.handleDatabaseError(new RuntimeException(dbResult.getErrorMessage()), operation, logger, marker, messages, context);
            return null;
        }
        return dbResult.getValue();
    }

    public static <T> T validateDbResult(DatabaseManager.DbResult<T> dbResult, String operation, Logger logger, Messages messages, String context) {
        return DatabaseHelper.validateDbResult(dbResult, operation, logger, null, messages, context);
    }

    public static CompletableFuture<Boolean> savePlayer(DatabaseManager databaseManager, RegisteredPlayer player, Logger logger, Marker marker, Messages messages) {
        return ((CompletableFuture)databaseManager.savePlayer(player).thenApply(dbResult -> {
            if (dbResult.isDatabaseError()) {
                VeloAuthErrorHandler.handleDatabaseError(new RuntimeException(dbResult.getErrorMessage()), "player save", logger, marker, messages, "player: " + player.getNickname());
                return false;
            }
            return (Boolean)dbResult.getValue();
        })).exceptionally(throwable -> {
            logger.error(marker, messages.get("database.error.saving", new Object[0]) + player.getNickname(), (Throwable)throwable);
            return false;
        });
    }

    public static CompletableFuture<Boolean> deletePlayer(DatabaseManager databaseManager, String nickname, Logger logger, Marker marker, Messages messages) {
        String lowercaseNick = nickname.toLowerCase();
        return ((CompletableFuture)databaseManager.deletePlayer(lowercaseNick).thenApply(dbResult -> {
            if (dbResult.isDatabaseError()) {
                logger.error(marker, "Database error deleting player {}: {}", (Object)lowercaseNick, (Object)dbResult.getErrorMessage());
                return false;
            }
            return (Boolean)dbResult.getValue();
        })).exceptionally(throwable -> {
            logger.error(marker, messages.get("database.error.deleting", new Object[0]) + lowercaseNick, (Throwable)throwable);
            return false;
        });
    }

    public static CompletableFuture<Boolean> isPremium(DatabaseManager databaseManager, String username, Logger logger, Marker marker, Messages messages) {
        return ((CompletableFuture)databaseManager.isPremium(username).thenApply(dbResult -> {
            if (dbResult.isDatabaseError()) {
                logger.warn(marker, "Database error checking premium status for {}: {}", (Object)username, (Object)dbResult.getErrorMessage());
                return false;
            }
            return (Boolean)dbResult.getValue();
        })).exceptionally(throwable -> {
            logger.warn(marker, messages.get("database.error.checking_premium", new Object[0]) + username, (Throwable)throwable);
            return false;
        });
    }

    public static CompletableFuture<Boolean> executeTransaction(DatabaseManager databaseManager, Callable<Boolean> operation, Logger logger, Marker marker, String operationName, Messages messages) {
        return databaseManager.executeInTransaction(operation).exceptionally(throwable -> {
            logger.error(marker, messages.get("database.error.transaction", new Object[0]) + operationName, (Throwable)throwable);
            return false;
        });
    }

    public static CompletableFuture<Boolean> updatePlayerLoginData(DatabaseManager databaseManager, RegisteredPlayer player, String playerIp, Logger logger, Marker marker, Messages messages) {
        try {
            player.updateLoginData(playerIp);
            return DatabaseHelper.savePlayer(databaseManager, player, logger, marker, messages);
        }
        catch (Exception e) {
            logger.error(marker, messages.get("database.error.updating_login", new Object[0]) + player.getNickname(), e);
            return CompletableFuture.completedFuture(false);
        }
    }

    public static Function<Throwable, Void> createDatabaseErrorHandler(Logger logger, Marker marker, String operationName, String playerName, Messages messages) {
        return throwable -> {
            logger.error(marker, messages.get("database.error.operation", operationName, playerName), (Throwable)throwable);
            return null;
        };
    }
}

