/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.proxy.Player;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.util.PlayerHelper;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class ErrorHandlingHelper {
    private ErrorHandlingHelper() {
    }

    public static void handleAsyncException(Logger logger, Marker marker, String operationName, Player player, Throwable throwable, Messages messages) {
        String errorMessage = "Error during " + operationName + ": " + (player != null ? player.getUsername() : "unknown");
        logger.error(marker, errorMessage, throwable);
        if (player != null) {
            String userMessage = messages.get("error.database.query", new Object[0]);
            PlayerHelper.sendErrorMessage(player, userMessage);
        }
    }

    public static Function<Throwable, Void> createAsyncExceptionHandler(Logger logger, Marker marker, String operationName, Player player, Messages messages) {
        return throwable -> {
            ErrorHandlingHelper.handleAsyncException(logger, marker, operationName, player, throwable, messages);
            return null;
        };
    }

    public static void handleDatabaseError(Logger logger, Marker marker, String operationName, Player player, Exception e, Messages messages) {
        String errorMessage = "Database error during " + operationName + ": " + (player != null ? player.getUsername() : "unknown");
        logger.error(marker, errorMessage, e);
        if (player != null) {
            player.sendMessage(ValidationUtils.createErrorComponent(messages.get("error.database.query", new Object[0])));
        }
    }

    public static void handleValidationError(Player player, String validationMessage) {
        if (player != null && validationMessage != null) {
            player.sendMessage(ValidationUtils.createErrorComponent(validationMessage));
        }
    }

    public static void handleSecurityEvent(Logger logger, Marker marker, String eventType, Player player, String details) {
        String logMessage = String.format("[SECURITY] %s - %s: %s", eventType, PlayerHelper.createPlayerInfo(player), details != null ? details : "");
        logger.warn(marker, logMessage);
    }

    public static CompletableFuture<Void> withErrorHandling(CompletableFuture<Void> future, Logger logger, Marker marker, String operationName, Player player, Messages messages) {
        return future.exceptionally((Function)ErrorHandlingHelper.createAsyncExceptionHandler(logger, marker, operationName, player, messages));
    }
}

