/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerHelper {
    private PlayerHelper() {
    }

    public static String getPlayerIp(Player player) {
        if (player == null) {
            return "unknown";
        }
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress().getHostAddress();
        }
        return "unknown";
    }

    public static InetAddress getPlayerAddress(Player player) {
        if (player == null) {
            return null;
        }
        InetSocketAddress address = player.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress();
        }
        return null;
    }

    public static boolean isPlayer(CommandSource source) {
        return source instanceof Player;
    }

    public static UUID getPlayerUuid(Player player) {
        return player != null ? player.getUniqueId() : null;
    }

    public static String getPlayerUsername(Player player) {
        return player != null ? player.getUsername() : "unknown";
    }

    public static void sendErrorMessage(Player player, String message) {
        if (player != null && message != null) {
            player.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
        }
    }

    public static void sendSuccessMessage(Player player, String message) {
        if (player != null && message != null) {
            player.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        }
    }

    public static void sendWarningMessage(Player player, String message) {
        if (player != null && message != null) {
            player.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.YELLOW));
        }
    }

    public static void disconnectWithError(Player player, String reason) {
        if (player != null && reason != null) {
            player.disconnect((Component)Component.text((String)reason, (TextColor)NamedTextColor.RED));
        }
    }

    public static String createPlayerInfo(Player player) {
        if (player == null) {
            return "Player[null]";
        }
        return String.format("Player[%s/%s/%s]", player.getUsername(), PlayerHelper.getPlayerIp(player), player.getUniqueId());
    }
}

