/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.net.InetAddress;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.IPRateLimiter;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class SecurityHelper {
    private SecurityHelper() {
    }

    public static boolean checkRateLimit(IPRateLimiter ipRateLimiter, InetAddress playerAddress, Logger logger, Marker securityMarker, String playerName, String operationType) {
        if (playerAddress != null && ipRateLimiter.isRateLimited(playerAddress)) {
            String logMessage = String.format("[RATE_LIMIT] %s - %s zablokowany za rate limiting (%d pr\u00f3b w 5 min)", playerName, operationType, ipRateLimiter.getAttempts(playerAddress));
            logger.warn(securityMarker, logMessage);
            return true;
        }
        return false;
    }

    public static void incrementRateLimit(IPRateLimiter ipRateLimiter, InetAddress playerAddress) {
        if (playerAddress != null) {
            ipRateLimiter.incrementAttempts(playerAddress);
        }
    }

    public static boolean checkBruteForceBlock(AuthCache authCache, InetAddress playerAddress, Logger logger, Marker securityMarker, String operationType) {
        if (playerAddress != null && authCache.isBlocked(playerAddress)) {
            String logMessage = String.format("[BRUTE_FORCE_BLOCK] IP %s pr\u00f3bowa\u0142 %s", playerAddress.getHostAddress(), operationType);
            logger.warn(securityMarker, logMessage);
            return true;
        }
        return false;
    }

    public static boolean registerFailedLogin(AuthCache authCache, InetAddress playerAddress, Logger logger, Marker securityMarker, String playerName, String playerIp) {
        boolean blocked = false;
        if (playerAddress != null) {
            blocked = authCache.registerFailedLogin(playerAddress);
        }
        if (blocked) {
            String logMessage = String.format("[BRUTE_FORCE_BLOCKED] %s zablokowany za brute force z IP %s", playerName, playerIp);
            logger.warn(securityMarker, logMessage);
        } else {
            String logMessage = String.format("[FAILED_LOGIN] Nieudana pr\u00f3ba logowania gracza %s z IP %s", playerName, playerIp);
            logger.debug(logMessage);
        }
        return blocked;
    }

    public static void resetBruteForceAttempts(AuthCache authCache, InetAddress playerAddress) {
        if (playerAddress != null) {
            authCache.resetLoginAttempts(playerAddress);
        }
    }

    public static void logSuccessfulAuth(Logger logger, Marker authMarker, String playerName, String playerIp, String operationType) {
        String logMessage = String.format("[AUTH_SUCCESS] Gracz %s pomy\u015blnie %s z IP %s", playerName, operationType, playerIp);
        logger.info(authMarker, logMessage);
    }

    public static void logSecurityEvent(Logger logger, Marker securityMarker, String eventType, String playerName, String details) {
        String logMessage = String.format("[SECURITY] %s - %s: %s", eventType, playerName, details);
        logger.warn(securityMarker, logMessage);
    }

    public static SecurityCheckResult performSecurityChecks(SecurityContext context) {
        if (SecurityHelper.checkRateLimit(context.ipRateLimiter(), context.playerAddress(), context.logger(), context.securityMarker(), context.playerName(), context.operationType())) {
            return new SecurityCheckResult(false, "rate_limited", "Zablokowany za zbyt wiele pr\u00f3b");
        }
        if (SecurityHelper.checkBruteForceBlock(context.authCache(), context.playerAddress(), context.logger(), context.securityMarker(), context.operationType())) {
            return new SecurityCheckResult(false, "brute_force_blocked", "Zablokowany za brute force");
        }
        SecurityHelper.incrementRateLimit(context.ipRateLimiter(), context.playerAddress());
        return new SecurityCheckResult(true, "passed", "Wszystkie kontrole bezpiecze\u0144stwa zako\u0144czone sukcesem");
    }

    public record SecurityContext(IPRateLimiter ipRateLimiter, AuthCache authCache, InetAddress playerAddress, Logger logger, Marker securityMarker, String playerName, String operationType) {
    }

    public record SecurityCheckResult(boolean passed, String reason, String message) {
    }
}

