/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class VeloAuthErrorHandler {
    private VeloAuthErrorHandler() {
    }

    public static <T> CompletableFuture<DatabaseManager.DbResult<T>> handleDatabaseError(Throwable throwable, String operation, Logger logger, Marker marker, Messages messages, String context) {
        String errorMessage = String.format("Database operation failed during %s%s", operation, context != null && !context.isEmpty() ? " for " + context : "");
        if (marker != null) {
            logger.error(marker, "{}: {}", errorMessage, throwable.getMessage(), throwable);
        } else {
            logger.error("{}: {}", errorMessage, throwable.getMessage(), throwable);
        }
        String userMessage = messages != null ? messages.get("database.error.general", new Object[0]) : "Database error occurred. Please try again later.";
        return CompletableFuture.completedFuture(DatabaseManager.DbResult.databaseError(userMessage + ": " + throwable.getMessage()));
    }

    public static <T> CompletableFuture<DatabaseManager.DbResult<T>> handleDatabaseError(Throwable throwable, String operation, Logger logger, Messages messages) {
        return VeloAuthErrorHandler.handleDatabaseError(throwable, operation, logger, null, messages, null);
    }

    public static <T> CompletableFuture<DatabaseManager.DbResult<T>> handleDatabaseError(Throwable throwable, String operation, Logger logger, Messages messages, String context) {
        return VeloAuthErrorHandler.handleDatabaseError(throwable, operation, logger, null, messages, context);
    }

    public static String formatDatabaseError(String operation, String context) {
        if (context != null && !context.isEmpty()) {
            return String.format("Database error during %s for %s", operation, context);
        }
        return String.format("Database error during %s", operation);
    }

    public static boolean isCriticalDatabaseError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            SQLException sqlException = (SQLException)throwable;
            String message = sqlException.getMessage().toLowerCase();
            return message.contains("connection") || message.contains("timeout") || message.contains("network") || message.contains("communication") || VeloAuthErrorHandler.isConnectionErrorCode(sqlException.getErrorCode());
        }
        String message = throwable.getMessage().toLowerCase();
        return message.contains("connection") || message.contains("timeout") || message.contains("network") || message.contains("pool") || message.contains("datasource");
    }

    private static boolean isConnectionErrorCode(int errorCode) {
        return errorCode == 0 || errorCode == 8001 || errorCode == 8003 || errorCode == 8006 || errorCode == 8007 || errorCode == 17002 || errorCode == 17410 || errorCode == 12514 || errorCode == 12541 || errorCode == 12560;
    }

    public static void handleSecurityDatabaseError(Throwable throwable, String operation, Logger logger, Marker securityMarker, String context) {
        String errorMessage = String.format("Security database operation failed: %s%s", operation, context != null ? " for " + context : "");
        logger.error(securityMarker, "[SECURITY] {}: {}", errorMessage, throwable.getMessage(), throwable);
        if (VeloAuthErrorHandler.isCriticalDatabaseError(throwable)) {
            logger.error(securityMarker, "[CRITICAL] Database connectivity issue detected during security operation: {}", (Object)operation);
        }
    }
}

