/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.proxy.Player;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class VeloAuthValidator {
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("^.{3,100}$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$|^::1$|^::$");

    private VeloAuthValidator() {
    }

    public static boolean isValidUsername(String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (username.length() < 1 || username.length() > 16) {
            return false;
        }
        if (!USERNAME_PATTERN.matcher(username).matches()) {
            return false;
        }
        return !VeloAuthValidator.hasSuspiciousPatterns(username);
    }

    public static ValidationResult validatePassword(String password) {
        if (password == null) {
            return ValidationResult.invalid("Password cannot be null");
        }
        if (password.length() < 3) {
            return ValidationResult.invalid("Password must be at least 3 characters long");
        }
        if (password.length() > 100) {
            return ValidationResult.invalid("Password cannot exceed 100 characters");
        }
        if (!PASSWORD_PATTERN.matcher(password).matches()) {
            return ValidationResult.invalid("Password contains invalid characters");
        }
        if (VeloAuthValidator.isCommonWeakPassword(password)) {
            return ValidationResult.invalid("Password is too common. Please choose a stronger password");
        }
        return ValidationResult.valid();
    }

    public static ValidationResult validateIpAddress(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return ValidationResult.invalid("IP address cannot be null or empty");
        }
        if (IPV4_PATTERN.matcher(ipAddress).matches()) {
            return ValidationResult.valid();
        }
        if (IPV6_PATTERN.matcher(ipAddress).matches()) {
            return ValidationResult.valid();
        }
        return ValidationResult.invalid("Invalid IP address format");
    }

    public static boolean isValidInetAddress(InetAddress address) {
        if (address == null) {
            return false;
        }
        if (address.isLoopbackAddress()) {
            return true;
        }
        if (address.isAnyLocalAddress()) {
            return false;
        }
        if (address instanceof Inet6Address) {
            return true;
        }
        return true;
    }

    public static ValidationResult validatePlayer(Player player) {
        if (player == null) {
            return ValidationResult.invalid("Player cannot be null");
        }
        String username = player.getUsername();
        if (!VeloAuthValidator.isValidUsername(username)) {
            return ValidationResult.invalid("Invalid player username: " + username);
        }
        if (player.getUniqueId() == null) {
            return ValidationResult.invalid("Player UUID cannot be null");
        }
        return ValidationResult.valid();
    }

    public static Component createErrorMessage(ValidationResult validationResult, String inputType) {
        String message = validationResult.getErrorMessage();
        switch (inputType.toLowerCase()) {
            case "username": {
                if (!message.contains("invalid format")) break;
                return Component.text((String)"Nieprawid\u0142owy format nazwy u\u017cytkownika! U\u017cyj tylko liter, cyfr i podkre\u015blenia (max 16 znak\u00f3w).", (TextColor)NamedTextColor.RED);
            }
            case "password": {
                if (message.contains("at least 3 characters")) {
                    return Component.text((String)"Has\u0142o musi mie\u0107 co najmniej 3 znaki!", (TextColor)NamedTextColor.RED);
                }
                if (!message.contains("too common")) break;
                return Component.text((String)"Has\u0142o jest zbyt popularne. Wybierz silniejsze has\u0142o.", (TextColor)NamedTextColor.RED);
            }
        }
        return Component.text((String)("B\u0142\u0105d walidacji: " + message), (TextColor)NamedTextColor.RED);
    }

    public static void logValidationFailure(ValidationResult validationResult, String inputType, String context, Logger logger, Marker securityMarker) {
        logger.warn(securityMarker, "[SECURITY] Validation failed for {}: {} - Context: {}", inputType, validationResult.getErrorMessage(), context);
    }

    private static boolean hasSuspiciousPatterns(String username) {
        String lowerUsername = username.toLowerCase();
        if (lowerUsername.contains("drop") || lowerUsername.contains("delete") || lowerUsername.contains("insert") || lowerUsername.contains("update") || lowerUsername.contains("select") || lowerUsername.contains("'") || lowerUsername.contains("\"") || lowerUsername.contains(";")) {
            return true;
        }
        if (lowerUsername.contains("cmd") || lowerUsername.contains("powershell") || lowerUsername.contains("bash") || lowerUsername.contains("sh") || lowerUsername.contains("$") || lowerUsername.contains("`")) {
            return true;
        }
        return lowerUsername.contains("../") || lowerUsername.contains("..\\") || lowerUsername.contains("/") || lowerUsername.contains("\\");
    }

    private static boolean isCommonWeakPassword(String password) {
        String[] weakPasswords;
        String lowerPassword = password.toLowerCase();
        for (String weak : weakPasswords = new String[]{"123", "1234", "12345", "123456", "password", "qwerty", "abc", "test", "guest", "user", "admin", "root", "pass", "temp", "default", "login", "letmein"}) {
            if (!lowerPassword.equals(weak) && !lowerPassword.contains(weak)) continue;
            return true;
        }
        return false;
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String errorMessage;

        private ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public static ValidationResult valid() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult invalid(String errorMessage) {
            return new ValidationResult(false, errorMessage);
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

