/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.CommandHandler;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.connection.ConnectionManager;
import net.rafalohaki.veloauth.database.DatabaseConfig;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.database.DatabaseType;
import net.rafalohaki.veloauth.database.HikariConfigParams;
import net.rafalohaki.veloauth.exception.VeloAuthException;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.listener.AuthListener;
import net.rafalohaki.veloauth.listener.EarlyLoginBlocker;
import net.rafalohaki.veloauth.listener.PostLoginHandler;
import net.rafalohaki.veloauth.listener.PreLoginHandler;
import net.rafalohaki.veloauth.premium.PremiumResolverService;
import net.rafalohaki.veloauth.util.VirtualThreadExecutorProvider;
import org.slf4j.Logger;

@Plugin(id="veloauth", name="VeloAuth", version="1.0.1", description="Complete Velocity Authentication Plugin with BCrypt, Virtual Threads and multi-database support", authors={"Rafal"})
public class VeloAuth {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private Settings settings;
    private Messages messages;
    private DatabaseManager databaseManager;
    private AuthCache authCache;
    private CommandHandler commandHandler;
    private ConnectionManager connectionManager;
    private AuthListener authListener;
    private PremiumResolverService premiumResolverService;
    private volatile boolean initialized = false;

    @Inject
    public VeloAuth(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        if (logger.isDebugEnabled()) {
            logger.debug("VeloAuth konstruktor - Java {}, Velocity API {}", (Object)System.getProperty("java.version"), (Object)server.getVersion().getVersion());
        }
    }

    private boolean reloadLanguageFiles() {
        try {
            this.messages.reload();
            this.logger.info("Language files reloaded successfully");
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to reload language files", e);
            return false;
        }
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.logger.info("=== VeloAuth v1.0.0 - Initialization ===");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Java: {}, Virtual Threads: {}", (Object)System.getProperty("java.version"), (Object)(Thread.currentThread().isVirtual() ? "Available" : "Unavailable"));
        }
        this.logger.info("Registering early PreLogin blocker for initialization protection...");
        try {
            EarlyLoginBlocker earlyBlocker = new EarlyLoginBlocker(this);
            this.server.getEventManager().register((Object)this, (Object)earlyBlocker);
            this.logger.info("\u2705 EarlyLoginBlocker registered BEFORE initialization - PreLogin protection active");
        }
        catch (Exception e) {
            this.logger.error("Failed to register early PreLogin blocker", e);
            return;
        }
        long initializationStartTime = System.currentTimeMillis();
        this.logger.info("\ud83d\ude80 Starting VeloAuth initialization at {} (initialized flag: {})", (Object)new Date(initializationStartTime), (Object)this.initialized);
        CompletableFuture.runAsync(this::initializePlugin, VirtualThreadExecutorProvider.getVirtualExecutor()).whenComplete((result, throwable) -> {
            long initializationDuration = System.currentTimeMillis() - initializationStartTime;
            if (throwable != null) {
                this.logger.error("\u274c VeloAuth initialization FAILED after {} ms", (Object)initializationDuration, throwable);
                this.logger.warn("\u26a0\ufe0f Initialization flag remains FALSE - all player connections will be blocked");
                this.shutdown();
            } else {
                if (this.databaseManager != null) {
                    this.databaseManager.clearCache();
                    this.logger.info("Cleared stale database cache entries");
                }
                if (this.authCache != null) {
                    this.authCache.clearAll();
                    this.logger.info("Cleared stale authentication cache entries");
                }
                this.initialized = true;
                this.logger.info("\u2705 VeloAuth initialization completed successfully in {} ms", (Object)initializationDuration);
                this.logger.info("\ud83d\udfe2 Initialization flag set to TRUE - player connections now allowed");
                this.logger.info(this.messages.get("plugin.initialization.ready", new Object[0]));
                this.logStartupInfo();
            }
        });
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("plugin.initialization.shutdown", new Object[0]));
        }
        this.shutdown();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("plugin.initialization.closed", new Object[0]));
        }
    }

    private void initializePlugin() {
        try {
            this.initializeConfiguration();
            this.initializeMessages();
            this.initializeDatabase();
            this.initializeCache();
            this.initializeCommands();
            this.initializeConnectionManager();
            this.initializePremiumResolver();
            this.initializeListeners();
            this.debugServers();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.messages.get("plugin.initialization.components_ready", new Object[0]));
            }
        }
        catch (IllegalStateException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Critical state error during VeloAuth initialization", e);
            }
            throw VeloAuthException.configuration("plugin initialization", e);
        }
        catch (IllegalArgumentException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Critical argument error during VeloAuth initialization", e);
            }
            throw VeloAuthException.configuration("invalid arguments", e);
        }
        catch (VeloAuthException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("VeloAuth error during initialization", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unexpected error during VeloAuth initialization", e);
            }
            throw VeloAuthException.configuration("unexpected error", e);
        }
    }

    private void initializeConfiguration() {
        this.logger.info("\ud83d\udccb [1/8] Loading configuration...");
        long startTime = System.currentTimeMillis();
        this.settings = new Settings(this.dataDirectory);
        if (!this.settings.load()) {
            throw VeloAuthException.configuration("settings loading", null);
        }
        this.logger.info("\u2705 Configuration loaded in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void initializeMessages() {
        this.logger.info("\ud83d\udcac [2/8] Initializing message system...");
        long startTime = System.currentTimeMillis();
        String language = this.settings.getLanguage();
        try {
            this.messages = new Messages(this.dataDirectory, language);
            this.logger.info("\u2705 Message system initialized in {} ms (Language: {}, External files: enabled)", (Object)(System.currentTimeMillis() - startTime), (Object)language);
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize external language files, falling back to JAR-embedded files", e);
            this.messages = new Messages();
            this.messages.setLanguage(language);
            this.logger.info("\u2705 Message system initialized in {} ms (Language: {}, External files: disabled)", (Object)(System.currentTimeMillis() - startTime), (Object)language);
        }
    }

    private void initializeDatabase() {
        this.logger.info("\ud83d\uddc4\ufe0f [3/8] Initializing database connection...");
        long startTime = System.currentTimeMillis();
        DatabaseConfig dbConfig = this.createDatabaseConfig();
        this.databaseManager = new DatabaseManager(dbConfig, this.messages);
        boolean dbInitialized = this.databaseManager.initialize().join();
        if (!dbInitialized) {
            throw VeloAuthException.database("initialization", null);
        }
        this.logger.info("\u2705 Database initialized in {} ms (Type: {})", (Object)(System.currentTimeMillis() - startTime), (Object)this.settings.getDatabaseStorageType());
    }

    private void initializeCache() {
        this.logger.info("\ud83d\udcbe [4/8] Initializing authentication cache...");
        long startTime = System.currentTimeMillis();
        this.authCache = new AuthCache(this.settings.getCacheTtlMinutes(), this.settings.getCacheMaxSize(), this.settings.getCacheMaxSize(), 10000, this.settings.getBruteForceMaxAttempts(), this.settings.getBruteForceTimeoutMinutes(), this.settings.getCacheCleanupIntervalMinutes(), this.settings, this.messages);
        if (this.databaseManager != null) {
            this.databaseManager.setAuthCacheReference(this.authCache);
            this.logger.debug("AuthCache reference set in DatabaseManager");
        }
        this.logger.info("\u2705 Cache initialized in {} ms (TTL: {} min, Max size: {}, Premium cache: 10000)", System.currentTimeMillis() - startTime, this.settings.getCacheTtlMinutes(), this.settings.getCacheMaxSize());
    }

    private void initializeCommands() {
        this.logger.info("\u2328\ufe0f [5/8] Registering commands...");
        long startTime = System.currentTimeMillis();
        this.commandHandler = new CommandHandler(this, this.databaseManager, this.authCache, this.settings, this.messages);
        this.commandHandler.registerCommands();
        this.logger.info("\u2705 Commands registered in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void initializeConnectionManager() {
        this.logger.info("\ud83d\udd0c [6/8] Initializing connection manager...");
        long startTime = System.currentTimeMillis();
        this.connectionManager = new ConnectionManager(this, this.databaseManager, this.authCache, this.settings, this.messages);
        this.logger.info("\u2705 Connection manager initialized in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void initializePremiumResolver() {
        this.logger.info("\ud83d\udc51 [7/8] Initializing premium resolver service...");
        long startTime = System.currentTimeMillis();
        this.premiumResolverService = new PremiumResolverService(this.logger, this.settings, this.databaseManager.getPremiumUuidDao());
        this.logger.info("\u2705 Premium resolver initialized in {} ms (Enabled: {})", (Object)(System.currentTimeMillis() - startTime), (Object)this.settings.isPremiumCheckEnabled());
    }

    private void initializeListeners() {
        this.logger.info("\ud83c\udfa7 [8/8] Registering event listeners...");
        long startTime = System.currentTimeMillis();
        PreLoginHandler preLoginHandler = new PreLoginHandler(this.authCache, this.premiumResolverService, this.databaseManager, this.messages, this.logger);
        this.logger.debug("PreLoginHandler created successfully");
        PostLoginHandler postLoginHandler = new PostLoginHandler(this, this.authCache, this.connectionManager, this.databaseManager, this.messages, this.logger);
        this.logger.debug("PostLoginHandler created successfully");
        this.authListener = new AuthListener(this, this.authCache, this.settings, preLoginHandler, postLoginHandler, this.databaseManager, this.messages);
        this.server.getEventManager().register((Object)this, (Object)this.authListener);
        this.logger.info("\u2705 Event listeners registered in {} ms (PreLoginHandler + PostLoginHandler + AuthListener)", (Object)(System.currentTimeMillis() - startTime));
    }

    private void debugServers() {
        this.connectionManager.debugServers();
    }

    private void waitForPendingOperations() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Component shutdown in progress - pending operations handled internally");
        }
    }

    private DatabaseConfig createDatabaseConfig() {
        String storageType = this.settings.getDatabaseStorageType();
        DatabaseType dbType = DatabaseType.fromName(storageType);
        if (dbType != null && dbType.isLocalDatabase()) {
            return DatabaseConfig.forLocalDatabase(storageType, this.settings.getDatabaseName());
        }
        return DatabaseConfig.forRemoteWithHikari(HikariConfigParams.builder().storageType(storageType).hostname(this.settings.getDatabaseHostname()).port(this.settings.getDatabasePort()).database(this.settings.getDatabaseName()).user(this.settings.getDatabaseUser()).password(this.settings.getDatabasePassword()).connectionPoolSize(this.settings.getDatabaseConnectionPoolSize()).maxLifetime((int)this.settings.getDatabaseMaxLifetimeMillis()).connectionParameters(this.settings.getDatabaseConnectionParameters()).postgreSQLSettings(this.settings.getPostgreSQLSettings()).debugEnabled(this.settings.isDebugEnabled()).build());
    }

    private void shutdown() {
        this.initialized = false;
        this.logger.info("\ud83d\udd34 Initialization flag set to FALSE - blocking all new player connections");
        try {
            this.logger.info("Inicjowanie graceful shutdown VeloAuth...");
            if (this.authListener != null) {
                this.server.getEventManager().unregisterListener((Object)this, (Object)this.authListener);
                this.logger.debug("AuthListener wyrejestrowany");
            }
            if (this.commandHandler != null) {
                this.commandHandler.unregisterCommands();
                this.logger.debug("Komendy wyrejestrowane");
            }
            this.waitForPendingOperations();
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.logger.debug("ConnectionManager zamkni\u0119ty");
            }
            if (this.authCache != null) {
                this.authCache.shutdown();
                this.logger.debug("AuthCache zamkni\u0119ty");
            }
            if (this.databaseManager != null) {
                this.databaseManager.shutdown();
                this.logger.debug("DatabaseManager zamkni\u0119ty");
            }
            VirtualThreadExecutorProvider.shutdown();
            this.logger.debug("VirtualThreadExecutorProvider zamkni\u0119ty");
            this.logger.info("VeloAuth shutdown completed successfully");
        }
        catch (IllegalStateException e) {
            this.logger.error("B\u0142\u0105d stanu podczas graceful shutdown", e);
        }
    }

    private void logStartupInfo() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("config.display.header", new Object[0]));
            String dbStatus = this.databaseManager.isConnected() ? this.messages.get("database.connected", new Object[0]) : this.messages.get("database.disconnected", new Object[0]);
            String premiumStatus = this.settings.isPremiumCheckEnabled() ? this.messages.get("premium.check_enabled", new Object[0]) : this.messages.get("premium.check_disabled", new Object[0]);
            AuthCache.CacheStats stats = this.authCache.getStats();
            this.logger.info(this.messages.get("config.display.database", new Object[0]), (Object)this.settings.getDatabaseStorageType(), (Object)dbStatus);
            this.logger.info(this.messages.get("config.display.cache_ttl", new Object[0]), (Object)this.settings.getCacheTtlMinutes());
            this.logger.info(this.messages.get("config.display.cache_max_size", new Object[0]), (Object)this.settings.getCacheMaxSize());
            this.logger.info(this.messages.get("config.display.brute_force", new Object[0]), (Object)this.settings.getBruteForceMaxAttempts(), (Object)this.settings.getBruteForceTimeoutMinutes());
            this.logger.info(this.messages.get("config.display.picolimbo_server", new Object[0]), (Object)this.settings.getPicoLimboServerName());
            this.logger.info(this.messages.get("config.display.bcrypt_cost", new Object[0]), (Object)this.settings.getBcryptCost());
            this.logger.info(this.messages.get("config.display.premium_check", new Object[0]), (Object)premiumStatus);
            this.logger.info(this.messages.get("config.display.cache_stats", new Object[0]), stats.authorizedPlayersCount(), stats.bruteForceEntriesCount(), stats.premiumCacheCount());
        }
    }

    public boolean reloadConfig() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.messages.get("config.reloading", new Object[0]));
            }
            boolean configReloaded = this.settings.load();
            boolean languageReloaded = this.reloadLanguageFiles();
            if (configReloaded) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.messages.get("config.reloaded_success", new Object[0]));
                }
                this.logStartupInfo();
                return languageReloaded;
            }
            if (this.logger.isErrorEnabled()) {
                this.logger.error(this.messages.get("config.reload_failed", new Object[0]));
            }
            return false;
        }
        catch (IllegalStateException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("B\u0142\u0105d stanu podczas prze\u0142adowywania konfiguracji", e);
            }
            return false;
        }
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AuthCache getAuthCache() {
        return this.authCache;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getVersion() {
        return "1.0.1";
    }
}

