/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.CommandHelper;
import net.rafalohaki.veloauth.command.IPRateLimiter;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.i18n.SimpleMessages;
import net.rafalohaki.veloauth.libs.bcrypt.bcrypt.BCrypt;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import net.rafalohaki.veloauth.util.DatabaseErrorHandler;
import net.rafalohaki.veloauth.util.PlayerAddressUtils;
import net.rafalohaki.veloauth.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandHandler {
    private static final String COMMAND_LOGIN = "login";
    private static final String COMMAND_REGISTER = "register";
    private static final String COMMAND_CHANGE_PASSWORD = "changepassword";
    private static final String COMMAND_UNREGISTER = "unregister";
    private static final String COMMAND_VAUTH = "vauth";
    private static final String ERROR_DATABASE_QUERY = "error.database.query";
    private static final String CONFLICT_PREFIX = "   \u00a77";
    private static final Marker AUTH_MARKER = MarkerFactory.getMarker("AUTH");
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");
    private static final Marker DB_MARKER = MarkerFactory.getMarker("DATABASE");
    private final VeloAuth plugin;
    private final DatabaseManager databaseManager;
    private final AuthCache authCache;
    private final Settings settings;
    private final Messages messages;
    private final Logger logger;
    private final SimpleMessages sm;
    private final IPRateLimiter ipRateLimiter;

    public CommandHandler(VeloAuth plugin, DatabaseManager databaseManager, AuthCache authCache, Settings settings, Messages messages) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.authCache = authCache;
        this.settings = settings;
        this.messages = messages;
        this.logger = plugin.getLogger();
        this.ipRateLimiter = new IPRateLimiter(10, 5);
        this.sm = new SimpleMessages(messages);
    }

    public void registerCommands() {
        CommandManager commandManager = this.plugin.getServer().getCommandManager();
        commandManager.register(commandManager.metaBuilder(COMMAND_LOGIN).aliases(new String[]{"log", "l"}).build(), (Command)new LoginCommand());
        commandManager.register(commandManager.metaBuilder(COMMAND_REGISTER).aliases(new String[]{"reg", "r"}).build(), (Command)new RegisterCommand());
        commandManager.register(commandManager.metaBuilder(COMMAND_CHANGE_PASSWORD).build(), (Command)new ChangePasswordCommand());
        commandManager.register(commandManager.metaBuilder(COMMAND_UNREGISTER).build(), (Command)new UnregisterCommand());
        commandManager.register(commandManager.metaBuilder(COMMAND_VAUTH).build(), (Command)new VAuthCommand());
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("connection.commands.registered", new Object[0]));
        }
    }

    public void unregisterCommands() {
        CommandManager commandManager = this.plugin.getServer().getCommandManager();
        commandManager.unregister(COMMAND_LOGIN);
        commandManager.unregister(COMMAND_REGISTER);
        commandManager.unregister(COMMAND_CHANGE_PASSWORD);
        commandManager.unregister(COMMAND_UNREGISTER);
        commandManager.unregister(COMMAND_VAUTH);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Komendy wyrejestrowane");
        }
    }

    private AuthenticationContext validateAndAuthenticatePlayer(CommandSource source, String commandName) {
        Player player = CommandHelper.validatePlayerSource(source, this.messages);
        if (player == null) {
            return null;
        }
        InetAddress playerAddress = PlayerAddressUtils.getPlayerAddress(player);
        if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
            player.sendMessage(ValidationUtils.createErrorComponent(this.messages.get("security.brute_force.blocked", new Object[0])));
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(SECURITY_MARKER, "[BRUTE FORCE BLOCK] IP {} attempted {}", (Object)playerAddress.getHostAddress(), (Object)commandName);
            }
            return null;
        }
        String username = player.getUsername();
        DatabaseManager.DbResult<RegisteredPlayer> dbResult = this.databaseManager.findPlayerByNickname(username).join();
        if (this.handleDatabaseError(dbResult, player, commandName + " lookup for")) {
            return null;
        }
        RegisteredPlayer registeredPlayer = dbResult.getValue();
        return new AuthenticationContext(player, username, playerAddress, registeredPlayer);
    }

    private DatabaseManager.DbResult<Boolean> checkPremiumStatus(Player player, String operation) {
        DatabaseManager.DbResult<Boolean> result = this.databaseManager.isPremium(player.getUsername()).join();
        if (result.isDatabaseError()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} failed for {}: {}", operation, player.getUsername(), result.getErrorMessage());
            }
            player.sendMessage(this.sm.errorDatabase());
        }
        return result;
    }

    private boolean handleDatabaseError(DatabaseManager.DbResult<?> result, Player player, String operation) {
        return DatabaseErrorHandler.handleError(result, player, operation, this.logger, this.messages);
    }

    private void sendDatabaseErrorMessage(Player player) {
        player.sendMessage(ValidationUtils.createErrorComponent(this.messages.get(ERROR_DATABASE_QUERY, new Object[0])));
    }

    private class LoginCommand
    implements SimpleCommand {
        private LoginCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (args.length != 1) {
                source.sendMessage(CommandHandler.this.sm.usageLogin());
                return;
            }
            String password = args[0];
            CommandHelper.runAsyncCommand(() -> this.processLogin(source, password), CommandHandler.this.messages, source, CommandHandler.ERROR_DATABASE_QUERY);
        }

        private void processLogin(CommandSource source, String password) {
            Player player = (Player)source;
            AuthenticationContext authContext = CommandHandler.this.validateAndAuthenticatePlayer(source, CommandHandler.COMMAND_LOGIN);
            if (authContext == null) {
                return;
            }
            if (CommandHandler.this.authCache.isPlayerAuthorized(player.getUniqueId(), PlayerAddressUtils.getPlayerIp(player))) {
                player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.login.already_logged_in", new Object[0])));
                return;
            }
            BCrypt.Result result = BCrypt.verifyer().verify(password.toCharArray(), authContext.registeredPlayer.getHash());
            if (result.verified) {
                this.handleSuccessfulLogin(authContext);
            } else {
                this.handleFailedLogin(authContext);
            }
        }

        private void handleSuccessfulLogin(AuthenticationContext authContext) {
            try {
                authContext.registeredPlayer.updateLoginData(PlayerAddressUtils.getPlayerIp(authContext.player));
                DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(authContext.registeredPlayer).join();
                if (CommandHandler.this.handleDatabaseError(saveResult, authContext.player, "Failed to save login data for")) {
                    return;
                }
                DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(authContext.player, "Premium status check during login");
                if (premiumResult.isDatabaseError()) {
                    return;
                }
                boolean isPremium = Boolean.TRUE.equals(premiumResult.getValue());
                CachedAuthUser cachedUser = CachedAuthUser.fromRegisteredPlayer(authContext.registeredPlayer, isPremium);
                CommandHandler.this.authCache.addAuthorizedPlayer(authContext.player.getUniqueId(), cachedUser);
                CommandHandler.this.authCache.startSession(authContext.player.getUniqueId(), authContext.username, PlayerAddressUtils.getPlayerIp(authContext.player));
                this.resetSecurityCounters(authContext.playerAddress);
                authContext.player.sendMessage(CommandHandler.this.sm.loginSuccess());
                if (CommandHandler.this.logger.isInfoEnabled()) {
                    CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zalogowa\u0142 si\u0119 pomy\u015blnie z IP {} - sesja rozpocz\u0119ta", (Object)authContext.username, (Object)PlayerAddressUtils.getPlayerIp(authContext.player));
                }
                CommandHandler.this.plugin.getConnectionManager().transferToBackend(authContext.player);
            }
            catch (Exception e) {
                if (CommandHandler.this.logger.isErrorEnabled()) {
                    CommandHandler.this.logger.error("B\u0142\u0105d podczas przetwarzania udanego logowania: {}", (Object)authContext.username, (Object)e);
                }
                CommandHandler.this.sendDatabaseErrorMessage(authContext.player);
            }
        }

        private void handleFailedLogin(AuthenticationContext authContext) {
            boolean blocked = SecurityUtils.registerFailedLogin(authContext.playerAddress, CommandHandler.this.authCache);
            if (blocked) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("security.brute_force.blocked", new Object[0])));
                if (CommandHandler.this.logger.isWarnEnabled()) {
                    CommandHandler.this.logger.warn("Gracz {} zablokowany za brute force z IP {}", (Object)authContext.username, (Object)PlayerAddressUtils.getPlayerIp(authContext.player));
                }
            } else {
                authContext.player.sendMessage(CommandHandler.this.sm.loginFailed());
                if (CommandHandler.this.logger.isDebugEnabled()) {
                    CommandHandler.this.logger.debug("Nieudana pr\u00f3ba logowania gracza {} z IP {}", (Object)authContext.username, (Object)PlayerAddressUtils.getPlayerIp(authContext.player));
                }
            }
        }

        private void resetSecurityCounters(InetAddress playerAddress) {
            SecurityUtils.resetSecurityCounters(playerAddress, CommandHandler.this.authCache, CommandHandler.this.ipRateLimiter);
        }
    }

    private class RegisterCommand
    implements SimpleCommand {
        private RegisterCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            Player player = CommandHelper.validatePlayerSource(source, CommandHandler.this.messages);
            if (player == null) {
                return;
            }
            ValidationUtils.ValidationResult validationResult = ValidationUtils.validateArgumentCount(args, 2, CommandHandler.this.messages.get("auth.register.usage", new Object[0]));
            if (!validationResult.valid()) {
                player.sendMessage(ValidationUtils.createWarningComponent(validationResult.getErrorMessage()));
                return;
            }
            String password = args[0];
            String confirmPassword = args[1];
            ValidationUtils.ValidationResult passwordValidation = ValidationUtils.validatePassword(password, CommandHandler.this.settings);
            if (!passwordValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(passwordValidation.getErrorMessage()));
                return;
            }
            ValidationUtils.ValidationResult matchValidation = ValidationUtils.validatePasswordMatch(password, confirmPassword);
            if (!matchValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(matchValidation.getErrorMessage()));
                return;
            }
            CommandHelper.runAsyncCommandWithTimeout(() -> this.processRegistration(player, password), CommandHandler.this.messages, source, CommandHandler.ERROR_DATABASE_QUERY, "auth.registration.timeout");
        }

        private void processRegistration(Player player, String password) {
            AuthenticationContext authContext = CommandHandler.this.validateAndAuthenticatePlayer((CommandSource)player, "registration");
            if (authContext == null) {
                return;
            }
            if (authContext.registeredPlayer != null) {
                authContext.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.register.already_registered", new Object[0])));
                return;
            }
            String hashedPassword = BCrypt.with(BCrypt.Version.VERSION_2Y).hashToString(CommandHandler.this.settings.getBcryptCost(), password.toCharArray());
            RegisteredPlayer newPlayer = new RegisteredPlayer(authContext.username, hashedPassword, PlayerAddressUtils.getPlayerIp(authContext.player), authContext.player.getUniqueId().toString());
            DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(newPlayer).join();
            if (CommandHandler.this.handleDatabaseError(saveResult, authContext.player, "Failed to save new player")) {
                return;
            }
            boolean saved = Boolean.TRUE.equals(saveResult.getValue());
            if (!saved) {
                CommandHandler.this.sendDatabaseErrorMessage(authContext.player);
                return;
            }
            DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(authContext.player, "Premium status check during registration");
            if (premiumResult.isDatabaseError()) {
                return;
            }
            boolean isPremium = Boolean.TRUE.equals(premiumResult.getValue());
            CachedAuthUser cachedUser = CachedAuthUser.fromRegisteredPlayer(newPlayer, isPremium);
            CommandHandler.this.authCache.addAuthorizedPlayer(authContext.player.getUniqueId(), cachedUser);
            CommandHandler.this.authCache.startSession(authContext.player.getUniqueId(), authContext.username, PlayerAddressUtils.getPlayerIp(authContext.player));
            this.resetSecurityCounters(authContext.playerAddress);
            authContext.player.sendMessage(CommandHandler.this.sm.registerSuccess());
            if (CommandHandler.this.logger.isInfoEnabled()) {
                CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zarejestrowany pomy\u015blnie z IP {}", (Object)authContext.username, (Object)PlayerAddressUtils.getPlayerIp(authContext.player));
            }
            CommandHandler.this.plugin.getConnectionManager().transferToBackend(authContext.player);
        }

        private void resetSecurityCounters(InetAddress playerAddress) {
            SecurityUtils.resetSecurityCounters(playerAddress, CommandHandler.this.authCache, CommandHandler.this.ipRateLimiter);
        }
    }

    private class ChangePasswordCommand
    implements SimpleCommand {
        private ChangePasswordCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            Player player = CommandHelper.validatePlayerSource(source, CommandHandler.this.messages);
            if (player == null) {
                return;
            }
            ValidationUtils.ValidationResult validationResult = ValidationUtils.validateArgumentCount(args, 2, CommandHandler.this.messages.get("auth.changepassword.usage", new Object[0]));
            if (!validationResult.valid()) {
                player.sendMessage(ValidationUtils.createWarningComponent(validationResult.getErrorMessage()));
                return;
            }
            String oldPassword = args[0];
            String newPassword = args[1];
            ValidationUtils.ValidationResult passwordValidation = ValidationUtils.validatePassword(newPassword, CommandHandler.this.settings);
            if (!passwordValidation.valid()) {
                player.sendMessage(ValidationUtils.createErrorComponent(passwordValidation.getErrorMessage()));
                return;
            }
            CommandHelper.runAsyncCommand(() -> this.processPasswordChange(player, oldPassword, newPassword), CommandHandler.this.messages, source, CommandHandler.ERROR_DATABASE_QUERY);
        }

        private void processPasswordChange(Player player, String oldPassword, String newPassword) {
            AuthenticationContext ctx = this.preparePasswordChange(player);
            if (ctx == null) {
                return;
            }
            if (!this.checkOldPassword(ctx, oldPassword)) {
                return;
            }
            if (!this.updatePassword(ctx, newPassword)) {
                return;
            }
            this.finalizePasswordChange(ctx);
        }

        private AuthenticationContext preparePasswordChange(Player player) {
            AuthenticationContext ctx = CommandHandler.this.validateAndAuthenticatePlayer((CommandSource)player, "password change");
            if (ctx == null) {
                return null;
            }
            if (ctx.registeredPlayer == null) {
                ctx.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.login.not_registered", new Object[0])));
                return null;
            }
            return ctx;
        }

        private boolean checkOldPassword(AuthenticationContext ctx, String oldPassword) {
            BCrypt.Result result = BCrypt.verifyer().verify(oldPassword.toCharArray(), ctx.registeredPlayer.getHash());
            if (!result.verified) {
                ctx.player.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("auth.changepassword.incorrect_old_password", new Object[0])));
                return false;
            }
            return true;
        }

        private boolean updatePassword(AuthenticationContext ctx, String newPassword) {
            String newHashedPassword = BCrypt.with(BCrypt.Version.VERSION_2Y).hashToString(CommandHandler.this.settings.getBcryptCost(), newPassword.toCharArray());
            ctx.registeredPlayer.setHash(newHashedPassword);
            DatabaseManager.DbResult<Boolean> saveResult = CommandHandler.this.databaseManager.savePlayer(ctx.registeredPlayer).join();
            if (CommandHandler.this.handleDatabaseError(saveResult, ctx.player, "Password change save failed for")) {
                return false;
            }
            boolean saved = Boolean.TRUE.equals(saveResult.getValue());
            if (!saved) {
                CommandHandler.this.sendDatabaseErrorMessage(ctx.player);
                return false;
            }
            return true;
        }

        private void finalizePasswordChange(AuthenticationContext ctx) {
            DatabaseManager.DbResult<Boolean> premiumResult = CommandHandler.this.checkPremiumStatus(ctx.player, "Premium check during password change");
            if (!premiumResult.isDatabaseError() && Boolean.TRUE.equals(premiumResult.getValue())) {
                CommandHandler.this.authCache.removePremiumPlayer(ctx.username);
            }
            CommandHandler.this.authCache.endSession(ctx.player.getUniqueId());
            CommandHandler.this.plugin.getServer().getAllPlayers().stream().filter(p -> !p.equals((Object)ctx.player)).filter(p -> p.getUsername().equalsIgnoreCase(ctx.username)).forEach(p -> {
                p.disconnect(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("general.kick.message", new Object[0])));
                if (CommandHandler.this.logger.isWarnEnabled()) {
                    CommandHandler.this.logger.warn("Roz\u0142\u0105czono duplikat gracza {} - zmiana has\u0142a z IP {}", (Object)ctx.username, (Object)PlayerAddressUtils.getPlayerIp(ctx.player));
                }
            });
            ctx.player.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("auth.changepassword.success", new Object[0])));
            if (CommandHandler.this.logger.isInfoEnabled()) {
                CommandHandler.this.logger.info(AUTH_MARKER, "Gracz {} zmieni\u0142 has\u0142o z IP {}", (Object)ctx.username, (Object)PlayerAddressUtils.getPlayerIp(ctx.player));
            }
        }
    }

    private class UnregisterCommand
    implements SimpleCommand {
        private UnregisterCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (!CommandHelper.checkAdminPermission(source, CommandHandler.this.messages)) {
                return;
            }
            if (args.length != 1) {
                CommandHelper.sendError(source, CommandHandler.this.messages, "admin.unregister.usage");
                return;
            }
            String nickname = args[0];
            CommandHelper.runAsyncCommand(() -> this.processAdminUnregistration(source, nickname), CommandHandler.this.messages, source, CommandHandler.ERROR_DATABASE_QUERY);
        }

        private void processAdminUnregistration(CommandSource source, String nickname) {
            try {
                DatabaseManager.DbResult<RegisteredPlayer> dbResult = CommandHandler.this.databaseManager.findPlayerByNickname(nickname).join();
                if (this.handleDatabaseError(dbResult, source, nickname, "Admin unregistration failed for")) {
                    return;
                }
                RegisteredPlayer registeredPlayer = dbResult.getValue();
                if (registeredPlayer == null) {
                    source.sendMessage(ValidationUtils.createErrorComponent("Gracz " + nickname + " nie zosta\u0142 znaleziony w bazie danych!"));
                    return;
                }
                UUID playerUuid = this.parsePlayerUuid(registeredPlayer, nickname, source);
                if (playerUuid == null) {
                    return;
                }
                DatabaseManager.DbResult<Boolean> deleteResult = CommandHandler.this.databaseManager.deletePlayer(nickname).join();
                if (this.handleDatabaseError(deleteResult, source, nickname, "Admin unregistration delete failed for")) {
                    return;
                }
                boolean deleted = Boolean.TRUE.equals(deleteResult.getValue());
                if (deleted) {
                    String string;
                    CommandHandler.this.authCache.removeAuthorizedPlayer(playerUuid);
                    CommandHandler.this.authCache.endSession(playerUuid);
                    CommandHandler.this.authCache.removePremiumPlayer(nickname);
                    CommandHandler.this.plugin.getServer().getPlayer(nickname).ifPresent(player -> {
                        player.disconnect(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("general.kick.message", new Object[0])));
                        CommandHandler.this.logger.info("Roz\u0142\u0105czono gracza {} - usuni\u0119cie konta przez admina", (Object)nickname);
                    });
                    CommandHelper.sendSuccess(source, "Konto gracza " + nickname + " zosta\u0142o usuni\u0119te!");
                    if (source instanceof Player) {
                        Player player2 = (Player)source;
                        string = player2.getUsername();
                    } else {
                        string = "CONSOLE";
                    }
                    String adminName = string;
                    CommandHandler.this.logger.info(AUTH_MARKER, "Administrator {} usun\u0105\u0142 konto gracza {}", (Object)adminName, (Object)nickname);
                } else {
                    CommandHelper.sendError(source, CommandHandler.this.messages, CommandHandler.ERROR_DATABASE_QUERY);
                    CommandHandler.this.logger.error(DB_MARKER, "Nie uda\u0142o si\u0119 usun\u0105\u0107 konta gracza {} przez admina", (Object)nickname);
                }
            }
            catch (Exception e) {
                CommandHandler.this.logger.error(DB_MARKER, "B\u0142\u0105d podczas admin-usuwania konta gracza: {}", (Object)nickname, (Object)e);
                CommandHelper.sendError(source, CommandHandler.this.messages, CommandHandler.ERROR_DATABASE_QUERY);
            }
        }

        private boolean handleDatabaseError(DatabaseManager.DbResult<?> result, CommandSource source, String nickname, String operation) {
            return DatabaseErrorHandler.handleError(result, source, nickname, operation, CommandHandler.this.logger, CommandHandler.this.messages);
        }

        private UUID parsePlayerUuid(RegisteredPlayer registeredPlayer, String nickname, CommandSource source) {
            try {
                return UUID.fromString(registeredPlayer.getUuid());
            }
            catch (IllegalArgumentException e) {
                CommandHandler.this.logger.warn("Nieprawid\u0142owy UUID dla gracza {}: {}", (Object)nickname, (Object)registeredPlayer.getUuid());
                source.sendMessage(ValidationUtils.createErrorComponent("B\u0142\u0105d: nieprawid\u0142owy UUID gracza!"));
                return null;
            }
        }
    }

    private class VAuthCommand
    implements SimpleCommand {
        private VAuthCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            String subcommand;
            CommandSource source = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (!CommandHelper.checkAdminPermission(source, CommandHandler.this.messages)) {
                return;
            }
            if (args.length == 0) {
                this.sendAdminHelp(source);
                return;
            }
            switch (subcommand = args[0].toLowerCase()) {
                case "reload": {
                    this.handleReloadCommand(source);
                    break;
                }
                case "cache-reset": {
                    this.handleCacheResetCommand(source, args);
                    break;
                }
                case "stats": {
                    this.handleStatsCommand(source);
                    break;
                }
                case "conflicts": {
                    this.handleConflictsCommand(source);
                    break;
                }
                default: {
                    source.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("admin.reload.failed", new Object[0])));
                }
            }
        }

        private void handleReloadCommand(CommandSource source) {
            boolean success = CommandHandler.this.plugin.reloadConfig();
            if (success) {
                source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.reload.success", new Object[0])));
            } else {
                source.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("admin.reload.failed", new Object[0])));
            }
        }

        private void handleConflictsCommand(CommandSource source) {
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.header", new Object[0])));
            CompletableFuture<List<RegisteredPlayer>> conflictsFuture = CommandHandler.this.databaseManager.findPlayersInConflictMode();
            List<RegisteredPlayer> conflicts = conflictsFuture.join();
            if (conflicts.isEmpty()) {
                source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.conflicts.none", new Object[0])));
                return;
            }
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.found", conflicts.size())));
            for (int i = 0; i < conflicts.size(); ++i) {
                boolean isPremium;
                RegisteredPlayer conflict = conflicts.get(i);
                StringBuilder conflictInfo = new StringBuilder();
                conflictInfo.append("\u00a7e").append(i + 1).append(". \u00a7f").append(conflict.getNickname()).append("\n");
                conflictInfo.append(CommandHandler.CONFLICT_PREFIX).append("UUID: \u00a7f").append(conflict.getUuid()).append("\n");
                conflictInfo.append(CommandHandler.CONFLICT_PREFIX).append("IP: \u00a7f").append(conflict.getIp()).append("\n");
                long conflictTime = conflict.getConflictTimestamp();
                if (conflictTime > 0L) {
                    long hoursAgo = (System.currentTimeMillis() - conflictTime) / 3600000L;
                    conflictInfo.append(CommandHandler.CONFLICT_PREFIX).append(CommandHandler.this.messages.get("admin.conflicts.hours_ago", hoursAgo)).append("\n");
                }
                if (conflict.getOriginalNickname() != null && !conflict.getOriginalNickname().equals(conflict.getNickname())) {
                    conflictInfo.append(CommandHandler.CONFLICT_PREFIX).append(CommandHandler.this.messages.get("admin.conflicts.original_nick", conflict.getOriginalNickname(), new Object[0])).append("\n");
                }
                String statusKey = (isPremium = CommandHandler.this.databaseManager.isPlayerPremiumRuntime(conflict)) ? "admin.conflicts.status_premium" : "admin.conflicts.status_offline";
                conflictInfo.append(CommandHandler.CONFLICT_PREFIX).append(CommandHandler.this.messages.get(statusKey, new Object[0])).append("\n");
                source.sendMessage(ValidationUtils.createWarningComponent(conflictInfo.toString()));
            }
            source.sendMessage(ValidationUtils.createWarningComponent(""));
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.tips_header", new Object[0])));
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.tip_premium", new Object[0])));
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.tip_offline", new Object[0])));
            source.sendMessage(ValidationUtils.createWarningComponent(CommandHandler.this.messages.get("admin.conflicts.tip_admin", new Object[0])));
        }

        private void handleCacheResetCommand(CommandSource source, String[] args) {
            if (args.length == 2) {
                String nickname = args[1];
                CommandHandler.this.plugin.getServer().getPlayer(nickname).ifPresentOrElse(player -> {
                    CommandHandler.this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                    source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.cache_reset.player", nickname, new Object[0])));
                }, () -> source.sendMessage(ValidationUtils.createErrorComponent(CommandHandler.this.messages.get("admin.cache_reset.player_not_found", nickname, new Object[0]))));
            } else {
                CommandHandler.this.authCache.clearAll();
                source.sendMessage(ValidationUtils.createSuccessComponent(CommandHandler.this.messages.get("admin.cache_reset.success", new Object[0])));
            }
        }

        private void handleStatsCommand(CommandSource source) {
            CompletableFuture<Integer> totalF = CommandHandler.this.databaseManager.getTotalRegisteredAccounts();
            CompletableFuture<Integer> premiumF = CommandHandler.this.databaseManager.getTotalPremiumAccounts();
            CompletableFuture<Integer> nonPremiumF = CommandHandler.this.databaseManager.getTotalNonPremiumAccounts();
            CompletableFuture.allOf(totalF, premiumF, nonPremiumF).join();
            int total = totalF.join();
            int premium = premiumF.join();
            int nonPremium = nonPremiumF.join();
            double pct = total > 0 ? (double)premium * 100.0 / (double)total : 0.0;
            AuthCache.CacheStats cacheStats = CommandHandler.this.authCache.getStats();
            int dbCacheSize = CommandHandler.this.databaseManager.getCacheSize();
            String dbStatus = CommandHandler.this.databaseManager.isConnected() ? CommandHandler.this.messages.get("database.connected", new Object[0]) : CommandHandler.this.messages.get("database.disconnected", new Object[0]);
            StringBuilder statsMessage = new StringBuilder();
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.header", new Object[0])).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.premium_accounts", premium)).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.nonpremium_accounts", nonPremium)).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.total_accounts", total)).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.premium_percentage", pct)).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.authorized_players", cacheStats.authorizedPlayersCount())).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.premium_cache", cacheStats.premiumCacheCount())).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.database_cache", dbCacheSize)).append("\n");
            statsMessage.append(CommandHandler.this.messages.get("admin.stats.database_status", dbStatus));
            CommandHelper.sendWarning(source, statsMessage.toString());
        }

        private void sendAdminHelp(CommandSource source) {
            source.sendMessage((Component)Component.text((String)"=== VeloAuth Admin ===", (TextColor)NamedTextColor.YELLOW));
            source.sendMessage((Component)Component.text((String)"/vauth reload - Reload configuration", (TextColor)NamedTextColor.YELLOW));
            source.sendMessage((Component)Component.text((String)"/vauth cache-reset [player] - Clear cache", (TextColor)NamedTextColor.YELLOW));
            source.sendMessage((Component)Component.text((String)"/vauth stats - Show statistics", (TextColor)NamedTextColor.YELLOW));
            source.sendMessage((Component)Component.text((String)"/vauth conflicts - List nickname conflicts", (TextColor)NamedTextColor.YELLOW));
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            String[] args = (String[])invocation.arguments();
            if (args.length == 1) {
                return List.of("reload", "cache-reset", "stats", "conflicts");
            }
            return List.of();
        }
    }

    private record AuthenticationContext(Player player, String username, InetAddress playerAddress, RegisteredPlayer registeredPlayer) {
    }
}

