/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IPRateLimiter {
    private final ConcurrentHashMap<InetAddress, RateLimitEntry> rateLimits;
    private final int maxAttempts;
    private final int timeoutMinutes;

    public IPRateLimiter(int maxAttempts, int timeoutMinutes) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("Max attempts must be > 0");
        }
        if (timeoutMinutes <= 0) {
            throw new IllegalArgumentException("Timeout minutes must be > 0");
        }
        this.rateLimits = new ConcurrentHashMap();
        this.maxAttempts = maxAttempts;
        this.timeoutMinutes = timeoutMinutes;
    }

    public boolean isRateLimited(InetAddress address) {
        if (address == null) {
            return false;
        }
        RateLimitEntry entry = this.rateLimits.get(address);
        if (entry == null) {
            return false;
        }
        if (entry.isExpired(this.timeoutMinutes)) {
            this.rateLimits.remove(address);
            return false;
        }
        return entry.getAttempts() >= this.maxAttempts;
    }

    public int incrementAttempts(InetAddress address) {
        if (address == null) {
            return 0;
        }
        RateLimitEntry entry = this.rateLimits.computeIfAbsent(address, k -> new RateLimitEntry());
        if (entry.isExpired(this.timeoutMinutes)) {
            entry.reset();
        }
        entry.increment();
        return entry.getAttempts();
    }

    public void reset(InetAddress address) {
        if (address != null) {
            this.rateLimits.remove(address);
        }
    }

    public int getAttempts(InetAddress address) {
        if (address == null) {
            return 0;
        }
        RateLimitEntry entry = this.rateLimits.get(address);
        if (entry == null) {
            return 0;
        }
        if (entry.isExpired(this.timeoutMinutes)) {
            this.rateLimits.remove(address);
            return 0;
        }
        return entry.getAttempts();
    }

    public void clearAll() {
        this.rateLimits.clear();
    }

    public int size() {
        return this.rateLimits.size();
    }

    private static class RateLimitEntry {
        private final AtomicInteger attempts = new AtomicInteger(0);
        private volatile long firstAttemptTime = System.currentTimeMillis();

        private RateLimitEntry() {
        }

        public void increment() {
            this.attempts.incrementAndGet();
        }

        public int getAttempts() {
            return this.attempts.get();
        }

        public void reset() {
            this.attempts.set(0);
            this.firstAttemptTime = System.currentTimeMillis();
        }

        public boolean isExpired(int timeoutMinutes) {
            long timeoutMillis = (long)timeoutMinutes * 60L * 1000L;
            return System.currentTimeMillis() - this.firstAttemptTime > timeoutMillis;
        }
    }
}

