/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.command;

import java.nio.charset.StandardCharsets;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.config.Settings;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static ValidationResult validatePassword(String password, Settings settings) {
        if (password == null || password.isEmpty()) {
            return ValidationResult.error("Has\u0142o nie mo\u017ce by\u0107 puste!");
        }
        if (password.length() < settings.getMinPasswordLength()) {
            return ValidationResult.error("Has\u0142o jest za kr\u00f3tkie! Minimum " + settings.getMinPasswordLength() + " znak\u00f3w.");
        }
        if (password.length() > settings.getMaxPasswordLength()) {
            return ValidationResult.error("Has\u0142o jest za d\u0142ugie! Maksimum " + settings.getMaxPasswordLength() + " znak\u00f3w.");
        }
        int byteLength = password.getBytes(StandardCharsets.UTF_8).length;
        if (byteLength > 72) {
            return ValidationResult.error("Has\u0142o jest zbyt d\u0142ugie w UTF-8 (" + byteLength + ") bajt\u00f3w, limit BCrypt to 72 bajty. U\u017cyj kr\u00f3tszego has\u0142a lub mniej znak\u00f3w Unicode.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validatePasswordMatch(String password, String confirmPassword) {
        if (!password.equals(confirmPassword)) {
            return ValidationResult.error("Has\u0142a nie s\u0105 identyczne!");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateArgumentCount(String[] args, int expectedCount, String usage) {
        if (args.length != expectedCount) {
            return ValidationResult.error(usage);
        }
        return ValidationResult.success();
    }

    public static Component createErrorComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.RED);
    }

    public static Component createSuccessComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.GREEN);
    }

    public static Component createWarningComponent(String message) {
        return Component.text((String)message, (TextColor)NamedTextColor.YELLOW);
    }

    public record ValidationResult(boolean valid, String message) {
        public static ValidationResult success() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult error(String message) {
            return new ValidationResult(false, message);
        }

        public String getErrorMessage() {
            return this.message;
        }
    }
}

