/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import net.rafalohaki.veloauth.database.DatabaseConfig;
import net.rafalohaki.veloauth.database.DatabaseType;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcAuthDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuthDao.class);
    private static final String TABLE_AUTH = "AUTH";
    private static final String COL_NICKNAME = "NICKNAME";
    private static final String COL_LOWERCASE_NICKNAME = "LOWERCASENICKNAME";
    private static final String COL_HASH = "HASH";
    private static final String COL_IP = "IP";
    private static final String COL_LOGIN_IP = "LOGINIP";
    private static final String COL_UUID = "UUID";
    private static final String COL_REG_DATE = "REGDATE";
    private static final String COL_LOGIN_DATE = "LOGINDATE";
    private static final String COL_PREMIUM_UUID = "PREMIUMUUID";
    private static final String COL_TOTP_TOKEN = "TOTPTOKEN";
    private static final String COL_ISSUED_TIME = "ISSUEDTIME";
    private static final String COL_CONFLICT_MODE = "CONFLICT_MODE";
    private static final String COL_CONFLICT_TIMESTAMP = "CONFLICT_TIMESTAMP";
    private static final String COL_ORIGINAL_NICKNAME = "ORIGINAL_NICKNAME";
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final String COMMA_SPACE_EQUALS_QUESTION = " = ?, ";
    private final DatabaseConfig config;
    private final boolean postgres;
    private final String selectPlayerSql;
    private final String insertPlayerSql;
    private final String updatePlayerSql;
    private final String deletePlayerSql;

    public JdbcAuthDao(DatabaseConfig config) {
        this.config = Objects.requireNonNull(config, "config nie mo\u017ce by\u0107 null");
        this.postgres = DatabaseType.POSTGRESQL.getName().equalsIgnoreCase(config.getStorageType());
        String authTable = this.table(TABLE_AUTH);
        String nicknameColumn = this.column(COL_NICKNAME);
        String lowercaseNicknameColumn = this.column(COL_LOWERCASE_NICKNAME);
        String hashColumn = this.column(COL_HASH);
        String ipColumn = this.column(COL_IP);
        String loginIpColumn = this.column(COL_LOGIN_IP);
        String uuidColumn = this.column(COL_UUID);
        String regDateColumn = this.column(COL_REG_DATE);
        String loginDateColumn = this.column(COL_LOGIN_DATE);
        String premiumUuidColumn = this.column(COL_PREMIUM_UUID);
        String totpTokenColumn = this.column(COL_TOTP_TOKEN);
        String issuedTimeColumn = this.column(COL_ISSUED_TIME);
        this.selectPlayerSql = "SELECT " + this.joinColumns(nicknameColumn, lowercaseNicknameColumn, hashColumn, ipColumn, loginIpColumn, uuidColumn, regDateColumn, loginDateColumn, premiumUuidColumn, totpTokenColumn, issuedTimeColumn) + " FROM " + authTable + WHERE_CLAUSE + lowercaseNicknameColumn + " = ?";
        this.insertPlayerSql = "INSERT INTO " + authTable + " (" + this.joinColumns(lowercaseNicknameColumn, nicknameColumn, hashColumn, ipColumn, loginIpColumn, uuidColumn, regDateColumn, loginDateColumn, premiumUuidColumn, totpTokenColumn, issuedTimeColumn) + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.updatePlayerSql = "UPDATE " + authTable + " SET " + nicknameColumn + COMMA_SPACE_EQUALS_QUESTION + hashColumn + COMMA_SPACE_EQUALS_QUESTION + ipColumn + COMMA_SPACE_EQUALS_QUESTION + loginIpColumn + COMMA_SPACE_EQUALS_QUESTION + uuidColumn + COMMA_SPACE_EQUALS_QUESTION + regDateColumn + COMMA_SPACE_EQUALS_QUESTION + loginDateColumn + COMMA_SPACE_EQUALS_QUESTION + premiumUuidColumn + COMMA_SPACE_EQUALS_QUESTION + totpTokenColumn + COMMA_SPACE_EQUALS_QUESTION + issuedTimeColumn + " = ? WHERE " + lowercaseNicknameColumn + " = ?";
        this.deletePlayerSql = "DELETE FROM " + authTable + WHERE_CLAUSE + lowercaseNicknameColumn + " = ?";
    }

    /*
     * Exception decompiling
     */
    public RegisteredPlayer findPlayerByLowercaseNickname(String lowercaseNickname) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean upsertPlayer(RegisteredPlayer player) throws SQLException {
        Objects.requireNonNull(player, "player nie mo\u017ce by\u0107 null");
        try (Connection connection = this.openConnection();){
            boolean previousAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try {
                int updated = this.executeUpdate(connection, player);
                if (updated == 0) {
                    this.executeInsert(connection, player);
                }
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(previousAutoCommit);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public boolean deletePlayer(String lowercaseNickname) throws SQLException {
        try (Connection connection = this.openConnection();){
            boolean bl;
            block12: {
                PreparedStatement statement = connection.prepareStatement(this.deletePlayerSql);
                try {
                    statement.setString(1, lowercaseNickname);
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean healthCheck() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int executeUpdate(Connection connection, RegisteredPlayer player) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.updatePlayerSql);){
            this.bindUpdate(statement, player);
            int n = statement.executeUpdate();
            return n;
        }
    }

    private void executeInsert(Connection connection, RegisteredPlayer player) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.insertPlayerSql);){
            this.bindInsert(statement, player);
            statement.executeUpdate();
        }
    }

    private void bindInsert(PreparedStatement statement, RegisteredPlayer player) throws SQLException {
        statement.setString(1, player.getLowercaseNickname());
        statement.setString(2, player.getNickname());
        statement.setString(3, player.getHash());
        statement.setString(4, player.getIp());
        statement.setString(5, player.getLoginIp());
        statement.setString(6, player.getUuid());
        statement.setLong(7, player.getRegDate());
        statement.setLong(8, player.getLoginDate());
        statement.setString(9, player.getPremiumUuid());
        statement.setString(10, player.getTotpToken());
        statement.setLong(11, player.getIssuedTime());
    }

    private void bindUpdate(PreparedStatement statement, RegisteredPlayer player) throws SQLException {
        statement.setString(1, player.getNickname());
        statement.setString(2, player.getHash());
        statement.setString(3, player.getIp());
        statement.setString(4, player.getLoginIp());
        statement.setString(5, player.getUuid());
        statement.setLong(6, player.getRegDate());
        statement.setLong(7, player.getLoginDate());
        statement.setString(8, player.getPremiumUuid());
        statement.setString(9, player.getTotpToken());
        statement.setLong(10, player.getIssuedTime());
        statement.setString(11, player.getLowercaseNickname());
    }

    private RegisteredPlayer mapPlayer(ResultSet resultSet) throws SQLException {
        RegisteredPlayer player = new RegisteredPlayer();
        String nickname = null;
        try {
            nickname = resultSet.getString(COL_NICKNAME);
            if (nickname != null && !nickname.isEmpty()) {
                player.setNickname(nickname);
            }
        }
        catch (IllegalArgumentException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Nieprawid\u0142owy nickname w bazie danych", e);
            }
            throw new SQLException("Invalid nickname stored in database for player: " + nickname, e);
        }
        player.setHash(resultSet.getString(COL_HASH));
        player.setIp(resultSet.getString(COL_IP));
        player.setLoginIp(resultSet.getString(COL_LOGIN_IP));
        player.setUuid(resultSet.getString(COL_UUID));
        player.setRegDate(resultSet.getLong(COL_REG_DATE));
        player.setLoginDate(resultSet.getLong(COL_LOGIN_DATE));
        player.setPremiumUuid(resultSet.getString(COL_PREMIUM_UUID));
        player.setTotpToken(resultSet.getString(COL_TOTP_TOKEN));
        player.setIssuedTime(resultSet.getLong(COL_ISSUED_TIME));
        return player;
    }

    /*
     * Exception decompiling
     */
    public List<RegisteredPlayer> findAllPlayersInConflictMode() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RegisteredPlayer mapPlayerWithConflict(ResultSet resultSet) throws SQLException {
        RegisteredPlayer player = this.mapPlayer(resultSet);
        try {
            player.setConflictMode(resultSet.getBoolean(COL_CONFLICT_MODE));
        }
        catch (SQLException e) {
            player.setConflictMode(false);
        }
        try {
            player.setConflictTimestamp(resultSet.getLong(COL_CONFLICT_TIMESTAMP));
        }
        catch (SQLException e) {
            player.setConflictTimestamp(0L);
        }
        try {
            player.setOriginalNickname(resultSet.getString(COL_ORIGINAL_NICKNAME));
        }
        catch (SQLException e) {
            player.setOriginalNickname(null);
        }
        return player;
    }

    private Connection openConnection() throws SQLException {
        DataSource dataSource = this.config.getDataSource();
        if (dataSource != null) {
            return dataSource.getConnection();
        }
        String user = this.config.getUser();
        String password = this.config.getPassword();
        if (user != null || password != null) {
            return DriverManager.getConnection(this.config.getJdbcUrl(), user, password);
        }
        return DriverManager.getConnection(this.config.getJdbcUrl());
    }

    private String table(String name) {
        return this.postgres ? this.quote(name) : name;
    }

    private String column(String name) {
        return this.postgres ? this.quote(name) : name;
    }

    private String joinColumns(String ... columns) {
        return String.join((CharSequence)", ", columns);
    }

    private String quote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

