/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.rafalohaki.veloauth.libs.ormlite.dao.Dao;
import net.rafalohaki.veloauth.libs.ormlite.dao.DaoManager;
import net.rafalohaki.veloauth.libs.ormlite.misc.TransactionManager;
import net.rafalohaki.veloauth.libs.ormlite.stmt.DeleteBuilder;
import net.rafalohaki.veloauth.libs.ormlite.support.ConnectionSource;
import net.rafalohaki.veloauth.model.PremiumUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PremiumUuidDao {
    private static final Marker DB_MARKER = MarkerFactory.getMarker("DATABASE");
    private static final Logger logger = LoggerFactory.getLogger(PremiumUuidDao.class);
    private final Dao<PremiumUuid, String> dao;
    private final ConnectionSource connectionSource;

    public PremiumUuidDao(ConnectionSource connectionSource) throws SQLException {
        this.connectionSource = connectionSource;
        this.dao = DaoManager.createDao(connectionSource, PremiumUuid.class);
        logger.debug(DB_MARKER, "PremiumUuidDao zainicjalizowany");
    }

    public Optional<PremiumUuid> findByNickname(String nickname) {
        try {
            List results = this.dao.queryBuilder().where().eq("NICKNAME", nickname).query();
            if (results.isEmpty()) {
                logger.debug(DB_MARKER, "Nie znaleziono premium UUID dla nickname: {}", (Object)nickname);
                return Optional.empty();
            }
            PremiumUuid result = (PremiumUuid)results.get(0);
            logger.debug(DB_MARKER, "Znaleziono premium UUID dla {}: {} -> {}", nickname, result.getUuid(), result.getNickname());
            return Optional.of(result);
        }
        catch (SQLException e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas wyszukiwania premium UUID dla nickname: {}", (Object)nickname, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<PremiumUuid> findByUuid(UUID uuid) {
        try {
            PremiumUuid result = this.dao.queryForId(uuid.toString());
            if (result == null) {
                logger.debug(DB_MARKER, "Nie znaleziono premium UUID dla UUID: {}", (Object)uuid);
                return Optional.empty();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(DB_MARKER, "Znaleziono premium UUID dla {}: {}", (Object)uuid, (Object)result.getNickname());
            }
            return Optional.of(result);
        }
        catch (SQLException e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas wyszukiwania premium UUID dla UUID: {}", (Object)uuid, (Object)e);
            return Optional.empty();
        }
    }

    public boolean saveOrUpdate(UUID uuid, String nickname) {
        try {
            return TransactionManager.callInTransaction(this.connectionSource, () -> {
                Optional<PremiumUuid> existing = this.findByUuid(uuid);
                if (existing.isPresent()) {
                    PremiumUuid premiumUuid = existing.get();
                    if (!premiumUuid.getNickname().equals(nickname)) {
                        logger.info(DB_MARKER, "Aktualizacja nickname premium: {} -> {} (UUID: {})", premiumUuid.getNickname(), nickname, uuid);
                        premiumUuid.updateNickname(nickname);
                        this.dao.update(premiumUuid);
                    } else {
                        premiumUuid.updateLastSeen();
                        this.dao.update(premiumUuid);
                        logger.debug(DB_MARKER, "Zaktualizowano last_seen dla {}: {}", (Object)nickname, (Object)uuid);
                    }
                } else {
                    Optional<PremiumUuid> byNickname = this.findByNickname(nickname);
                    if (byNickname.isPresent() && !byNickname.get().getUuid().equals(uuid)) {
                        logger.warn(DB_MARKER, "Konflikt nickname! {} jest ju\u017c u\u017cywany przez {}, pr\u00f3ba zapisu z {}", nickname, byNickname.get().getUuid(), uuid);
                        this.dao.deleteById(byNickname.get().getUuidString());
                    }
                    PremiumUuid premiumUuid = new PremiumUuid(uuid, nickname);
                    this.dao.create(premiumUuid);
                    logger.info(DB_MARKER, "Zapisano nowy premium UUID: {} -> {}", (Object)nickname, (Object)uuid);
                }
                return true;
            });
        }
        catch (Exception e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas zapisu/aktualizacji premium UUID: {} -> {}", uuid, nickname, e);
            return false;
        }
    }

    public int cleanExpiredEntries(long ttlMinutes) {
        try {
            long cutoffTime = System.currentTimeMillis() - ttlMinutes * 60L * 1000L;
            DeleteBuilder<PremiumUuid, String> deleteBuilder = this.dao.deleteBuilder();
            deleteBuilder.where().lt("LAST_SEEN", cutoffTime);
            int deleted = deleteBuilder.delete();
            if (deleted > 0) {
                logger.info(DB_MARKER, "Usuni\u0119to {} przestarza\u0142ych wpis\u00f3w premium UUID (TTL: {} min)", (Object)deleted, (Object)ttlMinutes);
            }
            return deleted;
        }
        catch (SQLException e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas czyszczenia przestarza\u0142ych wpis\u00f3w premium UUID", e);
            return 0;
        }
    }

    public long getTotalCount() {
        try {
            return this.dao.countOf();
        }
        catch (SQLException e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas liczenia wpis\u00f3w premium UUID", e);
            return 0L;
        }
    }

    public List<PremiumUuid> findAll() {
        try {
            return this.dao.queryForAll();
        }
        catch (SQLException e) {
            logger.error(DB_MARKER, "B\u0142\u0105d podczas pobierania wszystkich wpis\u00f3w premium UUID", e);
            return new ArrayList<PremiumUuid>();
        }
    }
}

