/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageFileManager {
    private static final Logger logger = LoggerFactory.getLogger(LanguageFileManager.class);
    private final Path langDirectory;

    public LanguageFileManager(Path dataDirectory) {
        this.langDirectory = dataDirectory.resolve("lang");
    }

    public void initializeLanguageFiles() throws IOException {
        if (!Files.exists(this.langDirectory, new LinkOption[0])) {
            Files.createDirectories(this.langDirectory, new FileAttribute[0]);
            logger.info("Created language directory: {}", (Object)this.langDirectory);
        }
        this.copyDefaultLanguageFile("messages_en.properties");
        this.copyDefaultLanguageFile("messages_pl.properties");
    }

    private void copyDefaultLanguageFile(String filename) throws IOException {
        Path targetFile = this.langDirectory.resolve(filename);
        if (!Files.exists(targetFile, new LinkOption[0])) {
            try (InputStream is = this.getClass().getResourceAsStream("/lang/" + filename);){
                if (is == null) {
                    logger.error("Default language file not found in JAR: {}", (Object)filename);
                    return;
                }
                Files.copy(is, targetFile, new CopyOption[0]);
                logger.info("Copied default language file: {}", (Object)filename);
            }
        } else {
            logger.debug("Language file already exists: {}", (Object)filename);
        }
    }

    public ResourceBundle loadLanguageBundle(String language) throws IOException {
        String filename = "messages_" + language + ".properties";
        Path languageFile = this.langDirectory.resolve(filename);
        if (!Files.exists(languageFile, new LinkOption[0])) {
            logger.warn("Language file not found: {}, falling back to English", (Object)filename);
            languageFile = this.langDirectory.resolve("messages_en.properties");
        }
        if (!Files.exists(languageFile, new LinkOption[0])) {
            throw new IOException("English fallback language file not found at: " + String.valueOf(languageFile));
        }
        try (InputStream is = Files.newInputStream(languageFile, new OpenOption[0]);){
            PropertyResourceBundle propertyResourceBundle;
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                propertyResourceBundle = new PropertyResourceBundle(reader);
            }
            return propertyResourceBundle;
        }
    }

    public void validateLanguageFile(String language) {
        try {
            ResourceBundle bundle = this.loadLanguageBundle(language);
            logger.info("Validated language file for: {}", (Object)language);
            logger.debug("Language file contains {} keys", (Object)bundle.keySet().size());
        }
        catch (IOException e) {
            logger.error("Failed to validate language file for: {}", (Object)language, (Object)e);
        }
    }
}

