/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.i18n;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.i18n.Messages;

public final class SimpleMessages {
    private final Messages messages;

    public SimpleMessages(Messages messages) {
        this.messages = messages;
    }

    public Component key(String key, NamedTextColor color, Object ... args) {
        return Component.text((String)this.messages.get(key, args), (TextColor)color);
    }

    public Component loginSuccess() {
        return this.key("auth.login.success", NamedTextColor.GREEN, new Object[0]);
    }

    public Component loginFailed() {
        return this.key("auth.login.incorrect_password", NamedTextColor.RED, new Object[0]);
    }

    public Component registerSuccess() {
        return this.key("auth.register.success", NamedTextColor.GREEN, new Object[0]);
    }

    public Component alreadyLogged() {
        return this.key("auth.login.already_logged_in", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component notRegistered() {
        return this.key("auth.login.not_registered", NamedTextColor.RED, new Object[0]);
    }

    public Component errorDatabase() {
        return this.key("error.database.query", NamedTextColor.RED, new Object[0]);
    }

    public Component errorGeneric() {
        return this.key("error.unknown_command", NamedTextColor.RED, new Object[0]);
    }

    public Component bruteforce(int minutes) {
        return this.key("security.brute_force.blocked", NamedTextColor.YELLOW, minutes);
    }

    public Component passwordShort(int min2) {
        return this.key("auth.register.password_too_short", NamedTextColor.RED, min2);
    }

    public Component passwordMismatch() {
        return this.key("auth.register.passwords_no_match", NamedTextColor.RED, new Object[0]);
    }

    public Component usageLogin() {
        return this.key("auth.login.usage", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component usageRegister() {
        return this.key("auth.register.usage", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component usageChangePassword() {
        return this.key("auth.changepassword.usage", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component nickConflict() {
        return this.key("player.conflict.header", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component nickReserved() {
        return this.key("player.conflict.description", NamedTextColor.YELLOW, new Object[0]);
    }

    public Component invalidUsername() {
        return this.key("validation.username.invalid", NamedTextColor.RED, new Object[0]);
    }

    public Component sessionExpired() {
        return this.key("security.session.expired", NamedTextColor.YELLOW, new Object[0]);
    }
}

