/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.deser.std;

import java.io.IOException;
import net.rafalohaki.veloauth.libs.jackson.core.JsonParser;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.databind.DeserializationContext;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonMappingException;
import net.rafalohaki.veloauth.libs.jackson.databind.annotation.JacksonStdImpl;
import net.rafalohaki.veloauth.libs.jackson.databind.deser.std.StdScalarDeserializer;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeDeserializer;
import net.rafalohaki.veloauth.libs.jackson.databind.type.LogicalType;

@JacksonStdImpl
public class StringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;
    public static final StringDeserializer instance = new StringDeserializer();

    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Textual;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return "";
    }

    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return p.getText();
        }
        if (p.hasToken(JsonToken.START_ARRAY)) {
            return (String)this._deserializeFromArray(p, ctxt);
        }
        return this._parseString(p, ctxt, this);
    }

    @Override
    public String deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }
}

