/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.jsontype;

import java.io.IOException;
import net.rafalohaki.veloauth.libs.jackson.annotation.JsonTypeInfo;
import net.rafalohaki.veloauth.libs.jackson.core.JsonParser;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.databind.BeanProperty;
import net.rafalohaki.veloauth.libs.jackson.databind.DeserializationContext;
import net.rafalohaki.veloauth.libs.jackson.databind.JavaType;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeIdResolver;

public abstract class TypeDeserializer {
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public boolean hasDefaultImpl() {
        return this.getDefaultImpl() != null;
    }

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2) throws IOException;

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2) throws IOException;

    public static Object deserializeIfNatural(JsonParser p, DeserializationContext ctxt, JavaType baseType) throws IOException {
        return TypeDeserializer.deserializeIfNatural(p, ctxt, baseType.getRawClass());
    }

    public static Object deserializeIfNatural(JsonParser p, DeserializationContext ctxt, Class<?> base) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == null) {
            return null;
        }
        switch (t2) {
            case VALUE_STRING: {
                if (!base.isAssignableFrom(String.class)) break;
                return p.getText();
            }
            case VALUE_NUMBER_INT: {
                if (!base.isAssignableFrom(Integer.class)) break;
                return p.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!base.isAssignableFrom(Double.class)) break;
                return p.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!base.isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!base.isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

