/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import net.rafalohaki.veloauth.libs.jackson.core.JsonGenerator;
import net.rafalohaki.veloauth.libs.jackson.core.JsonToken;
import net.rafalohaki.veloauth.libs.jackson.core.type.WritableTypeId;
import net.rafalohaki.veloauth.libs.jackson.databind.JavaType;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonMappingException;
import net.rafalohaki.veloauth.libs.jackson.databind.JsonNode;
import net.rafalohaki.veloauth.libs.jackson.databind.SerializerProvider;
import net.rafalohaki.veloauth.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.rafalohaki.veloauth.libs.jackson.databind.jsontype.TypeSerializer;
import net.rafalohaki.veloauth.libs.jackson.databind.ser.std.StdSerializer;

public abstract class ToStringSerializerBase
extends StdSerializer<Object> {
    public ToStringSerializerBase(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return this.valueToString(value).isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.valueToString(value));
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }

    public abstract String valueToString(Object var1);
}

