/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.jackson.databind.type;

import java.util.Objects;
import net.rafalohaki.veloauth.libs.jackson.databind.JavaType;
import net.rafalohaki.veloauth.libs.jackson.databind.type.SimpleType;
import net.rafalohaki.veloauth.libs.jackson.databind.type.TypeBase;
import net.rafalohaki.veloauth.libs.jackson.databind.type.TypeBindings;

public class IterationType
extends SimpleType {
    private static final long serialVersionUID = 1L;
    protected final JavaType _iteratedType;

    protected IterationType(Class<?> cls, TypeBindings bindings, JavaType superClass, JavaType[] superInts, JavaType iteratedType, Object valueHandler, Object typeHandler, boolean asStatic) {
        super(cls, bindings, superClass, superInts, Objects.hashCode(iteratedType), valueHandler, typeHandler, asStatic);
        this._iteratedType = iteratedType;
    }

    protected IterationType(TypeBase base, JavaType iteratedType) {
        super(base);
        this._iteratedType = iteratedType;
    }

    public static IterationType upgradeFrom(JavaType baseType, JavaType iteratedType) {
        Objects.requireNonNull(iteratedType);
        if (baseType instanceof TypeBase) {
            return new IterationType((TypeBase)baseType, iteratedType);
        }
        throw new IllegalArgumentException("Cannot upgrade from an instance of " + baseType.getClass());
    }

    public static IterationType construct(Class<?> cls, TypeBindings bindings, JavaType superClass, JavaType[] superInts, JavaType iteratedType) {
        return new IterationType(cls, bindings, superClass, superInts, iteratedType, null, null, false);
    }

    @Override
    public JavaType withContentType(JavaType contentType) {
        if (this._iteratedType == contentType) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, contentType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public IterationType withTypeHandler(Object h2) {
        if (h2 == this._typeHandler) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, this._iteratedType, this._valueHandler, h2, this._asStatic);
    }

    @Override
    public IterationType withContentTypeHandler(Object h2) {
        if (h2 == this._iteratedType.getTypeHandler()) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, this._iteratedType.withTypeHandler(h2), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public IterationType withValueHandler(Object h2) {
        if (h2 == this._valueHandler) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, this._iteratedType, h2, this._typeHandler, this._asStatic);
    }

    @Override
    public IterationType withContentValueHandler(Object h2) {
        if (h2 == this._iteratedType.getValueHandler()) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, this._iteratedType.withValueHandler(h2), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public IterationType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new IterationType(this._class, this._bindings, this._superClass, this._superInterfaces, this._iteratedType.withStaticTyping(), this._valueHandler, this._typeHandler, true);
    }

    @Override
    public JavaType refine(Class<?> rawType, TypeBindings bindings, JavaType superClass, JavaType[] superInterfaces) {
        return new IterationType(rawType, this._bindings, superClass, superInterfaces, this._iteratedType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._class.getName());
        if (this._iteratedType != null && this._hasNTypeParameters(1)) {
            sb.append('<');
            sb.append(this._iteratedType.toCanonical());
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public JavaType getContentType() {
        return this._iteratedType;
    }

    @Override
    public boolean hasContentType() {
        return true;
    }

    @Override
    public boolean isIterationType() {
        return true;
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder sb) {
        return IterationType._classSignature(this._class, sb, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder sb) {
        IterationType._classSignature(this._class, sb, false);
        sb.append('<');
        sb = this._iteratedType.getGenericSignature(sb);
        sb.append(">;");
        return sb;
    }
}

