/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.field.types;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Arrays;
import net.rafalohaki.veloauth.libs.ormlite.field.FieldType;
import net.rafalohaki.veloauth.libs.ormlite.field.SqlType;
import net.rafalohaki.veloauth.libs.ormlite.field.types.BaseDataType;
import net.rafalohaki.veloauth.libs.ormlite.support.DatabaseResults;

public class ByteArrayType
extends BaseDataType {
    private static final ByteArrayType singleTon = new ByteArrayType();

    public static ByteArrayType getSingleton() {
        return singleTon;
    }

    private ByteArrayType() {
        super(SqlType.BYTE_ARRAY);
    }

    protected ByteArrayType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        return defaultStr == null ? null : this.getBytesImpl(fieldType, defaultStr);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getBytes(columnPos);
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return true;
    }

    @Override
    public boolean dataIsEqual(Object fieldObj1, Object fieldObj2) {
        if (fieldObj1 == null) {
            return fieldObj2 == null;
        }
        if (fieldObj2 == null) {
            return false;
        }
        return Arrays.equals((byte[])fieldObj1, (byte[])fieldObj2);
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        return this.getBytesImpl(fieldType, stringValue);
    }

    @Override
    public Class<?> getPrimaryClass() {
        return byte[].class;
    }

    @Override
    public boolean isAppropriateId() {
        return true;
    }

    private Object getBytesImpl(FieldType fieldType, String stringValue) throws SQLException {
        if (fieldType == null || fieldType.getFormat() == null) {
            return stringValue.getBytes();
        }
        try {
            return stringValue.getBytes(fieldType.getFormat());
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Could not convert default string: " + stringValue, e);
        }
    }
}

