/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.field.types;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import net.rafalohaki.veloauth.libs.ormlite.field.FieldType;
import net.rafalohaki.veloauth.libs.ormlite.field.SqlType;
import net.rafalohaki.veloauth.libs.ormlite.field.types.DateStringFormatConfig;
import net.rafalohaki.veloauth.libs.ormlite.field.types.DateType;

public class SqlDateType
extends DateType {
    private static final SqlDateType singleTon = new SqlDateType();
    private static final DateStringFormatConfig sqlDateFormatConfig = new DateStringFormatConfig("yyyy-MM-dd");

    public static SqlDateType getSingleton() {
        return singleTon;
    }

    private SqlDateType() {
        super(SqlType.DATE, new Class[]{Date.class});
    }

    protected SqlDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        Timestamp value = (Timestamp)sqlArg;
        return new Date(value.getTime());
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Date date = (Date)javaObject;
        return new Timestamp(date.getTime());
    }

    @Override
    protected DateStringFormatConfig getDefaultDateFormatConfig() {
        return sqlDateFormatConfig;
    }

    @Override
    public boolean isValidForField(Field field) {
        return field.getType() == Date.class;
    }
}

