/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.jdbc.db;

import java.util.ArrayList;
import java.util.List;
import net.rafalohaki.veloauth.libs.ormlite.db.DatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.Db2DatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.DerbyClientServerDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.DerbyEmbeddedDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.GenericOdbcDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.H2DatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.HsqldbDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.MariaDbDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.MysqlDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.NetezzaDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.OracleDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.PostgresDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.SqlServerDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.SqlServerJtdsDatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.jdbc.db.SqliteDatabaseType;

public class DatabaseTypeUtils {
    private static List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();

    private DatabaseTypeUtils() {
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        for (DatabaseType databaseType : databaseTypes) {
            if (!databaseType.isDatabaseUrlThisType(databaseUrl, dbTypePart)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        databaseTypes.add(new Db2DatabaseType());
        databaseTypes.add(new DerbyClientServerDatabaseType());
        databaseTypes.add(new DerbyEmbeddedDatabaseType());
        databaseTypes.add(new GenericOdbcDatabaseType());
        databaseTypes.add(new H2DatabaseType());
        databaseTypes.add(new HsqldbDatabaseType());
        databaseTypes.add(new MysqlDatabaseType());
        databaseTypes.add(new MariaDbDatabaseType());
        databaseTypes.add(new NetezzaDatabaseType());
        databaseTypes.add(new OracleDatabaseType());
        databaseTypes.add(new PostgresDatabaseType());
        databaseTypes.add(new SqliteDatabaseType());
        databaseTypes.add(new SqlServerDatabaseType());
        databaseTypes.add(new SqlServerJtdsDatabaseType());
    }
}

